/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;

public class TimeFunctions {
    private static long timeElapsed = 0L;
    private static final int MAX_WAIT_FRAMES = 20;
    private static int curFrame = 0;

    public static void updateTimeSegs() {
        if (!Qdc.RevelationStuff.isRevelationReady && ++curFrame >= 20 && Qdc.RevelationStuff.revelationStart > -1L) {
            timeElapsed = TimeFunctions.getTimePassed(Qdc.RevelationStuff.revelationStart);
            if ((timeElapsed = Qdc.RevelationStuff.maxTime - timeElapsed) <= 0L) {
                Qdc.RevelationStuff.isRevelationReady = true;
                MainBox.REVELATION_BOX.generateRewards();
                GlobalFuncs.showInGameMessage("New Quantum Revelation rewards are available!");
                timeElapsed = 0L;
            }
            Qdc.RevelationStuff.timeSegs = TimeFunctions.translateTime(timeElapsed);
            curFrame = 0;
        }
    }

    public static void setStartTime() {
        Qdc.RevelationStuff.revelationStart = System.currentTimeMillis();
    }

    public static String generateTimeLeftString() {
        if (Qdc.RevelationStuff.timeSegs != null) {
            return TimeFunctions.fixTimeSegment(Qdc.RevelationStuff.timeSegs[0]) + ":" + TimeFunctions.fixTimeSegment(Qdc.RevelationStuff.timeSegs[1]);
        }
        return "00:00";
    }

    public static String fixTimeSegment(int seg) {
        if (seg < 10) {
            return "0" + seg;
        }
        return "" + seg;
    }

    public static int[] translateTime(long time) {
        int seconds = (int)(time / 1000L);
        int minute = seconds / 60;
        int second = seconds - minute * 60;
        return new int[]{minute, second};
    }

    public static long getTimePassed(long snapshot) {
        return System.currentTimeMillis() - snapshot;
    }
}

