/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions.pushy_pully_mergy;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity.PPM_BlockEntity;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PushyPullyMergyFunctions {
    public static BigDecimal calcStartPercentage(double amount) {
        return Qdc.PushyPullyMergyStuff.BASE_PERCENTAGE.multiply(new BigDecimal(amount));
    }

    public static boolean displayMonitorData(PPM_BlockEntity ppmBlockEntity, boolean isClientSIde) {
        if (!isClientSIde) {
            return false;
        }
        if (ppmBlockEntity.inventory.getStackInSlot(0).isEmpty()) {
            return false;
        }
        ArrayList<Object> msgs = new ArrayList<Object>();
        msgs.add("------------------------------");
        msgs.add("Item: " + GlobalFuncs.getItemName(ppmBlockEntity.inventory.getStackInSlot(0).getItem()));
        msgs.add("Level: " + ppmBlockEntity.mergeLevel);
        msgs.add("Regen %: " + ppmBlockEntity.percString);
        msgs.addAll(ppmBlockEntity.particleData.getDisplayData());
        for (String string : msgs) {
            GlobalFuncs.showInGameMessage(string);
        }
        return true;
    }

    public static BlockPos getNextBlockPos(BlockPos pos, Direction dir) {
        return PushyPullyMergyFunctions.movePPMBlock(pos, dir, false);
    }

    public static BlockPos movePPMBlock(BlockPos pos, Direction dir, boolean isSneaking) {
        Direction tempDirection = dir;
        if (isSneaking) {
            tempDirection = dir.getOpposite();
        }
        switch (tempDirection) {
            case DOWN: {
                return pos.above();
            }
            case EAST: {
                return pos.west();
            }
            case NORTH: {
                return pos.south();
            }
            case SOUTH: {
                return pos.north();
            }
            case UP: {
                return pos.below();
            }
            case WEST: {
                return pos.east();
            }
        }
        return pos;
    }

    public static boolean mergePpmBlocks(Player player, Level level, Direction dir, PPM_BlockEntity ppmBlockEntity, BlockPos pos, boolean isCLientSide) {
        List<BlockPos> mergePosList = PushyPullyMergyFunctions.getMergePosList(level, dir, ppmBlockEntity, pos);
        if (mergePosList.size() < 3) {
            return false;
        }
        int numOfBlocksToMerge = 0;
        int numOfBlocksToCreate = 0;
        if (mergePosList.size() >= 3 && mergePosList.size() < 5) {
            numOfBlocksToMerge = 3;
            numOfBlocksToCreate = 1;
        }
        if (mergePosList.size() == 5) {
            numOfBlocksToMerge = 5;
            numOfBlocksToCreate = 2;
        }
        PushyPullyMergyFunctions.removeBLocks(level, mergePosList, numOfBlocksToMerge, numOfBlocksToCreate);
        PushyPullyMergyFunctions.updateNewBlocks(level, mergePosList, numOfBlocksToCreate, isCLientSide);
        return true;
    }

    private static void updateNewBlocks(Level level, List<BlockPos> mergePosList, int newBlockCOunt, boolean isCLientSide) {
        for (int i = 0; i < newBlockCOunt; ++i) {
            BlockEntity blockEntity = level.getBlockEntity(mergePosList.get(i));
            if (!(blockEntity instanceof PPM_BlockEntity)) continue;
            PPM_BlockEntity ppm_BlockEntity = (PPM_BlockEntity)blockEntity;
            if (!isCLientSide) {
                ppm_BlockEntity.addParticlesToGlobalRegen();
            }
            ppm_BlockEntity.upgradeBlockeEntity();
        }
    }

    private static void removeBLocks(Level level, List<BlockPos> mergePosList, int len, int newBlockCOunt) {
        for (int i = newBlockCOunt; i < len; ++i) {
            level.setBlockAndUpdate(mergePosList.get(i), Blocks.AIR.defaultBlockState());
        }
    }

    private static List<BlockPos> getMergePosList(Level level, Direction dir, PPM_BlockEntity ppmBlockEntity, BlockPos pos) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        res.add(pos);
        BlockPos curPos = pos;
        for (int i = 0; i < 4 && PushyPullyMergyFunctions.isSamePpmBlock(level, ppmBlockEntity, curPos = PushyPullyMergyFunctions.getNextBlockPos(curPos, dir)); ++i) {
            res.add(curPos);
        }
        return res;
    }

    private static boolean isSamePpmBlock(Level level, PPM_BlockEntity targetBlockEntity, BlockPos pos) {
        PPM_BlockEntity ppm_BlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof PPM_BlockEntity && targetBlockEntity.isSameBlockEntityValues(ppm_BlockEntity = (PPM_BlockEntity)blockEntity);
    }

    public static void playMonitorSound(Player player, Level level, BlockPos pos) {
        level.playSound((Entity)player, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 2.0f);
    }

    public static void playMergeSound(Player player, Level level, BlockPos pos) {
        level.playSound((Entity)player, pos, SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.BLOCKS, 1.0f, 2.0f);
    }

    public static void playErrorSound(Player player, Level level, BlockPos pos) {
        level.playSound((Entity)player, pos, SoundEvents.BAT_TAKEOFF, SoundSource.BLOCKS, 1.0f, 2.0f);
    }

    public class TimeFunctions {
        public static long start = -1L;

        public TimeFunctions(PushyPullyMergyFunctions this$0) {
        }

        public static void checkForRegenTime() {
            if (start < 0L) {
                start = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - start >= 30000L) {
                QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.addRegenParticles();
                start = System.currentTimeMillis();
            }
        }
    }
}

