/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes;

import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.ElevatorRangeData;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevatorPlatform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.tile_entity_elevator_platform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.settings.ElevatorSettings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public class QdcElevator {
    public BlockPos pos = null;
    public boolean isInRange = false;
    public boolean isInElevatorMode = false;
    public Point mapPos = null;
    private ElevatorRangeData rangeData = null;
    public List<QdcElevatorPlatform> platforms = new ArrayList<QdcElevatorPlatform>();
    public String elevatorName = null;
    public String tooltip = null;

    public QdcElevator(tile_entity_elevator_platform te, BlockPos pos, String elevatorName, String platformName) {
        this.pos = pos;
        this.elevatorName = elevatorName;
        this.platforms.add(new QdcElevatorPlatform(te, pos, elevatorName, platformName));
    }

    public QdcElevator isHoveringOver(Point windowPos, int x, int y) {
        if (GuiFunctions.isHoveringOver(windowPos, this.mapPos, ElevatorSettings.WORK_WINDOW.MAP.ITEM.SIZE, new Point(x, y))) {
            return this;
        }
        return null;
    }

    private void calcGuiPos() {
        this.mapPos = null;
        if (this.isInRange && this.rangeData != null) {
            this.mapPos = this.rangeData.calcGuiPos(this.pos);
        }
    }

    public void calcPlatformsGuiPos() {
        for (int i = 0; i < this.platforms.size(); ++i) {
            this.platforms.get(i).setGuiPos(i);
        }
    }

    private void setToolTip() {
        this.tooltip = this.elevatorName + " [" + this.platforms.size() + "]";
    }

    public QdcElevatorPlatform getHoverPlatform(Point windowPos, int x, int y) {
        QdcElevatorPlatform cur = null;
        for (QdcElevatorPlatform p : this.platforms) {
            cur = p.isHoveringOver(windowPos, x, y);
            if (cur == null) continue;
            return p;
        }
        return null;
    }

    public void notifyChildrenOnElevatorNameChange(String newName) {
        for (QdcElevatorPlatform p : this.platforms) {
            p.updateElevatorName(newName);
        }
        this.setToolTip();
    }

    public void addPlatform(tile_entity_elevator_platform te, BlockPos pos, String elevatorName, String platformName) {
        int index = this.getInsertIndex(pos);
        this.platforms.add(index, new QdcElevatorPlatform(te, pos, elevatorName, platformName));
        this.checkForElevatorMode();
    }

    public void checkForPlatformAvailability() {
        if (this.platforms == null) {
            return;
        }
        for (QdcElevatorPlatform curPlatform : this.platforms) {
            curPlatform.checkIfAvailable();
        }
    }

    public void checkIfIsInRange(ElevatorRangeData rangeData) {
        this.isInRange = rangeData.isInRange(this.pos);
        for (QdcElevatorPlatform curPlatform : this.platforms) {
            curPlatform.setIsInRange(this.isInRange);
        }
        this.rangeData = this.isInRange ? rangeData : null;
        this.setToolTip();
        this.calcGuiPos();
        this.calcPlatformsGuiPos();
    }

    public void checkForElevatorMode() {
        this.isInElevatorMode = this.platforms.size() > 1;
        for (QdcElevatorPlatform curPlatform : this.platforms) {
            curPlatform.setIsInElevatorMode(this.isInElevatorMode);
        }
    }

    private int getInsertIndex(BlockPos pos) {
        if (this.platforms.size() == 0) {
            return 0;
        }
        if (this.platforms.size() == 1) {
            if (this.platforms.get(0).isHigher(pos)) {
                return 1;
            }
            return 0;
        }
        int index = 0;
        for (QdcElevatorPlatform curPlatform : this.platforms) {
            if (curPlatform.isLower(pos)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public void handleNotifyRemove(BlockPos pos) {
        if (!this.isSameElevatorPos(pos)) {
            return;
        }
        int removeIndex = this.getRemoveIndex(pos);
        if (removeIndex > -1) {
            this.platforms.remove(removeIndex);
            GlobalFuncs.msg("removeIndex " + removeIndex);
            this.checkForElevatorMode();
        }
    }

    private int getRemoveIndex(BlockPos pos) {
        for (int i = 0; i < this.platforms.size(); ++i) {
            if (!this.platforms.get(i).isSame(pos)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSameElevatorPos(BlockPos pos) {
        return pos.getX() == this.pos.getX() && pos.getZ() == this.pos.getZ();
    }
}

