/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entity_renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_enchanter;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.ItemInit;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class EnchanterBlockEntityRenderer
implements BlockEntityRenderer<tile_entity_enchanter> {
    private final Color TITLE_COLOR = BERFunctions.COLORS.TITLE_COLOR;
    private final Color TEXT_COLOR = BERFunctions.COLORS.TEXT_COLOR;
    private final Color MAIN_ITEN_NAME_COLOR = BERFunctions.COLORS.MAIN_ITEN_NAME_COLOR;
    private final float PLAYER_ANGLE_OFFSET = -90.0f;
    private final BlockEntityRendererProvider.Context context;
    private float lookToPlayerAngle = 0.0f;
    private String machineName = null;
    private ItemStack chickenEgg = new ItemStack((ItemLike)Items.EGG);
    private final PosePoint mainIconPos = BERFunctions.POSITIONS.MAIN_ICON_POS;
    private final PosePoint powerIconPos = new PosePoint(1.98f, -1.1f);
    private final PosePoint mainItemNamePos = BERFunctions.POSITIONS.mainItemNamePos;
    private final PosePoint mainTextPos = BERFunctions.POSITIONS.mainTextPos;
    private final PosePoint machineNamePos = BERFunctions.POSITIONS.machineNamePos;
    private final PosePoint powerTitlePos = new PosePoint(80.0f, 5.0f);
    private final PosePoint powerValuePos = new PosePoint(80.0f, 17.0f);
    private final PosePoint enchantmentTitlePos = new PosePoint(-70.0f, 5.0f);
    private final PosePoint enchantmentOnePos = new PosePoint(-70.0f, 17.0f);
    private final PosePoint enchantmentTwoPos = new PosePoint(-70.0f, 29.0f);
    private final PosePoint enchantmentThreePos = new PosePoint(-70.0f, 41.0f);
    private final PosePoint costTitlePos = new PosePoint(-120.0f, 56.0f);
    private final PosePoint costPos = new PosePoint(-45.0f, 56.0f);

    public EnchanterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull tile_entity_enchanter te, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, Vec3 cameraPos) {
        ItemStack mainStack = te.getItemStack();
        ItemStack speedStack = te.getSpeedStack();
        Level level = te.getLevel();
        if (level == null) {
            return;
        }
        this.machineName = te.machineData._machineName;
        LocalPlayer player = Minecraft.getInstance().player;
        String toolTip = te.machineData._toolTip;
        Color toolTipColor = te.machineData._toolTipColor;
        Font font = this.context.getFont();
        BlockPos pos = te.getBlockPos().above();
        int packedLight = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
        this.lookToPlayerAngle = BERFunctions.calcToPlayerAngle((Player)player, pos, -90.0f);
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(this.lookToPlayerAngle));
        poseStack.scale(2.0f, 1.0f, 1.0f);
        this.drawBackground(poseStack, pBuffer, level, packedLight);
        poseStack.scale(0.5f, 1.0f, 1.0f);
        poseStack.translate(0.0f, 0.0f, 0.05f);
        this.drawIcons(mainStack, this.chickenEgg, speedStack, poseStack, pBuffer, level, packedLight);
        this.writeAllText(toolTip, te.machineData._powerString, te.machineData._mainItemName, te.machineData._enchant1, te.machineData._enchant2, te.machineData._enchant3, te.machineData._cost, toolTipColor, font, poseStack, pBuffer, packedLight);
        poseStack.popPose();
    }

    private void drawBackground(PoseStack poseStack, MultiBufferSource buffer, Level level, int packedLight) {
        this.context.getItemRenderer().renderStatic(new ItemStack((ItemLike)ItemInit.QDC_MACHINE_SCREEN_BG.get()), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, level, 0);
    }

    private void drawIcons(ItemStack mainItemStack, ItemStack sizeStack, ItemStack speedStack, PoseStack ps, MultiBufferSource buffer, Level level, int packedLight) {
        float scale = 0.25f;
        ps.scale(scale, scale, scale);
        if (mainItemStack != null) {
            BERFunctions.drawIcon(this.mainIconPos, this.context, mainItemStack, ps, buffer, level, packedLight);
        }
        if (speedStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.powerIconPos, this.context, speedStack, ps, buffer, level, packedLight);
        }
    }

    private void writeAllText(String mainText, String powerString, String mainItemName, String enc1, String enc2, String enc3, String cost, Color color, Font font, PoseStack ps, MultiBufferSource buffer, int packedLight) {
        float scale = 0.025f;
        ps.scale(scale, scale, scale);
        ps.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        BERFunctions.writeText(this.mainTextPos, mainText, color, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.machineNamePos, this.machineName, this.TITLE_COLOR, font, ps, buffer, packedLight);
        if (!mainItemName.isEmpty()) {
            BERFunctions.writeText(this.mainItemNamePos, mainItemName, this.MAIN_ITEN_NAME_COLOR, font, ps, buffer, packedLight);
        }
        BERFunctions.writeText(this.powerTitlePos, "Enchantment Power", this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.powerValuePos, powerString, this.TEXT_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.enchantmentTitlePos, "Enchantments", this.TITLE_COLOR, font, ps, buffer, packedLight);
        if (!enc1.isEmpty()) {
            BERFunctions.writeText(this.enchantmentOnePos, enc1, this.TEXT_COLOR, font, ps, buffer, packedLight);
        }
        if (!enc2.isEmpty()) {
            BERFunctions.writeText(this.enchantmentTwoPos, enc2, this.TEXT_COLOR, font, ps, buffer, packedLight);
        }
        if (!enc3.isEmpty()) {
            BERFunctions.writeText(this.enchantmentThreePos, enc3, this.TEXT_COLOR, font, ps, buffer, packedLight);
        }
        BERFunctions.writeText(this.costTitlePos, "Cost: ", this.TITLE_COLOR, font, ps, buffer, packedLight);
        if (!cost.isEmpty()) {
            BERFunctions.writeText(this.costPos, cost + " Nature Particles", color, font, ps, buffer, packedLight);
        }
    }
}

