/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.DisassemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.QdcMachines;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.NextFrontBlockFinder;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_item_placer
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData machineData = new MachineData("Item Placer");
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public ParticleCollection fuelParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public ArrayList<BlockPos> workArea = null;
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public boolean hasFuel = false;
    public boolean hasItemParticles = false;
    public boolean powered = true;
    public boolean isInStorage = true;
    public boolean hasInvSpace = true;
    public boolean hasInv = true;
    public Block curInvBlock = null;
    private boolean isSpeedSet = false;
    private Direction placerDirection = null;
    private IItemHandler blockInventoryHandler = null;

    public tile_entity_item_placer(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_ITEM_PLACER.get(), pos, state);
    }

    public ItemStack getSizeStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getSeedStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public ItemStack getCurInvBlockStack() {
        if (this.curInvBlock == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.curInvBlock);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setSpeed();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index == 0) {
            GlobalFuncs.showInGameMessage("Area size set to: " + this.machineData._sizeString);
        } else {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    public boolean updateSeed(Item item) {
        if (this.getSeedStack().getItem() == item) {
            return false;
        }
        if (!MainBox.isItemDiscovered(item)) {
            DisassemblerFunctions.setItemDiscovered(item);
        }
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)item));
        this.loadSeedItem();
        this.setChanged();
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        GlobalFuncs.showInGameMessage("Item set to: " + BERFunctions.getItemName(this.getSeedStack()));
        return true;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_item_placer.this.setChanged();
                if (slot == 1) {
                    tile_entity_item_placer.this.setSpeed();
                }
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (!this.getSeedStack().isEmpty()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getSeedStack());
                if (!this.hasInv) {
                    this.machineData._toolTip = "Block has No Inv!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasInvSpace) {
                    this.machineData._toolTip = "No Inv Space!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.powered) {
                    this.machineData._toolTip = "No redstone signal!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.isInStorage) {
                    this.machineData._toolTip = "No Items in Storage!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasFuel) {
                    this.machineData._toolTip = "No Fuel Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasItemParticles) {
                    this.machineData._toolTip = "No Item Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (this.isWorking) {
                    this.machineData._toolTip = "Working...!!!! ";
                    this.machineData._toolTipColor = Color.green;
                }
            } else {
                this.machineData._toolTip = "No Item selected!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private Item getCurSeed() {
        if (this.getSeedStack().isEmpty()) {
            return null;
        }
        return this.getSeedStack().getItem();
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            if (this.placerDirection == null) {
                this.placerDirection = (Direction)this.level.getBlockState(this.getBlockPos()).getValue(BlockProperties.FACING);
            }
            this.hasFuel = this.checkIfHasFuel();
            this.hasItemParticles = this.checkIfHasItemParticles();
            this.isInStorage = this.checkIfHasSeedsInStorage();
            this.hasInv = this.itemInFrontHasInventory();
            this.sendToClient();
            if (!this.getSeedStack().isEmpty()) {
                if (this.seedParticles == null) {
                    this.updateParticles();
                }
                if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                    this.powered = true;
                    if (this.hasInv && this.hasFuel && this.hasItemParticles && this.isInStorage) {
                        ++this.curTick;
                        this.isWorking = true;
                        if (this.curTick >= this.nextTarget) {
                            this.placeItemInInventory();
                            this.nextTarget = this.curDelayTicks;
                            this.curTick = 0;
                            this.tickPerc = 0;
                        }
                    } else {
                        this.isWorking = false;
                    }
                } else {
                    this.powered = false;
                }
            }
        }
    }

    private void placeItemInInventory() {
        int nextSlot = this.getSlotForItem();
        if (nextSlot > -1) {
            if (this.blockInventoryHandler.isItemValid(nextSlot, new ItemStack((ItemLike)this.getCurSeed()))) {
                this.hasInvSpace = true;
                ItemStack newStack = new ItemStack((ItemLike)this.getCurSeed(), 1);
                this.blockInventoryHandler.insertItem(nextSlot, newStack, false);
                QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.seedParticles);
                QdcApi.QDC_CORE.FUNCTIONS.removeFromStorage(this.getSeedStack().getItem(), 1);
            }
        } else {
            this.hasInvSpace = false;
        }
    }

    private int getSlotForItem() {
        ItemStack curStack = null;
        for (int i = 0; i < this.blockInventoryHandler.getSlots(); ++i) {
            curStack = this.blockInventoryHandler.getStackInSlot(i);
            if (curStack.isEmpty()) {
                return i;
            }
            if (curStack.getItem() != this.getCurSeed() || curStack.getMaxStackSize() <= curStack.getCount()) continue;
            return i;
        }
        return -1;
    }

    private boolean itemInFrontHasInventory() {
        BlockPos frontBlockPos = NextFrontBlockFinder.findStorageBlockNextTo(this.level, this.placerDirection, this.getBlockPos());
        if (frontBlockPos == null) {
            return false;
        }
        this.blockInventoryHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, frontBlockPos, (Object)this.placerDirection);
        if (this.blockInventoryHandler != null) {
            this.curInvBlock = this.level.getBlockState(frontBlockPos).getBlock();
            this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)this.curInvBlock));
            this.machineData._sizeString = BERFunctions.getItemName(new ItemStack((ItemLike)this.curInvBlock));
            return true;
        }
        this.curInvBlock = null;
        this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        this.machineData._sizeString = "";
        return false;
    }

    private void loadSeedItem() {
        if (!this.getSeedStack().isEmpty()) {
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.placeSeedItem = this.getSeedCropBlock(this.getSeedStack());
        } else {
            this.seedParticles = null;
        }
    }

    private Block getSeedCropBlock(ItemStack seedItem) {
        return Block.byItem((Item)seedItem.getItem());
    }

    private void updateParticles() {
        this.seedParticles = GlobalFuncs.removeManaFromParticleCollection(QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(this.getSeedStack().getItem()));
        if (this.seedParticles != null) {
            this.seedParticles = this.cloneParticles(this.seedParticles);
            this.seedParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, QdcMachines.MACHINE_CHARGE));
        }
    }

    private boolean checkIfHasFuel() {
        if (this.fuelParticles == null) {
            this.fuelParticles = new ParticleCollection();
            this.fuelParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, QdcMachines.MACHINE_CHARGE));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.fuelParticles);
    }

    private boolean checkIfHasItemParticles() {
        if (this.seedParticles == null) {
            return false;
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.seedParticles);
    }

    private boolean checkIfHasSeedsInStorage() {
        return !this.getSeedStack().isEmpty() && QdcApi.QDC_CORE.FUNCTIONS.getItemStorageCount(this.getSeedStack().getItem()) > 0;
    }

    private ParticleCollection cloneParticles(ParticleCollection pc) {
        ParticleCollection res = new ParticleCollection();
        for (ParticleItem pi : pc.particleList) {
            res.add(new ParticleItem(pi.type, pi.amount));
        }
        return res;
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.ITEM_PLACER.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.dropStuffs(pos);
        super.preRemoveSideEffects(pos, state);
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        super.saveAdditional(output, provider);
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        this.machineData.save(output);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        super.loadAdditional(input, provider);
        this.itemHandler.deserializeNBT(provider, (CompoundTag)input.getCompound("inventory").get());
        this.speed = (Integer)input.getInt("speed").get();
        this.loadSeedItem();
        this.updateTickCountsBySpeed();
        this.machineData.load(input);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

