/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.ModItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.classes.Window;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ItemModWindowSetup {
    private static void getMissingItemsFromList() {
        int counter = 0;
        for (Item item : BuiltInRegistries.ITEM) {
            String name;
            if (QdcApi.QDC_CORE.FUNCTIONS.itemHasParticles(item) || !ItemModWindowSetup.isValid(name = ItemModWindowSetup.getItemName(item))) continue;
            ++counter;
            ItemModWindowSetup.writeCodeForItem(name);
        }
        GlobalFuncs.msg(counter + " items missing particles");
    }

    private static String getItemNameFIltered(ItemStack is) {
        return ItemModWindowSetup.getItemName(is.getItem()).replace("minecraft:", "");
    }

    private static void getItemsMIssingWindowFromList() {
        int counter = 0;
        for (Item item : BuiltInRegistries.ITEM) {
            String name = ItemModWindowSetup.getItemName(item);
            if (!ItemModWindowSetup.isValid(name) || MainBox.WINDOW_BOX.getItemWindow(item) != null) continue;
            ++counter;
            GlobalFuncs.msg(name);
        }
        GlobalFuncs.msg(counter + " items missing window");
    }

    public static void writeCodeForItem(String itemName) {
        String res = itemName.replace("minecraft:", "").toUpperCase();
        if (res.endsWith("STAIRS")) {
            ItemModWindowSetup.writeCodeForStairsItem(res);
            return;
        }
        GlobalFuncs.msg("");
        GlobalFuncs.msg("private PRI " + res + " = new PRI()");
        GlobalFuncs.msg(".setItem(Items." + res + ")");
        GlobalFuncs.msg(".setMakeAmount( )");
        GlobalFuncs.msg(".addIngredient( , )");
        GlobalFuncs.msg(".addToList(PRI_List);");
    }

    public static void writeCodeForStairsItem(String itemName) {
        String ingredient = itemName.replace("_STAIRS", "");
        GlobalFuncs.msg("");
        GlobalFuncs.msg("private PRI " + itemName + " = new PRI()");
        GlobalFuncs.msg(".setItem(Items." + itemName + ")");
        GlobalFuncs.msg(".setMakeAmount(4)");
        GlobalFuncs.msg(".addIngredient(" + ingredient + ", 6)");
        GlobalFuncs.msg(".addToList(PRI_List);");
    }

    public static String getItemName(Item item) {
        return ((Item)item.builtInRegistryHolder().value()).toString();
    }

    private static void checkWindowItemsWithNoParticles() {
        int counter = 0;
        for (Window win : MainBox.WINDOW_BOX.windowList) {
            for (ModItem i : win.itemList) {
                String name;
                Item item = i.item;
                if (QdcApi.QDC_CORE.FUNCTIONS.itemHasParticles(item) || !ItemModWindowSetup.isValid(name = ItemModWindowSetup.getItemName(item))) continue;
                ++counter;
                ItemModWindowSetup.writeCodeForItem(name);
            }
        }
        GlobalFuncs.msg(counter + " window items missing particles");
    }

    private static boolean isValid(String name) {
        String[] ignore = new String[]{"air", "bundle", "wandering_trader_spawn_egg", "farmland", "filled_map", "firework", "grass", "infested", "map", "potion", "spawner", "minecart", "barrier", "bedrock", "command", "chipped", "damaged", "debug", "path", "frame", "structure", "tipped", "frogspawn", "suspicious_gravel", "suspicious_sand", "decorated_pot", "large_fern", "player_head", "bucket", "enchanted_book", "budding_am", "chorus_plant", "reinforced_deepslate", "light", "vault", "goat_horn", "knowledge_book", "written_book", "writable_book", "jigsaw", "test"};
        for (int i = 0; i < ignore.length; ++i) {
            if (!name.contains(ignore[i])) continue;
            return false;
        }
        return name.contains("minecraft:");
    }

    public static void initModItemList(Level level) {
        ItemModWindowSetup.nature();
        ItemModWindowSetup.tree();
        ItemModWindowSetup.boat();
        ItemModWindowSetup.sand();
        ItemModWindowSetup.dye();
        ItemModWindowSetup.glass();
        ItemModWindowSetup.glassPane();
        ItemModWindowSetup.wool();
        ItemModWindowSetup.concrete();
        ItemModWindowSetup.clay();
        ItemModWindowSetup.shulker();
        ItemModWindowSetup.food();
        ItemModWindowSetup.seeds();
        ItemModWindowSetup.stone();
        ItemModWindowSetup.fence();
        ItemModWindowSetup.door();
        ItemModWindowSetup.stairs();
        ItemModWindowSetup.ores();
        ItemModWindowSetup.flower();
        ItemModWindowSetup.redstone();
        ItemModWindowSetup.minecart();
        ItemModWindowSetup.end();
        ItemModWindowSetup.nether();
        ItemModWindowSetup.prismarine();
        ItemModWindowSetup.drops();
        ItemModWindowSetup.tools();
        ItemModWindowSetup.weapons();
        ItemModWindowSetup.armor();
        ItemModWindowSetup.disk();
        ItemModWindowSetup.crafted();
        ItemModWindowSetup.pressurePlate();
        ItemModWindowSetup.button();
        ItemModWindowSetup.brewing();
        ItemModWindowSetup.slabs();
        ItemModWindowSetup.wall();
        ItemModWindowSetup.beacon();
        ItemModWindowSetup.trapdoor();
        ItemModWindowSetup.sign();
        ItemModWindowSetup.bee();
        ItemModWindowSetup.banner();
        ItemModWindowSetup.bed();
        ItemModWindowSetup.carpet();
        ItemModWindowSetup.candle();
        ItemModWindowSetup.coral();
        ItemModWindowSetup.copper();
        ItemModWindowSetup.template();
        ItemModWindowSetup.sherd();
        ItemModWindowSetup.resin();
        ItemModWindowSetup.harness();
        ItemModWindowSetup.modItems();
        ItemModWindowSetup.machineCores();
        Qdc.ItemParticleRegistrationStore.itemParticleRegistrationObj.handleParticleRegistration();
        ItemModWindowSetup.getItemsMIssingWindowFromList();
        GlobalFuncs.line();
        ItemModWindowSetup.getMissingItemsFromList();
        GlobalFuncs.line();
        ItemModWindowSetup.checkWindowItemsWithNoParticles();
    }

    private static void machineCores() {
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_WOOD, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_STONE, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_IRON, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_GOLD, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_DIAMOND, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_EMERALD, ENUMS.WINDOW.QDC_MACHINE_CORES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_NETHERITE, ENUMS.WINDOW.QDC_MACHINE_CORES);
    }

    private static void modItems() {
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.NATURE, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.FOOD, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.METAL, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.GEM, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.CORRUPTION, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.MANA, ENUMS.WINDOW.QDC_PARTICLES);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_CORE, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_CORE, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_TRANSMITTER, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_TRANSMITTER, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_RECIEVER, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_RECIEVER, ENUMS.WINDOW.QDC_ITEMS);
        ItemModWindowSetup.addItem(QdcApi.QDC_CORE.ITEMS.QUANTUM_KNOWLEDGE, ENUMS.WINDOW.QDC_ITEMS);
    }

    private static void harness() {
        ItemModWindowSetup.addItem(Items.WHITE_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.GRAY_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.BLACK_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.YELLOW_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.ORANGE_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.CYAN_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.BLUE_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.LIME_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.GREEN_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.PINK_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.MAGENTA_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.PURPLE_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.RED_HARNESS, ENUMS.WINDOW.HARNESS);
        ItemModWindowSetup.addItem(Items.BROWN_HARNESS, ENUMS.WINDOW.HARNESS);
    }

    private static void resin() {
        ItemModWindowSetup.addItem(Items.CREAKING_HEART, ENUMS.WINDOW.RESIN);
        ItemModWindowSetup.addItem(Items.RESIN_BLOCK, ENUMS.WINDOW.RESIN);
        ItemModWindowSetup.addItem(Items.RESIN_CLUMP, ENUMS.WINDOW.RESIN);
        ItemModWindowSetup.addItem(Items.RESIN_BRICK, ENUMS.WINDOW.RESIN);
        ItemModWindowSetup.addItem(Items.RESIN_BRICKS, ENUMS.WINDOW.RESIN);
        ItemModWindowSetup.addItem(Items.CHISELED_RESIN_BRICKS, ENUMS.WINDOW.RESIN);
    }

    private static void nature() {
        ItemModWindowSetup.addItem(Items.DIRT, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.ROOTED_DIRT, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MUD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.COARSE_DIRT, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PODZOL, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.GRAVEL, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MYCELIUM, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.CACTUS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.ICE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PACKED_ICE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.BLUE_ICE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SNOWBALL, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SNOW_BLOCK, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SNOW, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.VINE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.COBWEB, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.BRICK, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.TURTLE_EGG, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.FLINT, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.DEAD_BUSH, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.FERN, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.LILY_PAD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SEA_PICKLE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MUSHROOM_STEM, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SMALL_DRIPLEAF, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.BIG_DRIPLEAF, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.DRIPSTONE_BLOCK, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.POINTED_DRIPSTONE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.CALCITE, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.GLOW_LICHEN, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.HANGING_ROOTS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MANGROVE_ROOTS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MUDDY_MANGROVE_ROOTS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SMALL_AMETHYST_BUD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MEDIUM_AMETHYST_BUD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.LARGE_AMETHYST_BUD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.AMETHYST_CLUSTER, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PINK_PETALS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MOSS_BLOCK, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MOSS_CARPET, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PALE_MOSS_BLOCK, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PALE_MOSS_CARPET, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PALE_HANGING_MOSS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SPORE_BLOSSOM, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.PACKED_MUD, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.MUD_BRICKS, ENUMS.WINDOW.NATURE);
        ItemModWindowSetup.addItem(Items.SNIFFER_EGG, ENUMS.WINDOW.NATURE);
    }

    private static void tree() {
        ItemModWindowSetup.addItem(Items.OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.SPRUCE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BIRCH_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.JUNGLE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.ACACIA_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.MANGROVE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.CHERRY_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.OAK_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.SPRUCE_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BIRCH_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.JUNGLE_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.ACACIA_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.MANGROVE_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.CHERRY_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.SPRUCE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BIRCH_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.JUNGLE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.ACACIA_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.MANGROVE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.CHERRY_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_DARK_OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_SPRUCE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_BIRCH_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_JUNGLE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_ACACIA_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_MANGROVE_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_CHERRY_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_PALE_OAK_LOG, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_DARK_OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_SPRUCE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_BIRCH_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_JUNGLE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_ACACIA_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_MANGROVE_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_CHERRY_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_PALE_OAK_WOOD, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.OAK_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.SPRUCE_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BIRCH_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.JUNGLE_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.ACACIA_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.MANGROVE_PROPAGULE, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.CHERRY_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_SAPLING, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BAMBOO, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BAMBOO_BLOCK, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.STRIPPED_BAMBOO_BLOCK, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BAMBOO_MOSAIC, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BAMBOO_PLANKS, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.OAK_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.SPRUCE_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.BIRCH_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.JUNGLE_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.ACACIA_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.MANGROVE_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.CHERRY_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.AZALEA, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.AZALEA_LEAVES, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.FLOWERING_AZALEA, ENUMS.WINDOW.TREE);
        ItemModWindowSetup.addItem(Items.FLOWERING_AZALEA_LEAVES, ENUMS.WINDOW.TREE);
    }

    private static void boat() {
        ItemModWindowSetup.addItem(Items.OAK_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.DARK_OAK_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.SPRUCE_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.BIRCH_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.JUNGLE_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.ACACIA_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.MANGROVE_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.CHERRY_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.PALE_OAK_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.BAMBOO_RAFT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.OAK_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.DARK_OAK_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.SPRUCE_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.BIRCH_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.JUNGLE_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.ACACIA_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.MANGROVE_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.CHERRY_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.PALE_OAK_CHEST_BOAT, ENUMS.WINDOW.BOAT);
        ItemModWindowSetup.addItem(Items.BAMBOO_CHEST_RAFT, ENUMS.WINDOW.BOAT);
    }

    private static void sand() {
        ItemModWindowSetup.addItem(Items.SAND, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.CUT_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.CHISELED_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.SMOOTH_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.RED_SAND, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.RED_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.CUT_RED_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.CHISELED_RED_SANDSTONE, ENUMS.WINDOW.SAND);
        ItemModWindowSetup.addItem(Items.SMOOTH_RED_SANDSTONE, ENUMS.WINDOW.SAND);
    }

    private static void dye() {
        ItemModWindowSetup.addItem(Items.WHITE_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.GRAY_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.BLACK_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.YELLOW_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.ORANGE_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.CYAN_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.BLUE_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.LIME_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.GREEN_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.PINK_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.MAGENTA_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.PURPLE_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.RED_DYE, ENUMS.WINDOW.DYE);
        ItemModWindowSetup.addItem(Items.BROWN_DYE, ENUMS.WINDOW.DYE);
    }

    private static void glass() {
        ItemModWindowSetup.addItem(Items.GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.WHITE_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.GRAY_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.BLACK_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.YELLOW_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.ORANGE_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.CYAN_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.BLUE_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.LIME_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.GREEN_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.PINK_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.MAGENTA_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.PURPLE_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.RED_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.BROWN_STAINED_GLASS, ENUMS.WINDOW.GLASS);
        ItemModWindowSetup.addItem(Items.TINTED_GLASS, ENUMS.WINDOW.GLASS);
    }

    private static void glassPane() {
        ItemModWindowSetup.addItem(Items.GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.WHITE_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.GRAY_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.BLACK_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.YELLOW_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.ORANGE_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.CYAN_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.BLUE_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.LIME_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.GREEN_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.PINK_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.MAGENTA_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.PURPLE_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.RED_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
        ItemModWindowSetup.addItem(Items.BROWN_STAINED_GLASS_PANE, ENUMS.WINDOW.GLASS_PANE);
    }

    private static void wool() {
        ItemModWindowSetup.addItem(Items.WHITE_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.GRAY_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.BLACK_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.YELLOW_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.ORANGE_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.CYAN_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.BLUE_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.LIME_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.GREEN_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.PINK_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.MAGENTA_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.PURPLE_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.RED_WOOL, ENUMS.WINDOW.WOOL);
        ItemModWindowSetup.addItem(Items.BROWN_WOOL, ENUMS.WINDOW.WOOL);
    }

    private static void concrete() {
        ItemModWindowSetup.addItem(Items.WHITE_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.GRAY_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BLACK_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.YELLOW_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.ORANGE_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.CYAN_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BLUE_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIME_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.GREEN_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.PINK_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.MAGENTA_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.PURPLE_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.RED_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BROWN_CONCRETE_POWDER, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.WHITE_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.GRAY_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BLACK_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.YELLOW_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.ORANGE_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.CYAN_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BLUE_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.LIME_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.GREEN_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.PINK_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.MAGENTA_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.PURPLE_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.RED_CONCRETE, ENUMS.WINDOW.CONCRETE);
        ItemModWindowSetup.addItem(Items.BROWN_CONCRETE, ENUMS.WINDOW.CONCRETE);
    }

    private static void clay() {
        ItemModWindowSetup.addItem(Items.CLAY_BALL, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.CLAY, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.WHITE_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.GRAY_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BLACK_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.YELLOW_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.ORANGE_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.CYAN_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BLUE_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIME_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.GREEN_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.PINK_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.MAGENTA_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.PURPLE_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.RED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BROWN_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.WHITE_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.GRAY_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BLACK_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.YELLOW_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.ORANGE_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.CYAN_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BLUE_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.LIME_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.GREEN_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.PINK_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.MAGENTA_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.PURPLE_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.RED_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
        ItemModWindowSetup.addItem(Items.BROWN_GLAZED_TERRACOTTA, ENUMS.WINDOW.CLAY);
    }

    private static void shulker() {
        ItemModWindowSetup.addItem(Items.SHULKER_SHELL, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.WHITE_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.GRAY_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.BLACK_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.YELLOW_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.ORANGE_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.CYAN_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.BLUE_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.LIME_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.GREEN_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.PINK_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.MAGENTA_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.PURPLE_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.RED_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
        ItemModWindowSetup.addItem(Items.BROWN_SHULKER_BOX, ENUMS.WINDOW.SHULKER);
    }

    private static void food() {
        ItemModWindowSetup.addItem(Items.WHEAT, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.HAY_BLOCK, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.EGG, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.BLUE_EGG, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.BROWN_EGG, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.SUGAR, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.SUGAR_CANE, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.COCOA_BEANS, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.BEEF, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.CHICKEN, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.SALMON, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.COD, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.PUFFERFISH, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.TROPICAL_FISH, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.PORKCHOP, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.RABBIT, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.MUTTON, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.ROTTEN_FLESH, ENUMS.WINDOW.RAW_FOOD);
        ItemModWindowSetup.addItem(Items.CAKE, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.BREAD, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKIE, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_BEEF, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_CHICKEN, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_SALMON, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_COD, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_PORKCHOP, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_RABBIT, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.COOKED_MUTTON, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.BAKED_POTATO, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.MUSHROOM_STEW, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.RABBIT_STEW, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.SUSPICIOUS_STEW, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.BEETROOT_SOUP, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.PUMPKIN_PIE, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.DRIED_KELP, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.DRIED_KELP_BLOCK, ENUMS.WINDOW.COOKED_FOOD);
        ItemModWindowSetup.addItem(Items.APPLE, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.SWEET_BERRIES, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.POTATO, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.POISONOUS_POTATO, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.CARROT, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.BEETROOT, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.RED_MUSHROOM, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.RED_MUSHROOM_BLOCK, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.BROWN_MUSHROOM, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.BROWN_MUSHROOM_BLOCK, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.MELON_SLICE, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.MELON, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.PUMPKIN, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.KELP, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.CHORUS_FRUIT, ENUMS.WINDOW.FRUIT_VEG);
        ItemModWindowSetup.addItem(Items.GLOW_BERRIES, ENUMS.WINDOW.DROPS);
    }

    private static void seeds() {
        ItemModWindowSetup.addItem(Items.BEETROOT_SEEDS, ENUMS.WINDOW.SEEDS);
        ItemModWindowSetup.addItem(Items.MELON_SEEDS, ENUMS.WINDOW.SEEDS);
        ItemModWindowSetup.addItem(Items.PUMPKIN_SEEDS, ENUMS.WINDOW.SEEDS);
        ItemModWindowSetup.addItem(Items.WHEAT_SEEDS, ENUMS.WINDOW.SEEDS);
        ItemModWindowSetup.addItem(Items.TORCHFLOWER_SEEDS, ENUMS.WINDOW.SEEDS);
        ItemModWindowSetup.addItem(Items.PITCHER_POD, ENUMS.WINDOW.SEEDS);
    }

    private static void stone() {
        ItemModWindowSetup.addItem(Items.STONE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.SMOOTH_STONE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.STONE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CHISELED_STONE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CRACKED_STONE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.MOSSY_STONE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.COBBLESTONE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.MOSSY_COBBLESTONE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.ANDESITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.POLISHED_ANDESITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.DIORITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.POLISHED_DIORITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.GRANITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.POLISHED_GRANITE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.DEEPSLATE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.POLISHED_DEEPSLATE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CRACKED_DEEPSLATE_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.COBBLED_DEEPSLATE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CHISELED_DEEPSLATE, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_TILES, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CRACKED_DEEPSLATE_TILES, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.OBSIDIAN, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.TUFF, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.POLISHED_TUFF, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.TUFF_BRICKS, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CHISELED_TUFF, ENUMS.WINDOW.STONE);
        ItemModWindowSetup.addItem(Items.CHISELED_TUFF_BRICKS, ENUMS.WINDOW.STONE);
    }

    private static void fence() {
        ItemModWindowSetup.addItem(Items.OAK_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.SPRUCE_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.BIRCH_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.JUNGLE_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.ACACIA_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.MANGROVE_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.CHERRY_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.BAMBOO_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.CRIMSON_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.WARPED_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.NETHER_BRICK_FENCE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.OAK_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.SPRUCE_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.BIRCH_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.JUNGLE_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.ACACIA_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.MANGROVE_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.CHERRY_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.BAMBOO_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.CRIMSON_FENCE_GATE, ENUMS.WINDOW.FENCE);
        ItemModWindowSetup.addItem(Items.WARPED_FENCE_GATE, ENUMS.WINDOW.FENCE);
    }

    private static void door() {
        ItemModWindowSetup.addItem(Items.OAK_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.DARK_OAK_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.SPRUCE_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.BIRCH_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.JUNGLE_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.ACACIA_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.MANGROVE_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.CHERRY_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.PALE_OAK_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.BAMBOO_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.CRIMSON_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WARPED_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.IRON_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.EXPOSED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.OXIDIZED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WEATHERED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WAXED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_COPPER_DOOR, ENUMS.WINDOW.DOOR);
    }

    private static void stairs() {
        ItemModWindowSetup.addItem(Items.OAK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.DARK_OAK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.SPRUCE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.BIRCH_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.JUNGLE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.ACACIA_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.MANGROVE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.CHERRY_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.PALE_OAK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.RESIN_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.BAMBOO_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.STONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.STONE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.MOSSY_STONE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.COBBLED_DEEPSLATE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.COBBLESTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.MOSSY_COBBLESTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.ANDESITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_ANDESITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.DIORITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_DIORITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.GRANITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_GRANITE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_TILE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_DEEPSLATE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.SANDSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.SMOOTH_SANDSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.RED_SANDSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.SMOOTH_RED_SANDSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.PRISMARINE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.PRISMARINE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.DARK_PRISMARINE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.NETHER_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.RED_NETHER_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.QUARTZ_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.SMOOTH_QUARTZ_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.CRIMSON_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WARPED_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.PURPUR_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.END_STONE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.BLACKSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_BRICK_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.EXPOSED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.OXIDIZED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WAXED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
        ItemModWindowSetup.addItem(Items.WEATHERED_CUT_COPPER_STAIRS, ENUMS.WINDOW.STAIRS);
    }

    private static void ores() {
        ItemModWindowSetup.addItem(Items.COAL, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.COAL_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.COAL_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_COAL_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.IRON_NUGGET, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.RAW_IRON, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.IRON_INGOT, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.IRON_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.RAW_IRON_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.IRON_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_IRON_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.GOLD_NUGGET, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.RAW_GOLD, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.GOLD_INGOT, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.GOLD_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.RAW_GOLD_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.GOLD_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.NETHER_GOLD_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_GOLD_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DIAMOND, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DIAMOND_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DIAMOND_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_DIAMOND_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.EMERALD, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.EMERALD_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.EMERALD_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_EMERALD_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.ANCIENT_DEBRIS, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.NETHERITE_SCRAP, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.NETHERITE_INGOT, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.NETHERITE_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.LAPIS_LAZULI, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.LAPIS_BLOCK, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.LAPIS_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_LAPIS_ORE, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.AMETHYST_SHARD, ENUMS.WINDOW.ORES);
        ItemModWindowSetup.addItem(Items.AMETHYST_BLOCK, ENUMS.WINDOW.ORES);
    }

    private static void flower() {
        ItemModWindowSetup.addItem(Items.DANDELION, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.POPPY, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.BLUE_ORCHID, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.ALLIUM, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.AZURE_BLUET, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.WHITE_TULIP, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.PINK_TULIP, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.RED_TULIP, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.ORANGE_TULIP, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.OXEYE_DAISY, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.CORNFLOWER, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.LILY_OF_THE_VALLEY, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.WITHER_ROSE, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.SUNFLOWER, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.LILAC, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.ROSE_BUSH, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.PEONY, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.TORCHFLOWER, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.PITCHER_PLANT, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.FLOWER_POT, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.OPEN_EYEBLOSSOM, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.CLOSED_EYEBLOSSOM, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.BUSH, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.FIREFLY_BUSH, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.WILDFLOWERS, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.LEAF_LITTER, ENUMS.WINDOW.FLOWER);
        ItemModWindowSetup.addItem(Items.CACTUS_FLOWER, ENUMS.WINDOW.FLOWER);
    }

    private static void redstone() {
        ItemModWindowSetup.addItem(Items.REDSTONE, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.REDSTONE_BLOCK, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.REDSTONE_ORE, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_REDSTONE_ORE, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.REDSTONE_TORCH, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.REDSTONE_LAMP, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.LEVER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.HOPPER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.CLOCK, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.COMPASS, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.DISPENSER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.DROPPER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.NOTE_BLOCK, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.OBSERVER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.PISTON, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.STICKY_PISTON, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.REPEATER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.COMPARATOR, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.TARGET, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.DAYLIGHT_DETECTOR, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.TRIPWIRE_HOOK, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.EXPOSED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.OXIDIZED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.WEATHERED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.WAXED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_COPPER_BULB, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.SCULK, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.SCULK_VEIN, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.SCULK_CATALYST, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.SCULK_SHRIEKER, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.SCULK_SENSOR, ENUMS.WINDOW.REDSTONE);
        ItemModWindowSetup.addItem(Items.CALIBRATED_SCULK_SENSOR, ENUMS.WINDOW.REDSTONE);
    }

    private static void minecart() {
        ItemModWindowSetup.addItem(Items.RAIL, ENUMS.WINDOW.MINECART);
        ItemModWindowSetup.addItem(Items.POWERED_RAIL, ENUMS.WINDOW.MINECART);
        ItemModWindowSetup.addItem(Items.DETECTOR_RAIL, ENUMS.WINDOW.MINECART);
        ItemModWindowSetup.addItem(Items.ACTIVATOR_RAIL, ENUMS.WINDOW.MINECART);
        ItemModWindowSetup.addItem(Items.MINECART, ENUMS.WINDOW.MINECART);
    }

    private static void end() {
        ItemModWindowSetup.addItem(Items.ENDER_EYE, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.ENDER_PEARL, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.CHORUS_FLOWER, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.POPPED_CHORUS_FRUIT, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.PURPUR_BLOCK, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.PURPUR_PILLAR, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.END_STONE, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.END_STONE_BRICKS, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.END_CRYSTAL, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.END_ROD, ENUMS.WINDOW.END);
        ItemModWindowSetup.addItem(Items.DRAGON_EGG, ENUMS.WINDOW.END);
    }

    private static void nether() {
        ItemModWindowSetup.addItem(Items.DRIED_GHAST, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_WART, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_WART_BLOCK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_SPROUTS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.GLOWSTONE_DUST, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.GLOWSTONE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.SHROOMLIGHT, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.SOUL_SAND, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.SOUL_SOIL, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHERRACK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_BRICK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CHISELED_NETHER_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRACKED_NETHER_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.RED_NETHER_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.BASALT, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.POLISHED_BASALT, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.SMOOTH_BASALT, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.NETHER_QUARTZ_ORE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.QUARTZ, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.QUARTZ_BLOCK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CHISELED_QUARTZ_BLOCK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.QUARTZ_PILLAR, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.QUARTZ_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.SMOOTH_QUARTZ, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WEEPING_VINES, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_ROOTS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_NYLIUM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_FUNGUS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_STEM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.STRIPPED_CRIMSON_STEM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_HYPHAE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.STRIPPED_CRIMSON_HYPHAE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRIMSON_PLANKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.TWISTING_VINES, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_ROOTS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_NYLIUM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_FUNGUS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_STEM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.STRIPPED_WARPED_STEM, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_HYPHAE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.STRIPPED_WARPED_HYPHAE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_PLANKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.WARPED_WART_BLOCK, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.BLACKSTONE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRACKED_POLISHED_BLACKSTONE_BRICKS, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CHISELED_POLISHED_BLACKSTONE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.GILDED_BLACKSTONE, ENUMS.WINDOW.NETHER);
        ItemModWindowSetup.addItem(Items.CRYING_OBSIDIAN, ENUMS.WINDOW.NETHER);
    }

    private static void prismarine() {
        ItemModWindowSetup.addItem(Items.PRISMARINE_SHARD, ENUMS.WINDOW.PRISMARINE);
        ItemModWindowSetup.addItem(Items.PRISMARINE_CRYSTALS, ENUMS.WINDOW.PRISMARINE);
        ItemModWindowSetup.addItem(Items.PRISMARINE, ENUMS.WINDOW.PRISMARINE);
        ItemModWindowSetup.addItem(Items.PRISMARINE_BRICKS, ENUMS.WINDOW.PRISMARINE);
        ItemModWindowSetup.addItem(Items.DARK_PRISMARINE, ENUMS.WINDOW.PRISMARINE);
        ItemModWindowSetup.addItem(Items.SEA_LANTERN, ENUMS.WINDOW.PRISMARINE);
    }

    private static void drops() {
        ItemModWindowSetup.addItem(Items.STRING, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.FEATHER, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.GUNPOWDER, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SLIME_BALL, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SLIME_BLOCK, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SPIDER_EYE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.INK_SAC, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BONE_MEAL, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BONE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BONE_BLOCK, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SEAGRASS, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.ARMADILLO_SCUTE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.TURTLE_SCUTE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.RABBIT_HIDE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.RABBIT_FOOT, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.LEATHER, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.NAUTILUS_SHELL, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SKELETON_SKULL, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.WITHER_SKELETON_SKULL, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.CREEPER_HEAD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.DRAGON_HEAD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.ZOMBIE_HEAD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.PIGLIN_HEAD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.TOTEM_OF_UNDYING, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.HEART_OF_THE_SEA, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SPONGE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.WET_SPONGE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BLAZE_ROD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.GHAST_TEAR, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.MAGMA_CREAM, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.MAGMA_BLOCK, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BLAZE_POWDER, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.NETHER_STAR, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.PHANTOM_MEMBRANE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.NAME_TAG, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.SADDLE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.ELYTRA, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.ENCHANTED_GOLDEN_APPLE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.ECHO_SHARD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.EXPERIENCE_BOTTLE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.GLOW_INK_SAC, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.OCHRE_FROGLIGHT, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.PEARLESCENT_FROGLIGHT, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.VERDANT_FROGLIGHT, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.BREEZE_ROD, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.HEAVY_CORE, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.TRIAL_KEY, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.OMINOUS_TRIAL_KEY, ENUMS.WINDOW.DROPS);
        ItemModWindowSetup.addItem(Items.OMINOUS_BOTTLE, ENUMS.WINDOW.DROPS);
    }

    private static void tools() {
        ItemModWindowSetup.addItem(Items.BRUSH, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.FLINT_AND_STEEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.LEAD, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.FISHING_ROD, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.WOODEN_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.STONE_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.IRON_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.GOLDEN_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.DIAMOND_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.NETHERITE_HOE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.WOODEN_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.STONE_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.IRON_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.GOLDEN_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.DIAMOND_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.NETHERITE_AXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.WOODEN_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.STONE_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.IRON_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.GOLDEN_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.DIAMOND_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.NETHERITE_PICKAXE, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.WOODEN_SHOVEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.STONE_SHOVEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.IRON_SHOVEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.GOLDEN_SHOVEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.DIAMOND_SHOVEL, ENUMS.WINDOW.TOOLS);
        ItemModWindowSetup.addItem(Items.NETHERITE_SHOVEL, ENUMS.WINDOW.TOOLS);
    }

    private static void weapons() {
        ItemModWindowSetup.addItem(Items.BOW, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.CROSSBOW, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.ARROW, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.SPECTRAL_ARROW, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.TRIDENT, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.FIRE_CHARGE, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.WOODEN_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.STONE_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.IRON_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.GOLDEN_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.DIAMOND_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.NETHERITE_SWORD, ENUMS.WINDOW.WEAPON);
        ItemModWindowSetup.addItem(Items.MACE, ENUMS.WINDOW.WEAPON);
    }

    private static void armor() {
        ItemModWindowSetup.addItem(Items.SHIELD, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.TURTLE_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.LEATHER_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.LEATHER_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.LEATHER_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.LEATHER_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.GOLDEN_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.GOLDEN_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.GOLDEN_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.GOLDEN_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.IRON_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.IRON_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.IRON_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.IRON_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.CHAINMAIL_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.CHAINMAIL_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.CHAINMAIL_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.CHAINMAIL_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.DIAMOND_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.DIAMOND_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.DIAMOND_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.DIAMOND_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.NETHERITE_HELMET, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.NETHERITE_CHESTPLATE, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.NETHERITE_LEGGINGS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.NETHERITE_BOOTS, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.LEATHER_HORSE_ARMOR, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.IRON_HORSE_ARMOR, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.GOLDEN_HORSE_ARMOR, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.DIAMOND_HORSE_ARMOR, ENUMS.WINDOW.ARMOR);
        ItemModWindowSetup.addItem(Items.WOLF_ARMOR, ENUMS.WINDOW.ARMOR);
    }

    private static void disk() {
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_11, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_13, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_BLOCKS, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_CAT, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_CHIRP, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_FAR, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_MALL, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_MELLOHI, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_PIGSTEP, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_STAL, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_STRAD, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_WAIT, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_OTHERSIDE, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.DISC_FRAGMENT_5, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_5, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_RELIC, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_PRECIPICE, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_CREATOR_MUSIC_BOX, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_CREATOR, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_TEARS, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_WARD, ENUMS.WINDOW.DISK);
        ItemModWindowSetup.addItem(Items.MUSIC_DISC_LAVA_CHICKEN, ENUMS.WINDOW.DISK);
    }

    private static void crafted() {
        ItemModWindowSetup.addItem(Items.STICK, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.TORCH, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.LANTERN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SOUL_TORCH, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SOUL_LANTERN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BOWL, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CHARCOAL, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.PAPER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BOOK, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BUCKET, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CARROT_ON_A_STICK, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.WARPED_FUNGUS_ON_A_STICK, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.ITEM_FRAME, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.PAINTING, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.LADDER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SHEARS, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.IRON_BARS, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CHAIN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CHEST, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.TRAPPED_CHEST, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.ENDER_CHEST, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CARVED_PUMPKIN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.JACK_O_LANTERN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.TNT, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CRAFTING_TABLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CARTOGRAPHY_TABLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.FLETCHING_TABLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SMITHING_TABLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.STONECUTTER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.LOOM, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.ENCHANTING_TABLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.COMPOSTER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BOOKSHELF, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CHISELED_BOOKSHELF, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.FURNACE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BLAST_FURNACE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SMOKER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.ANVIL, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.GRINDSTONE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.ARMOR_STAND, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.LECTERN, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CAMPFIRE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SOUL_CAMPFIRE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SCAFFOLDING, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.BARREL, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.JUKEBOX, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.LODESTONE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.RESPAWN_ANCHOR, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.GOLDEN_APPLE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.GOLDEN_CARROT, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.GLISTERING_MELON_SLICE, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.RECOVERY_COMPASS, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.SPYGLASS, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.CRAFTER, ENUMS.WINDOW.CRAFTED);
        ItemModWindowSetup.addItem(Items.WIND_CHARGE, ENUMS.WINDOW.CRAFTED);
    }

    private static void pressurePlate() {
        ItemModWindowSetup.addItem(Items.OAK_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.DARK_OAK_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.SPRUCE_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.BIRCH_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.JUNGLE_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.ACACIA_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.MANGROVE_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.CHERRY_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.PALE_OAK_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.BAMBOO_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.CRIMSON_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.WARPED_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.STONE_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.LIGHT_WEIGHTED_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
        ItemModWindowSetup.addItem(Items.HEAVY_WEIGHTED_PRESSURE_PLATE, ENUMS.WINDOW.PRESSUREPLATE);
    }

    private static void button() {
        ItemModWindowSetup.addItem(Items.OAK_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.DARK_OAK_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.SPRUCE_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.BIRCH_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.JUNGLE_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.ACACIA_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.MANGROVE_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.CHERRY_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.PALE_OAK_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.BAMBOO_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.CRIMSON_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.WARPED_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.STONE_BUTTON, ENUMS.WINDOW.BUTTON);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_BUTTON, ENUMS.WINDOW.BUTTON);
    }

    private static void brewing() {
        ItemModWindowSetup.addItem(Items.GLASS_BOTTLE, ENUMS.WINDOW.BREWING);
        ItemModWindowSetup.addItem(Items.DRAGON_BREATH, ENUMS.WINDOW.BREWING);
        ItemModWindowSetup.addItem(Items.CAULDRON, ENUMS.WINDOW.BREWING);
        ItemModWindowSetup.addItem(Items.BREWING_STAND, ENUMS.WINDOW.BREWING);
        ItemModWindowSetup.addItem(Items.FERMENTED_SPIDER_EYE, ENUMS.WINDOW.BREWING);
    }

    private static void slabs() {
        ItemModWindowSetup.addItem(Items.OAK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.PETRIFIED_OAK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.DARK_OAK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SPRUCE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.BIRCH_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.JUNGLE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.ACACIA_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.MANGROVE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.CHERRY_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.PALE_OAK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.BAMBOO_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.BAMBOO_MOSAIC_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.CRIMSON_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WARPED_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.RESIN_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.STONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SMOOTH_STONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.STONE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.MOSSY_STONE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.COBBLESTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.MOSSY_COBBLESTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.MUD_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.ANDESITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.DIORITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.GRANITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_ANDESITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_DIORITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_GRANITE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.COBBLED_DEEPSLATE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_DEEPSLATE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_TILE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.BLACKSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SMOOTH_SANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.CUT_STANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.RED_SANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.CUT_RED_SANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SMOOTH_RED_SANDSTONE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.PRISMARINE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.PRISMARINE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.DARK_PRISMARINE_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.END_STONE_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.NETHER_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.RED_NETHER_BRICK_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.PURPUR_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.QUARTZ_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.SMOOTH_QUARTZ_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.EXPOSED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.OXIDIZED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WAXED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.WEATHERED_CUT_COPPER_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.TUFF_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.POLISHED_TUFF_SLAB, ENUMS.WINDOW.SLABS);
        ItemModWindowSetup.addItem(Items.TUFF_BRICK_SLAB, ENUMS.WINDOW.SLABS);
    }

    private static void wall() {
        ItemModWindowSetup.addItem(Items.STONE_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.MOSSY_STONE_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.COBBLESTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.MOSSY_COBBLESTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.MUD_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.ANDESITE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.DIORITE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.GRANITE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.BLACKSTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.COBBLED_DEEPSLATE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.POLISHED_DEEPSLATE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_TILE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.NETHER_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.POLISHED_BLACKSTONE_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.PRISMARINE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.RED_NETHER_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.RED_SANDSTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.SANDSTONE_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.END_STONE_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.TUFF_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.POLISHED_TUFF_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.TUFF_BRICK_WALL, ENUMS.WINDOW.WALL);
        ItemModWindowSetup.addItem(Items.RESIN_BRICK_WALL, ENUMS.WINDOW.WALL);
    }

    private static void beacon() {
        ItemModWindowSetup.addItem(Items.CONDUIT, ENUMS.WINDOW.BEACON);
        ItemModWindowSetup.addItem(Items.BEACON, ENUMS.WINDOW.BEACON);
        ItemModWindowSetup.addItem(Items.BELL, ENUMS.WINDOW.BEACON);
    }

    private static void trapdoor() {
        ItemModWindowSetup.addItem(Items.OAK_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.DARK_OAK_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.SPRUCE_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.BIRCH_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.JUNGLE_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.ACACIA_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.MANGROVE_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.CHERRY_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.PALE_OAK_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.BAMBOO_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.CRIMSON_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WARPED_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.IRON_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.EXPOSED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.OXIDIZED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WEATHERED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WAXED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_COPPER_TRAPDOOR, ENUMS.WINDOW.TRAPDOOR);
    }

    private static void sign() {
        ItemModWindowSetup.addItem(Items.OAK_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.DARK_OAK_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.SPRUCE_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.BIRCH_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.JUNGLE_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.ACACIA_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.MANGROVE_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.CHERRY_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.PALE_OAK_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.BAMBOO_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.CRIMSON_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.WARPED_HANGING_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.OAK_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.DARK_OAK_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.SPRUCE_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.BIRCH_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.JUNGLE_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.ACACIA_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.MANGROVE_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.CHERRY_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.PALE_OAK_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.BAMBOO_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.CRIMSON_SIGN, ENUMS.WINDOW.SIGN);
        ItemModWindowSetup.addItem(Items.WARPED_SIGN, ENUMS.WINDOW.SIGN);
    }

    private static void bee() {
        ItemModWindowSetup.addItem(Items.HONEYCOMB, ENUMS.WINDOW.BEE);
        ItemModWindowSetup.addItem(Items.HONEYCOMB_BLOCK, ENUMS.WINDOW.BEE);
        ItemModWindowSetup.addItem(Items.HONEY_BOTTLE, ENUMS.WINDOW.BEE);
        ItemModWindowSetup.addItem(Items.HONEY_BLOCK, ENUMS.WINDOW.BEE);
        ItemModWindowSetup.addItem(Items.BEEHIVE, ENUMS.WINDOW.BEE);
        ItemModWindowSetup.addItem(Items.BEE_NEST, ENUMS.WINDOW.BEE);
    }

    private static void banner() {
        ItemModWindowSetup.addItem(Items.WHITE_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.GRAY_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.BLACK_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.YELLOW_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.ORANGE_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.CYAN_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.BLUE_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.LIME_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.GREEN_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.PINK_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.MAGENTA_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.PURPLE_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.RED_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.BROWN_BANNER, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.MOJANG_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.GLOBE_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.CREEPER_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.FLOWER_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.PIGLIN_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.SKULL_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.FLOW_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.GUSTER_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.FIELD_MASONED_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
        ItemModWindowSetup.addItem(Items.BORDURE_INDENTED_BANNER_PATTERN, ENUMS.WINDOW.BANNER);
    }

    private static void bed() {
        ItemModWindowSetup.addItem(Items.WHITE_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.GRAY_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.BLACK_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.YELLOW_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.ORANGE_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.CYAN_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.BLUE_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.LIME_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.GREEN_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.PINK_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.MAGENTA_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.PURPLE_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.RED_BED, ENUMS.WINDOW.BED);
        ItemModWindowSetup.addItem(Items.BROWN_BED, ENUMS.WINDOW.BED);
    }

    private static void carpet() {
        ItemModWindowSetup.addItem(Items.WHITE_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.GRAY_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.BLACK_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.YELLOW_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.ORANGE_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.CYAN_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.BLUE_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.LIME_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.GREEN_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.PINK_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.MAGENTA_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.PURPLE_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.RED_CARPET, ENUMS.WINDOW.CARPET);
        ItemModWindowSetup.addItem(Items.BROWN_CARPET, ENUMS.WINDOW.CARPET);
    }

    private static void coral() {
        ItemModWindowSetup.addItem(Items.BRAIN_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.BRAIN_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.BRAIN_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.BUBBLE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.BUBBLE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.BUBBLE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.FIRE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.FIRE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.FIRE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.HORN_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.HORN_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.HORN_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.TUBE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.TUBE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.TUBE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BRAIN_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BRAIN_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BRAIN_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BUBBLE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BUBBLE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_BUBBLE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_FIRE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_FIRE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_FIRE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_HORN_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_HORN_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_HORN_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_TUBE_CORAL, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_TUBE_CORAL_FAN, ENUMS.WINDOW.CORAL);
        ItemModWindowSetup.addItem(Items.DEAD_TUBE_CORAL_BLOCK, ENUMS.WINDOW.CORAL);
    }

    private static void candle() {
        ItemModWindowSetup.addItem(Items.CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.WHITE_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.LIGHT_GRAY_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.GRAY_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.BLACK_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.YELLOW_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.ORANGE_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.LIGHT_BLUE_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.CYAN_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.BLUE_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.LIME_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.GREEN_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.PINK_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.MAGENTA_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.PURPLE_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.RED_CANDLE, ENUMS.WINDOW.CANDLE);
        ItemModWindowSetup.addItem(Items.BROWN_CANDLE, ENUMS.WINDOW.CANDLE);
    }

    private static void copper() {
        ItemModWindowSetup.addItem(Items.RAW_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.RAW_COPPER_BLOCK, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.COPPER_INGOT, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.COPPER_BLOCK, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.EXPOSED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WEATHERED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.OXIDIZED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.COPPER_ORE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.DEEPSLATE_COPPER_ORE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.EXPOSED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WEATHERED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.OXIDIZED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_COPPER_BLOCK, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_CUT_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.LIGHTNING_ROD, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.EXPOSED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.OXIDIZED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WEATHERED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_CHISELED_COPPER, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.EXPOSED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.OXIDIZED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WEATHERED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_EXPOSED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_OXIDIZED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
        ItemModWindowSetup.addItem(Items.WAXED_WEATHERED_COPPER_GRATE, ENUMS.WINDOW.COPPER);
    }

    private static void template() {
        ItemModWindowSetup.addItem(Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
        ItemModWindowSetup.addItem(Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, ENUMS.WINDOW.TEMPLATE);
    }

    private static void sherd() {
        ItemModWindowSetup.addItem(Items.ANGLER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.ARCHER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.ARMS_UP_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.BLADE_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.BREWER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.BURN_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.DANGER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.EXPLORER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.FLOW_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.FRIEND_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.GUSTER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.HEART_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.HEARTBREAK_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.HOWL_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.MINER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.MOURNER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.PLENTY_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.PRIZE_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.SCRAPE_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.SHEAF_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.SHELTER_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.SKULL_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
        ItemModWindowSetup.addItem(Items.SNORT_POTTERY_SHERD, ENUMS.WINDOW.SHERD);
    }

    public static void addItem(Item item, ENUMS.WINDOW win) {
        ModItem newItem = new ModItem(item, null, ItemModWindowSetup.getWindowName(win));
        MainBox.ITEM_BOX.add(newItem);
        MainBox.WINDOW_BOX.addModItem(newItem);
    }

    private static String getWindowName(ENUMS.WINDOW winType) {
        return MainBox.WINDOW_BOX.getWindowNameByType(winType);
    }
}

