/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemModWindowSetup;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.classes.QdcItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class ModAssemblerItem {
    public QdcItem qdcItem;
    public String name = "";
    public Point pos;
    public boolean isHoveringOver;
    public boolean allItemsDiscovered = false;
    public List<Item> requiredDiscoveryList = new ArrayList<Item>();

    public ModAssemblerItem(QdcItem item, Point pos) {
        this.qdcItem = item;
        this.name = GlobalFuncs.getItemName(item.item);
        this.pos = pos;
        this.update();
    }

    public void update() {
        this.checkIfCanCreate();
    }

    public void checkIfCanCreate() {
        if (this.qdcItem != null) {
            if (this.qdcItem.particles != null) {
                this.allItemsDiscovered = true;
                for (Item i : this.qdcItem.requiredDiscoveryList) {
                    if (QdcApi.QDC_CORE.FUNCTIONS.isItemDiscovered(i)) continue;
                    this.allItemsDiscovered = false;
                }
                for (ParticleItem pi : this.qdcItem.particles.particleList) {
                    pi.checkCanCreate();
                }
            } else {
                ItemModWindowSetup.writeCodeForItem(ItemModWindowSetup.getItemName(this.qdcItem.item));
            }
        }
    }

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }
}

