/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.ResearchMission;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.functions.ResearchMissionFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base.ResearchMissionListItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base.ResearchMissionTab;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ResearchMissionRewardFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ResearchBox {
    public List<ResearchMissionTab> tabList = this.generateTabs();
    public int curTabIndex = 0;
    public ResearchMissionTab curTab = this.getCurTabInit();
    public ResearchMissionListItem curResearchItem = this.getCurMIssionlListItemInit();
    public ResearchMissionListItem curReasearchHovered = null;
    public Item curItemHovered = null;
    public String tabIndexString = "";

    public ResearchBox() {
        this.reset();
    }

    private void setTabIndexString() {
        this.tabIndexString = this.tabList.size() > 1 ? this.curTabIndex + 1 + "/" + this.tabList.size() : "";
    }

    public boolean handleClaimClick() {
        if (this.curResearchItem != null && this.curResearchItem.guiItem.showClaimButton) {
            int numOfEmptySlots = ResearchMissionRewardFunctions.getNumOfEmptySlots();
            int numOfRewards = this.curResearchItem.mission.rewardItems.size();
            if (numOfRewards <= numOfEmptySlots) {
                for (ItemStack is : this.curResearchItem.mission.rewardItems) {
                    int nextFreeSlot = ResearchMissionRewardFunctions.getNextFreeSlot();
                    ResearchMissionRewardFunctions.setItemInInventory(nextFreeSlot, is);
                    int itemID = Item.getId((Item)is.getItem());
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new myData.MyData(nextFreeSlot, itemID, is.getCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                ParticleCollection particles = new ParticleCollection();
                particles.add(new ParticleItem(ENUMS.ParticleType.MANA, this.curResearchItem.mission.manaBonus));
                particles.add(new ParticleItem(ENUMS.ParticleType.MANA_MAX, this.curResearchItem.mission.manaLimitBonus));
                QdcApi.QDC_CORE.FUNCTIONS.addParticles(particles);
                MainBox.RESEARCH_MISSION_BOX.addResearchMissionToComplete(this.curResearchItem.mission.missionName);
                QdcApi.QDC_CORE.FUNCTIONS.save(Qdc.curPlayer);
                return true;
            }
        }
        return false;
    }

    public boolean handlePrevClick() {
        if (this.tabList.size() > 1 && this.curTabIndex > 0) {
            --this.curTabIndex;
            this.curTab = this.tabList.get(this.curTabIndex);
            this.setTabIndexString();
            return true;
        }
        return false;
    }

    public boolean handleNextClick() {
        if (this.tabList.size() > 1 && this.curTabIndex < this.tabList.size() - 1) {
            ++this.curTabIndex;
            this.curTab = this.tabList.get(this.curTabIndex);
            this.setTabIndexString();
            return true;
        }
        return false;
    }

    public void handleMissionClick() {
        this.curResearchItem = this.curReasearchHovered;
    }

    public void checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.curItemHovered = this.curResearchItem.checkIfHoveringOverItem(windowPos, mouseX, mouseY);
        this.curReasearchHovered = this.curTab.checkIfHoveringOver(windowPos, mouseX, mouseY);
    }

    public void reset() {
        this.curTabIndex = 0;
        this.curTab = this.getCurTabInit();
        this.curResearchItem = this.getCurMIssionlListItemInit();
        this.setTabIndexString();
        if (this.curResearchItem != null) {
            this.curResearchItem.mission.countDiscoveries();
        }
    }

    private ResearchMissionListItem getCurMIssionlListItemInit() {
        if (this.curTab != null && this.curTab.missionList.size() > 0) {
            return this.curTab.missionList.get(0);
        }
        return null;
    }

    private ResearchMissionTab getCurTabInit() {
        if (this.tabList.size() > 0) {
            return this.tabList.get(0);
        }
        return null;
    }

    private List<ResearchMissionTab> generateTabs() {
        ArrayList<ResearchMissionTab> res = new ArrayList<ResearchMissionTab>();
        List<ResearchMission> allMIssions = ResearchMissionFunctions.getActiveMissions();
        int index = 0;
        for (ResearchMission mission : allMIssions) {
            if (res.size() == 0) {
                res.add(new ResearchMissionTab());
            }
            if (!((ResearchMissionTab)res.get(index)).hasSpace()) {
                res.add(new ResearchMissionTab());
                ++index;
            }
            ((ResearchMissionTab)res.get(index)).add(mission);
        }
        return res;
    }
}

