/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.EnchanterMachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.EnchantmentFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_enchanter
extends BlockEntity {
    public boolean isWorking = false;
    public EnchanterMachineData machineData = new EnchanterMachineData("Enchanter MK2");
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public ParticleCollection enchantmentParticles = null;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public double natureParticleAmount = 0.0;
    public int powerLevel = 1;
    public boolean hasFuel = false;
    private List<EnchantmentInstance> enchantList = null;

    public tile_entity_enchanter(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_ENCHANTER.get(), pos, state);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getItemStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setEnchantmentPower();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index != 0) {
            GlobalFuncs.showInGameMessage("Machine enchantment power set to: " + this.machineData._powerString);
        }
        return true;
    }

    public boolean hasAnItem() {
        return !this.itemHandler.getStackInSlot(2).isEmpty();
    }

    public boolean updateItem(ItemStack item) {
        this.itemHandler.setStackInSlot(2, item.copy());
        this.getEnchantments();
        this.setChanged();
        if (!item.isEmpty()) {
            GlobalFuncs.showInGameMessage("--------------------------");
            GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
            GlobalFuncs.showInGameMessage("Item set to: " + BERFunctions.getItemName(this.getItemStack()));
        }
        return true;
    }

    private void getEnchantments() {
        if (this.hasAnItem()) {
            if (this.enchantList == null) {
                this.enchantList = EnchantmentFunctions.getEnchantmentsForItem(this.level, this.getItemStack(), 3, this.powerLevel * 3);
                this.machineData.setEnchantments(this.enchantList);
                this.natureParticleAmount = EnchantmentFunctions.calcEnchantCost(this.enchantList);
                this.machineData._cost = GlobalFuncs.formatNumber(new BigDecimal(this.natureParticleAmount), 3);
            }
        } else {
            this.enchantList = null;
            this.machineData.setEnchantments(null);
        }
    }

    private void setEnchantmentPower() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updatePowerLevelByCore();
        this.machineData._powerString = this.speed + 1 + "/7";
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_enchanter.this.setChanged();
                if (slot == 1) {
                    tile_entity_enchanter.this.setEnchantmentPower();
                }
            }
        };
    }

    public void updatePowerLevelByCore() {
        this.powerLevel = this.speed * 2;
        if (this.speed == 7) {
            this.powerLevel = 15;
        }
    }

    public void sendToClient() {
        if (this.level != null) {
            if (this.hasAnItem()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getItemStack());
                if (this.getItemStack().isEnchanted()) {
                    this.machineData._toolTip = "Enchantments Applied Successfully!!";
                    this.machineData._toolTipColor = Color.green;
                } else if (this.enchantList != null && this.enchantList.size() > 0) {
                    if (!this.hasFuel) {
                        this.machineData._toolTip = "Not Enough Nature Particles!!!!";
                        this.machineData._toolTipColor = Color.red;
                    } else {
                        this.machineData._toolTip = "Apply redstone signal to enchant!!";
                        this.machineData._toolTipColor = Color.green;
                    }
                } else {
                    this.machineData._toolTip = "";
                }
            } else {
                this.machineData._toolTip = "No Item to Enchant!!!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.updatePowerLevelByCore();
            if (this.hasAnItem()) {
                this.enchantmentParticles = null;
                this.hasFuel = this.checkIfHasParticlesInStorage();
                if (this.level.getDirectSignalTo(this.getBlockPos()) > 0 && this.hasFuel && this.enchantList != null && this.enchantList.size() > 0) {
                    this.itemHandler.setStackInSlot(2, this.getItemStack().getItem().applyEnchantments(this.getItemStack(), this.enchantList));
                    this.removeFuelParticles();
                    MachineSoundFunctions.playEnchantSound(this.level, this.getBlockPos());
                    this.enchantList = null;
                    this.machineData.clearEnchants();
                }
            }
            this.sendToClient();
        }
    }

    private void removeFuelParticles() {
        QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.enchantmentParticles);
    }

    private boolean checkIfHasParticlesInStorage() {
        if (this.enchantmentParticles == null) {
            this.enchantmentParticles = new ParticleCollection();
            this.enchantmentParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, this.natureParticleAmount));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.enchantmentParticles);
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.ENCHANTER.get()));
        if (this.hasAnItem()) {
            list.add((Object)this.getItemStack());
        }
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.dropStuffs(pos);
        super.preRemoveSideEffects(pos, state);
    }

    protected void saveAdditional(ValueOutput output) {
        this.itemHandler.serialize(output);
        output.putInt("speed", this.speed);
        this.machineData.save(output);
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        this.itemHandler.deserialize(input);
        this.speed = (Integer)input.getInt("speed").get();
        this.updatePowerLevelByCore();
        this.machineData.load(input);
        if (this.hasAnItem()) {
            this.getEnchantments();
        }
        super.loadAdditional(input);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

