/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4;

import com.mojang.logging.LogUtils;
import com.qdc_mod.qdc_core_4.Config;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemParticleRegistration;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.PPM_BER;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.AssemblerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.ConverterScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.DisassemblerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.MainMenuScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.ModAssemblerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.RecyclerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.ResearchMissionBaseScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.RevelationScreen;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_core.functions.BlockBreakFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ManaFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.MobKillFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ModRegistry;
import com.qdc_mod.qdc_core_4.qdc_core.functions.PlayerLoadingFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.TimeFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ToolTipFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.pushy_pully_mergy.PushyPullyMergyFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.network.ServerPayloadHandler;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData2;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.screens.ElevatorScreen;
import com.qdc_mod.qdc_core_4.qdc_elevator.core.init.MenuInit;
import com.qdc_mod.qdc_core_4.qdc_machines.QdcMachines;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_tool.functions.QuantumToolFunctions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="qdc_core_4")
public class Qdc {
    public static final String MOD_ID = "qdc_core_4";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Player curPlayer = null;
    public static ServerPlayer serverPlayer = null;

    public Qdc(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(QdcMachines.class);
        ModRegistry.registerItems(modEventBus);
        ModRegistry.registerBlocks(modEventBus);
        ModRegistry.registerCreativeTabs(modEventBus);
        ModRegistry.registerMenus(modEventBus);
        ModRegistry.registerAttachments(modEventBus);
        ModRegistry.registerBlockEntities(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)com.qdc_mod.qdc_core_4.qdc_core.core.init.BlockInit.EMPTY_PPM_CONTAINER.get()), (RenderType)RenderType.TRANSLUCENT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.AMBER_BLOCK.get()), (RenderType)RenderType.TRANSLUCENT);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.QDC_LIGHT_BLOCK.get()), (RenderType)RenderType.TRANSLUCENT);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.PlayerLoggedInEvent event) {
        curPlayer = event.getEntity();
        PlayerLoadingFunctions.onPlayerLoad(event);
        MainBox.loadModData(curPlayer);
    }

    @SubscribeEvent
    public void onPlayerClose(PlayerEvent.PlayerLoggedOutEvent event) {
        MainBox.clearModData();
        QdcElevatorBox.clear();
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        curPlayer = event.getEntity();
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        MainBox.saveData(curPlayer);
    }

    @SubscribeEvent
    public void onRenderToolTip(ItemTooltipEvent event) {
        ToolTipFunctions.addParticleToolTipToItem(event);
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post event) {
        ManaFunctions.increase();
        TimeFunctions.updateTimeSegs();
        PushyPullyMergyFunctions.TimeFunctions.checkForRegenTime();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockBreakFunctions.handleBlockBreak(event);
    }

    @SubscribeEvent
    public void onMobKill(LivingDeathEvent event) {
        MobKillFunctions.handleMobKIll(event);
    }

    @SubscribeEvent
    public void onMobHit(AttackEntityEvent event) {
        QuantumToolFunctions.onMobRightClick(curPlayer.level(), curPlayer);
    }

    @EventBusSubscriber(modid="qdc_core_4", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playBidirectional(myData.MyData.TYPE, myData.MyData.STREAM_CODEC, ServerPayloadHandler::handleInventoryDataOnMain);
            registrar.playBidirectional(myData2.MyData2.TYPE, myData2.MyData2.STREAM_CODEC, ServerPayloadHandler::handleTeleportDataOnMain);
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(BlockEntityInit.PPM_BLOCKENTITY.get(), PPM_BER::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.MAIN_ITEM_MENU.get(), MainMenuScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.DISASSEMBLER_MENU.get(), DisassemblerScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.ASSEMBLER_MENU.get(), AssemblerScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.MOD_ASSEMBLER_MENU.get(), ModAssemblerScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.CONVERTER_MENU.get(), ConverterScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.RESEARCH_MISSION_BASE_MENU.get(), ResearchMissionBaseScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.RECYCLER_MENU.get(), RecyclerScreen::new);
            event.register((MenuType)com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit.REVELATION_MENU.get(), RevelationScreen::new);
            event.register((MenuType)MenuInit.ELEVATOR_MENU.get(), ElevatorScreen::new);
        }
    }

    public class DisassemblerVariables {
        public static final int ITEM_LIMIT = 16;
        public static List<Item> discoveredItems = new ArrayList<Item>();

        public DisassemblerVariables(Qdc this$0) {
        }

        public static void addNewDIscoveredItem(Item item) {
            discoveredItems.add(item);
        }

        public static List<Item> getDiscoveredItems() {
            int extra;
            ArrayList<Item> res = new ArrayList<Item>();
            if (discoveredItems.size() <= 16) {
                return discoveredItems;
            }
            int count = discoveredItems.size();
            for (int i = extra = count - 16; i < discoveredItems.size(); ++i) {
                res.add(discoveredItems.get(i));
            }
            return res;
        }
    }

    public class AssemblerVariables {
        public static String searchString = "";

        public AssemblerVariables(Qdc this$0) {
        }
    }

    public class ModAssemblerVariables {
        public static String searchString = "";

        public ModAssemblerVariables(Qdc this$0) {
        }
    }

    public class ConverterVariables {
        public static final int CONVERSION_RATE = 20;

        public ConverterVariables(Qdc this$0) {
        }
    }

    public class RandomDropStuffs {
        public static final int MAX_BLOCK_BREAK_COUNT = 10;
        public static final int MAX_MOB_KILL_COUNT = 1;

        public RandomDropStuffs(Qdc this$0) {
        }
    }

    public class ManaStuff {
        public static final int START_MAX_MANA = 100;
        public static final double MANA_REGEN_AMOUNT = 0.05;

        public ManaStuff(Qdc this$0) {
        }
    }

    public class CorruptionStuff {
        public static final double MAX = 250.0;
        public static final double MIN = 5.0;
        public static final double RECALIBRATION_COST = 10.0;

        public CorruptionStuff(Qdc this$0) {
        }

        public class exchangeRate {
            public static final double NATURE = 0.5;
            public static final double FOOD = 1.0;
            public static final double METAL = 2.5;
            public static final double GEM = 10.0;

            public exchangeRate(CorruptionStuff this$1) {
            }
        }
    }

    public class RevelationStuff {
        public static long maxTime = 600000L;
        public static long revelationStart = -1L;
        public static boolean isRevelationReady = false;
        public static int[] timeSegs = null;

        public RevelationStuff(Qdc this$0) {
        }

        public class ParticleRewards {
            public ParticleRewards(RevelationStuff this$1) {
            }

            public class MANA_MAX {
                public static final int FIXED = 1;
                public static final int RANDOM = 5;

                public MANA_MAX(ParticleRewards this$2) {
                }
            }

            public class MANA {
                public static final int FIXED = 1;
                public static final int RANDOM = 10;

                public MANA(ParticleRewards this$2) {
                }
            }

            public class CORRUPTION {
                public static final int FIXED = 1;
                public static final int RANDOM = 3;

                public CORRUPTION(ParticleRewards this$2) {
                }
            }

            public class GEM {
                public static final int FIXED = 1;
                public static final int RANDOM = 3;

                public GEM(ParticleRewards this$2) {
                }
            }

            public class METAL {
                public static final int FIXED = 1;
                public static final int RANDOM = 5;

                public METAL(ParticleRewards this$2) {
                }
            }

            public class FOOD {
                public static final int FIXED = 2;
                public static final int RANDOM = 10;

                public FOOD(ParticleRewards this$2) {
                }
            }

            public class NATURE {
                public static final int FIXED = 5;
                public static final int RANDOM = 50;

                public NATURE(ParticleRewards this$2) {
                }
            }
        }
    }

    public class PushyPullyMergyStuff {
        public static final BigDecimal BASE_PERCENTAGE = new BigDecimal("0.01");
        public static final int MIN_MERGE_SIZE = 3;
        public static final int MAX_MERGE_SIZE = 5;
        public static final int REGEN_TIME_DURATION = 30000;

        public PushyPullyMergyStuff(Qdc this$0) {
        }
    }

    public class ItemParticleRegistrationStore {
        public static ItemParticleRegistration itemParticleRegistrationObj = new ItemParticleRegistration();

        public ItemParticleRegistrationStore(Qdc this$0) {
        }
    }

    public class CraftedItemData {
        public static final double CRAFTING_PERC = 10.0;

        public CraftedItemData(Qdc this$0) {
        }
    }
}

