/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity.PPM_BlockEntity;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class PPM_BER
implements BlockEntityRenderer<PPM_BlockEntity> {
    private final Font font;
    private final PosePoint lvlPos = new PosePoint(0.0f, -17.0f);
    private final PosePoint percPos = new PosePoint(0.0f, 17.0f);
    private float lookToPlayerAngle = 0.0f;
    private final float PLAYER_ANGLE_OFFSET = -90.0f;

    public PPM_BER(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(PPM_BlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.getLevel();
        if (level == null) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = pBlockEntity.inventory.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        int lvl = pBlockEntity.mergeLevel;
        String perc = pBlockEntity.percString;
        int light = this.getLightLevel(pBlockEntity.getLevel(), pBlockEntity.getBlockPos());
        BlockPos pos = pBlockEntity.getBlockPos();
        this.lookToPlayerAngle = BERFunctions.calcToPlayerAngle(Qdc.curPlayer, pos, -90.0f);
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.scale(0.3f, 0.3f, 0.3f);
        pPoseStack.mulPose(Axis.YN.rotationDegrees(this.lookToPlayerAngle));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
        float scale = 0.25f;
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.scale(scale, scale, scale);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        BERFunctions.writeText(this.lvlPos, "lvl: " + lvl, Color.red, this.font, pPoseStack, pBufferSource, light);
        BERFunctions.writeText(this.percPos, perc + "%", Color.red, this.font, pPoseStack, pBufferSource, light);
        pPoseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

