/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entity_renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_item_placer;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.ItemInit;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemPlacerBlockEntityRenderer
implements BlockEntityRenderer<tile_entity_item_placer> {
    private final Color TITLE_COLOR = BERFunctions.COLORS.TITLE_COLOR;
    private final Color TEXT_COLOR = BERFunctions.COLORS.TEXT_COLOR;
    private final Color MAIN_ITEN_NAME_COLOR = BERFunctions.COLORS.MAIN_ITEN_NAME_COLOR;
    private final float PLAYER_ANGLE_OFFSET = -90.0f;
    private final BlockEntityRendererProvider.Context context;
    private float lookToPlayerAngle = 0.0f;
    private String machineName = null;
    private final PosePoint mainIconPos = BERFunctions.POSITIONS.MAIN_ICON_POS;
    private final PosePoint sizeIconPos = BERFunctions.POSITIONS.SIZE_ICON_POS;
    private final PosePoint speedIconPos = BERFunctions.POSITIONS.SPEED_ICON_POS;
    private final PosePoint mainItemNamePos = BERFunctions.POSITIONS.mainItemNamePos;
    private final PosePoint mainTextPos = BERFunctions.POSITIONS.mainTextPos;
    private final PosePoint machineNamePos = BERFunctions.POSITIONS.machineNamePos;
    private final PosePoint sizeTitlePos = BERFunctions.POSITIONS.sizeTitlePos;
    private final PosePoint speetTitlePos = BERFunctions.POSITIONS.speetTitlePos;
    private final PosePoint sizeValuePos = BERFunctions.POSITIONS.sizeValuePos;
    private final PosePoint speedValuePos = BERFunctions.POSITIONS.speedValuePos;

    public ItemPlacerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull tile_entity_item_placer te, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (te.itemHandler == null) {
            return;
        }
        ItemStack mainStack = te.getSeedStack();
        ItemStack invBlock = te.getSizeStack();
        ItemStack speedStack = te.getSpeedStack();
        Level level = te.getLevel();
        if (level == null) {
            return;
        }
        if (level.getBlockState(te.getBlockPos()).getBlock() != BlockInit.ITEM_PLACER.get()) {
            return;
        }
        Direction placerDirection = null;
        if (placerDirection == null) {
            placerDirection = (Direction)level.getBlockState(te.getBlockPos()).getValue(BlockProperties.FACING);
        }
        if (placerDirection == null) {
            return;
        }
        this.machineName = te.machineData._machineName;
        LocalPlayer player = Minecraft.getInstance().player;
        String toolTip = te.machineData._toolTip;
        Color toolTipColor = te.machineData._toolTipColor;
        Font font = this.context.getFont();
        BlockPos pos = te.getBlockPos().above();
        int storage = MainBox.DISCOVERY_BOX.getItemCount(mainStack.getItem());
        int packedLight = 240;
        this.lookToPlayerAngle = BERFunctions.calcToPlayerAngle((Player)player, pos, -90.0f);
        poseStack.pushPose();
        switch (placerDirection) {
            case DOWN: {
                poseStack.translate(0.5, (double)0.1f, 0.5);
                break;
            }
            case EAST: {
                poseStack.translate(0.75, 0.5, 0.5);
                break;
            }
            case NORTH: {
                poseStack.translate(0.5, 0.5, 0.25);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.5, 0.5, 0.75);
                break;
            }
            case UP: {
                poseStack.translate(0.5, 1.0, 0.5);
                break;
            }
            case WEST: {
                poseStack.translate(0.25, 0.5, 0.5);
                break;
            }
            default: {
                poseStack.translate(0.5, (double)1.7f, 0.5);
            }
        }
        poseStack.mulPose(Axis.YN.rotationDegrees(this.lookToPlayerAngle));
        this.drawBackground(poseStack, pBuffer, level, packedLight);
        poseStack.translate(0.0f, 0.0f, 0.05f);
        this.drawIcons(mainStack, invBlock, speedStack, poseStack, pBuffer, level, packedLight);
        this.writeAllText(storage, toolTip, te.machineData._sizeString, te.machineData._speedString, te.machineData._mainItemName, toolTipColor, font, poseStack, pBuffer, packedLight);
        poseStack.popPose();
    }

    private void drawBackground(PoseStack poseStack, MultiBufferSource buffer, Level level, int packedLight) {
        this.context.getItemRenderer().renderStatic(new ItemStack((ItemLike)ItemInit.QDC_MACHINE_SCREEN_BG.get()), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, level, 0);
    }

    private void drawIcons(ItemStack mainItemStack, ItemStack sizeStack, ItemStack speedStack, PoseStack ps, MultiBufferSource buffer, Level level, int packedLight) {
        float scale = 0.25f;
        ps.scale(scale, scale, scale);
        if (mainItemStack != null) {
            BERFunctions.drawIcon(this.mainIconPos, this.context, mainItemStack, ps, buffer, level, packedLight);
        }
        if (sizeStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.sizeIconPos, this.context, sizeStack, ps, buffer, level, packedLight);
        }
        if (speedStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.speedIconPos, this.context, speedStack, ps, buffer, level, packedLight);
        }
    }

    private void writeAllText(int storage, String mainText, String sizeString, String speedString, String mainItemName, Color color, Font font, PoseStack ps, MultiBufferSource buffer, int packedLight) {
        float scale = 0.025f;
        ps.scale(scale, scale, scale);
        ps.mulPose(Axis.XP.rotationDegrees(180.0f));
        BERFunctions.writeText(this.mainTextPos, mainText, color, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.machineNamePos, this.machineName, this.TITLE_COLOR, font, ps, buffer, packedLight);
        if (!mainItemName.isEmpty()) {
            BERFunctions.writeText(this.mainItemNamePos, mainItemName + " (" + storage + ")", this.MAIN_ITEN_NAME_COLOR, font, ps, buffer, packedLight);
        }
        BERFunctions.writeText(this.sizeTitlePos, "Inv Block", this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.speetTitlePos, "Speed", this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.sizeValuePos, sizeString, this.TEXT_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.speedValuePos, speedString, this.TEXT_COLOR, font, ps, buffer, packedLight);
    }
}

