/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.revelation_box;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.revelation_box.classes.ParticleRewardItem;
import com.qdc_mod.qdc_core_4.qdc_core.functions.TimeFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.Item;

public class RevelationBox {
    public List<ParticleRewardItem> particleRewardItemList = this.generateParticleRewardList();
    public ParticleCollection particleReward = null;
    public Item itemReward = null;
    public String itemRewardString;
    Random random = new Random();

    public boolean handleClaimClick() {
        if (this.particleReward != null) {
            QdcApi.QDC_CORE.FUNCTIONS.addParticles(this.particleReward);
        }
        if (this.itemReward != null && !MainBox.DISCOVERY_BOX.isItemDiscovered(this.itemReward)) {
            MainBox.DISCOVERY_BOX.addDiscoveredItem(new DiscoveryItem(this.itemReward, 0));
            Qdc.DisassemblerVariables.addNewDIscoveredItem(this.itemReward);
            MainBox.ITEM_BOX.setDiscovered(this.itemReward, true);
            MainBox.WINDOW_BOX.calcWindowDiscoveries();
        }
        Qdc.RevelationStuff.isRevelationReady = false;
        TimeFunctions.setStartTime();
        MainBox.saveData(Qdc.curPlayer);
        return true;
    }

    public void generateRewards() {
        this.generateParticleRewards();
        this.getRandomUndiscoveredItem();
    }

    public void clearRewards() {
        this.particleReward = null;
        this.itemReward = null;
        this.itemRewardString = "";
    }

    private void generateParticleRewards() {
        this.particleReward = new ParticleCollection();
        for (ParticleRewardItem item : this.particleRewardItemList) {
            this.particleReward.add(new ParticleItem(item.type, item.getValue(this.random)));
        }
    }

    private void getRandomUndiscoveredItem() {
        List<Item> allItems = MainBox.ITEM_BOX.getAllUndiscoveredItems();
        this.itemReward = this.getRandomItem(allItems);
        this.itemRewardString = GlobalFuncs.getItemName(this.itemReward);
    }

    private Item getRandomItem(List<Item> allItems) {
        if (allItems.size() == 0) {
            return null;
        }
        int index = this.random.nextInt(allItems.size());
        return allItems.get(index);
    }

    private List<ParticleRewardItem> generateParticleRewardList() {
        ArrayList<ParticleRewardItem> res = new ArrayList<ParticleRewardItem>();
        res.add(new ParticleRewardItem(ENUMS.ParticleType.NATURE, 5, 50));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.FOOD, 2, 10));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.METAL, 1, 5));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.GEM, 1, 3));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.CORRUPTION, 1, 3));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.MANA, 1, 10));
        res.add(new ParticleRewardItem(ENUMS.ParticleType.MANA_MAX, 1, 5));
        return res;
    }
}

