/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.converter;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.converter.ParticleCategory;

public class ConverterBox {
    public final String validChars = "0123456789";
    public ParticleCategory from = new ParticleCategory(ENUMS.ParticleType.NATURE, 20);
    public ParticleCategory to = new ParticleCategory(ENUMS.ParticleType.FOOD, 1);
    public ParticleChangeType particleChangeType = ParticleChangeType.PARTICLE_UPGRADE;
    public String particleChangeTypeString = "";
    public String ratio = "";
    public String textBoxString = "";
    public long textBoxInt = 0L;
    public long canUse = 0L;
    public long canGet = 0L;
    public boolean showConvertButton = false;

    public ConverterBox() {
        this.update();
    }

    public void clear() {
        this.particleChangeTypeString = "";
        this.ratio = "";
        this.textBoxString = "";
        this.textBoxInt = 0L;
        this.canUse = 0L;
        this.canGet = 0L;
    }

    public void handleConvertClick() {
        QdcApi.QDC_CORE.FUNCTIONS.removeParticlesLong(this.from.type, this.canUse);
        QdcApi.QDC_CORE.FUNCTIONS.addParticlesLong(this.to.type, this.canGet);
        QdcApi.QDC_CORE.FUNCTIONS.save(Qdc.curPlayer);
        ENUMS.ParticleType fromType = this.from.type;
        ENUMS.ParticleType toType = this.to.type;
        ParticleChangeType changeType = this.particleChangeType;
        this.handleSelectionClick(fromType, toType, changeType);
    }

    public void handleSelectionClick(ENUMS.ParticleType fromType, ENUMS.ParticleType toType, ParticleChangeType changeType) {
        this.particleChangeType = changeType;
        if (changeType == ParticleChangeType.PARTICLE_UPGRADE) {
            this.from = new ParticleCategory(fromType, 20);
            this.to = new ParticleCategory(toType, 1);
        } else {
            this.from = new ParticleCategory(fromType, 1);
            this.to = new ParticleCategory(toType, 20);
        }
        this.update();
        this.updateCanUse();
        this.updateCanGet();
        this.updateShowConvertButton();
    }

    public void updateShowConvertButton() {
        this.showConvertButton = this.canGet > 0L;
    }

    public void updateCanGet() {
        this.canGet = this.canUse > 0L ? (this.particleChangeType == ParticleChangeType.PARTICLE_UPGRADE ? this.canUse / (long)this.from.ratio : this.canUse * (long)this.to.ratio) : 0L;
        this.to.setTransaction(this.canGet);
    }

    public void updateCanUse() {
        this.canUse = this.from.haveEnoughParticles(this.textBoxInt) ? this.textBoxInt : (long)this.from.particlesHave.intValue();
        this.canUse = this.round(this.canUse);
        this.from.setTransaction(this.canUse);
    }

    private long round(long num) {
        int ratio = this.from.ratio;
        long rem = num % (long)ratio;
        long res = num - rem;
        return res;
    }

    public String fixTextBoxString(String str) {
        char[] parts;
        Object res = "";
        for (char c : parts = str.toCharArray()) {
            if (!this.isValidChar(c)) continue;
            res = (String)res + c;
        }
        this.textBoxString = res;
        this.textBoxInt = this.textBoxString.isBlank() ? 0L : Long.parseLong((String)res);
        this.updateCanUse();
        this.updateCanGet();
        this.updateShowConvertButton();
        return res;
    }

    private boolean isValidChar(char c) {
        return "0123456789".contains("" + c);
    }

    public void update() {
        this.setChangeTypeString();
        this.setRatioString();
    }

    public void setRatioString() {
        this.ratio = this.from.ratio + " : " + this.to.ratio;
    }

    public void setChangeTypeString() {
        switch (this.particleChangeType.ordinal()) {
            case 1: {
                this.particleChangeTypeString = "Particle Downgrade";
                break;
            }
            case 0: {
                this.particleChangeTypeString = "Particle Upgrade";
            }
        }
    }

    public static enum ParticleChangeType {
        PARTICLE_UPGRADE,
        PARTICLE_DOWNGRADE;

    }
}

