/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.classes.ModWindow;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler.ModWindowItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler.ModWindowTab;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class ModAssemblerBox {
    public final int WINDOW_LIST_MAX = 3;
    public List<ModWindowTab> windowTabList = new ArrayList<ModWindowTab>();
    public ModWindowTab curWindowTab = null;
    public int curWindowTabIndex = 1;
    public int windowTabCount = 1;

    public ModAssemblerBox() {
        this.doSearch();
    }

    public void checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        if (this.curWindowTab != null) {
            this.curWindowTab.checkIfHoveringOver(windowPos, mouseX, mouseY);
            if (this.curWindowTab.curWindow != null && this.curWindowTab.curWindow.curItemTab != null) {
                this.curWindowTab.curWindow.curItemTab.checkIfHoveringOver(windowPos, mouseX, mouseY);
            }
        }
    }

    public void doSearch() {
        this.windowTabList = new ArrayList<ModWindowTab>();
        this.populateWindows();
        this.curWindowTab = null;
        this.setFirstWindowTab();
    }

    public void setFirstWindowTab() {
        if (this.windowTabList.size() > 0) {
            this.curWindowTab = this.windowTabList.get(0);
        } else {
            this.curWindowTab = null;
            this.curWindowTabIndex = 0;
            this.windowTabCount = 0;
        }
    }

    public void populateWindows() {
        this.curWindowTabIndex = 1;
        this.windowTabCount = 1;
        String search = Qdc.ModAssemblerVariables.searchString;
        int tabIndex = 0;
        for (ModWindow w : MainBox.MOD_WINDOW_BOX.windowList) {
            if (!w.hasSearchString(search)) continue;
            if (this.windowTabList.size() == 0) {
                this.windowTabList.add(new ModWindowTab());
            }
            if (!this.windowTabList.get((int)tabIndex).hasSpace) {
                this.windowTabList.add(new ModWindowTab());
                ++this.windowTabCount;
                ++tabIndex;
            }
            this.windowTabList.get(tabIndex).add(new ModWindowItem(w.WindowIconItem.getItem(), w.name, w.itemList));
        }
    }

    public void handleCategoryClick() {
        if (this.curWindowTab != null && this.curWindowTab.curWindowItemHover != null) {
            this.curWindowTab.curWindow = this.curWindowTab.curWindowItemHover;
        }
    }

    public boolean handleNextClick() {
        if (this.curWindowTabIndex - 1 < this.windowTabList.size() - 1) {
            ++this.curWindowTabIndex;
            this.curWindowTab = this.windowTabList.get(this.curWindowTabIndex - 1);
            return true;
        }
        return false;
    }

    public boolean handlePrevClick() {
        if (this.curWindowTabIndex > 1) {
            --this.curWindowTabIndex;
            this.curWindowTab = this.windowTabList.get(this.curWindowTabIndex - 1);
            return true;
        }
        return false;
    }
}

