/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.converter.ConverterBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.functions.GuiSoundFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ConverterSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.ConverterMenu;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class ConverterScreen
extends AbstractContainerScreen<ConverterMenu> {
    private ConverterBox converterBox = new ConverterBox();
    private final Point WINDOW_SIZE = AssemblerSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private final Point TXT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TEXTBOX.POS;
    private final Point TXT_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TEXTBOX.SIZE;
    private EditBox txtExchange;
    private Point titleSize;
    private Point titlePos;
    private final Color windowFillColor;
    private final Color windowBorderColor;
    private final Point SELECTION_WINDOW_SIZE;
    private final Point UPGRADE_WINDOW_POS;
    private final Point SELECTION_TITLE_SIZE;
    private final Color SELECTION_TITLE_BG_COLOR;
    private final Color SELECTION_TITLE_TEXT_COLOR;
    private final Point DOWNGRADE_WINDOW_POS;
    private final Point CONVERSION_WINDOW_SIZE;
    private final Point CONVERSION_WINDOW_POS;
    private final Point CHANGE_TYPE_SIZE;
    private final Point CHANGE_TYPE_POS;
    private final Point CHANGE_TYPE_TEXT_POS;
    private final Color CHANGE_TYPE_TEXT_COLOR;
    private final Color CHANGE_TYPE_BG_COLOR;
    private final Point RATIO_SIZE;
    private final Point RATIO_POS;
    private final Point RATIO_TEXT_POS;
    private final Color RATIO_TEXT_COLOR;
    private final Color RATIO_BG_COLOR;
    private final FromWindow fromWindow;
    private final ToWindow toWindow;
    private final Color BTN_TEXT_COLOR;
    private final Color BTN_TEXT_COLOR_HOVER;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.UPGRADE_WINDOW.LIST.UPGRADE_ITEM_LIST.get(0), ConverterSettings.CONSTANTS.BUTTON.SIZE, "->", btnType.UPGRADE_NATURE, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.NATURE), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.FOOD)));
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.UPGRADE_WINDOW.LIST.UPGRADE_ITEM_LIST.get(1), ConverterSettings.CONSTANTS.BUTTON.SIZE, "->", btnType.UPGRADE_FOOD, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.FOOD), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.METAL)));
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.UPGRADE_WINDOW.LIST.UPGRADE_ITEM_LIST.get(2), ConverterSettings.CONSTANTS.BUTTON.SIZE, "->", btnType.UPGRADE_METAL, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.METAL), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.GEM)));
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.DOWNGRADE_WINDOW.LIST.DOWNGRADE_ITEM_LIST.get(0), ConverterSettings.CONSTANTS.BUTTON.SIZE, "<-", btnType.DOWNGRADE_FOOD, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.NATURE), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.FOOD)));
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.DOWNGRADE_WINDOW.LIST.DOWNGRADE_ITEM_LIST.get(1), ConverterSettings.CONSTANTS.BUTTON.SIZE, "<-", btnType.DOWNGRADE_METAL, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.FOOD), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.METAL)));
        res.add(new GuiButton(this, ConverterSettings.SELECTION_WINDOWS.DOWNGRADE_WINDOW.LIST.DOWNGRADE_ITEM_LIST.get(2), ConverterSettings.CONSTANTS.BUTTON.SIZE, "<-", btnType.DOWNGRADE_GEM, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.METAL), QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.GEM)));
        res.add(new GuiButton(this, ConverterSettings.CONVERSION_WINDOW.CONVERT_BUTTON.POS, ConverterSettings.CONVERSION_WINDOW.CONVERT_BUTTON.SIZE, "Convert", btnType.CONVERT, null, null));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public ConverterScreen(ConverterMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.windowFillColor = Color.pink;
        this.windowBorderColor = Color.white;
        this.SELECTION_WINDOW_SIZE = ConverterSettings.SELECTION_WINDOWS.SIZE;
        this.UPGRADE_WINDOW_POS = ConverterSettings.SELECTION_WINDOWS.UPGRADE_WINDOW.POS;
        this.SELECTION_TITLE_SIZE = ConverterSettings.SELECTION_WINDOWS.TITLE.SIZE;
        this.SELECTION_TITLE_BG_COLOR = ConverterSettings.SELECTION_WINDOWS.TITLE.BG_COLOR;
        this.SELECTION_TITLE_TEXT_COLOR = ConverterSettings.SELECTION_WINDOWS.TITLE.TEXT_COLOR;
        this.DOWNGRADE_WINDOW_POS = ConverterSettings.SELECTION_WINDOWS.DOWNGRADE_WINDOW.POS;
        this.CONVERSION_WINDOW_SIZE = ConverterSettings.CONVERSION_WINDOW.SIZE;
        this.CONVERSION_WINDOW_POS = ConverterSettings.CONVERSION_WINDOW.POS;
        this.CHANGE_TYPE_SIZE = ConverterSettings.CONVERSION_WINDOW.CHANGE_TYPE.SIZE;
        this.CHANGE_TYPE_POS = ConverterSettings.CONVERSION_WINDOW.CHANGE_TYPE.POS;
        this.CHANGE_TYPE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.CHANGE_TYPE.TEXT_POS;
        this.CHANGE_TYPE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.CHANGE_TYPE.TEXT_COLOR;
        this.CHANGE_TYPE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.CHANGE_TYPE.BG_COLOR;
        this.RATIO_SIZE = ConverterSettings.CONVERSION_WINDOW.RATIO.SIZE;
        this.RATIO_POS = ConverterSettings.CONVERSION_WINDOW.RATIO.POS;
        this.RATIO_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.RATIO.TEXT_POS;
        this.RATIO_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.RATIO.TEXT_COLOR;
        this.RATIO_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.RATIO.BG_COLOR;
        this.fromWindow = new FromWindow();
        this.toWindow = new ToWindow();
        this.BTN_TEXT_COLOR = ConverterSettings.CONSTANTS.BUTTON.TEXT_COLOR;
        this.BTN_TEXT_COLOR_HOVER = ConverterSettings.CONSTANTS.BUTTON.TEXT_COLOR_HOVER;
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.txtExchange = new EditBox(this.font, this.WINDOW_POS.x + this.TXT_POS.x, this.WINDOW_POS.y + this.TXT_POS.y, this.TXT_SIZE.x, this.TXT_SIZE.y, (Component)Component.literal((String)"txtExchange"));
        this.txtExchange.setCanLoseFocus(false);
        this.txtExchange.setTextColor(Color.white.getRGB());
        this.txtExchange.setBordered(true);
        this.txtExchange.setMaxLength(10);
        this.txtExchange.setResponder(this::onExchangeChanged);
        this.txtExchange.setValue("");
        this.addRenderableWidget((GuiEventListener)this.txtExchange);
        this.txtExchange.setEditable(true);
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
    }

    public void onExchangeChanged(String search) {
        String newStr = this.converterBox.fixTextBoxString(search);
        if (!newStr.equals(this.txtExchange.getValue())) {
            this.txtExchange.setValue(newStr);
        }
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.txtExchange);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return !this.txtExchange.keyPressed(keyCode, scanCode, modifiers) && !this.txtExchange.canConsumeInput() ? super.keyPressed(keyCode, scanCode, modifiers) : true;
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Particle Converter");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawDowngradeWindow(gg);
        this.drawUpgradeWindow(gg);
        this.drawConversionWindow(gg);
        this.drawButtons(gg);
    }

    private void drawUpgradeWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.UPGRADE_WINDOW_POS, this.SELECTION_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.UPGRADE_WINDOW_POS, this.SELECTION_TITLE_SIZE, this.SELECTION_TITLE_BG_COLOR, this.windowBorderColor);
        this.writeStringCentred(gg, "Upgrade Particles", this.UPGRADE_WINDOW_POS.x + this.SELECTION_WINDOW_SIZE.x / 2, this.UPGRADE_WINDOW_POS.y + 2, this.SELECTION_TITLE_TEXT_COLOR);
    }

    private void drawDowngradeWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.DOWNGRADE_WINDOW_POS, this.SELECTION_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.DOWNGRADE_WINDOW_POS, this.SELECTION_TITLE_SIZE, this.SELECTION_TITLE_BG_COLOR, this.windowBorderColor);
        this.writeStringCentred(gg, "Downgrade Particles", this.DOWNGRADE_WINDOW_POS.x + this.SELECTION_WINDOW_SIZE.x / 2, this.DOWNGRADE_WINDOW_POS.y + 2, this.SELECTION_TITLE_TEXT_COLOR);
    }

    private void drawConversionWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.CONVERSION_WINDOW_POS, this.CONVERSION_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.CHANGE_TYPE_POS, this.CHANGE_TYPE_SIZE, this.CHANGE_TYPE_BG_COLOR, this.windowBorderColor);
        this.writeStringCentred(gg, this.converterBox.particleChangeTypeString, this.CHANGE_TYPE_TEXT_POS.x, this.CHANGE_TYPE_TEXT_POS.y, this.CHANGE_TYPE_TEXT_COLOR);
        this.drawRectangleWithBorder(gg, this.RATIO_POS, this.RATIO_SIZE, this.RATIO_BG_COLOR, this.windowBorderColor);
        this.writeStringCentred(gg, this.converterBox.ratio, this.RATIO_TEXT_POS.x, this.RATIO_TEXT_POS.y, this.RATIO_TEXT_COLOR);
        this.fromWindow.drawWindow(gg);
        this.toWindow.drawWindow(gg);
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (button.type != btnType.CONVERT) {
                if (this.curHoverItem == button.type) {
                    this.drawButton(gg, button.pos, button.size, true);
                    this.writeStringCentred(gg, button.text, button.pos.x + 30, button.pos.y + 5, this.BTN_TEXT_COLOR_HOVER);
                } else {
                    this.drawButton(gg, button.pos, button.size, false);
                    this.writeStringCentred(gg, button.text, button.pos.x + 30, button.pos.y + 5, this.BTN_TEXT_COLOR);
                }
                this.drawItemIcon(gg, button.left, button.pos.x + 1, button.pos.y + 1);
                this.drawItemIcon(gg, button.right, button.pos.x + 41, button.pos.y + 1);
                continue;
            }
            if (!this.converterBox.showConvertButton) continue;
            if (this.curHoverItem == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + 60, button.pos.y + 5, this.BTN_TEXT_COLOR_HOVER);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + 60, button.pos.y + 5, this.BTN_TEXT_COLOR);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 6: {
                    if (!this.converterBox.showConvertButton) break;
                    this.converterBox.handleConvertClick();
                    this.playClickSound();
                    break;
                }
                case 0: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.NATURE, ENUMS.ParticleType.FOOD, ConverterBox.ParticleChangeType.PARTICLE_UPGRADE);
                    this.playClickSound();
                    break;
                }
                case 1: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.FOOD, ENUMS.ParticleType.METAL, ConverterBox.ParticleChangeType.PARTICLE_UPGRADE);
                    this.playClickSound();
                    break;
                }
                case 2: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.METAL, ENUMS.ParticleType.GEM, ConverterBox.ParticleChangeType.PARTICLE_UPGRADE);
                    this.playClickSound();
                    break;
                }
                case 3: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.FOOD, ENUMS.ParticleType.NATURE, ConverterBox.ParticleChangeType.PARTICLE_DOWNGRADE);
                    this.playClickSound();
                    break;
                }
                case 4: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.METAL, ENUMS.ParticleType.FOOD, ConverterBox.ParticleChangeType.PARTICLE_DOWNGRADE);
                    this.playClickSound();
                    break;
                }
                case 5: {
                    this.converterBox.handleSelectionClick(ENUMS.ParticleType.GEM, ENUMS.ParticleType.METAL, ConverterBox.ParticleChangeType.PARTICLE_DOWNGRADE);
                    this.playClickSound();
                    break;
                }
            }
        }
        return false;
    }

    private void playClickSound() {
        GuiSoundFunctions.playClickSound(this.player);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;
        public Item left;
        public Item right;

        public GuiButton(ConverterScreen this$0, Point pos, Point size, String text, btnType type, Item from, Item to) {
            super(pos, size, text);
            this.type = type;
            this.left = from;
            this.right = to;
        }
    }

    public static enum btnType {
        UPGRADE_NATURE,
        UPGRADE_FOOD,
        UPGRADE_METAL,
        DOWNGRADE_FOOD,
        DOWNGRADE_METAL,
        DOWNGRADE_GEM,
        CONVERT;

    }

    private class FromWindow {
        private final Point CUR_WINDOW_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.SIZE;
        private final Point CUR_WINDOW_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.POS;
        private final Color CUR_WINDOW_BG = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.BG_COLOR;
        private final Point TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TITLE.SIZE;
        private final Point TITLE_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TITLE.POS;
        private final Point TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TITLE.TEXT_POS;
        private final Color TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TITLE.TEXT_COLOR;
        private final Color TITLE_BG = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TITLE.BG_COLOR;
        private final Point TYPE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.TITLE.POS;
        private final Point TYPE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.TITLE.TEXT_POS;
        private final Point TYPE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.TITLE.SIZE;
        private final Color TYPE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.TITLE.BG_COLOR;
        private final Color TYPE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.TITLE.TEXT_COLOR;
        private final Point FROM_ICON_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.ICON.POS;
        private final Point FROM_NAME_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.NAME.POS;
        private final Color FROM_NAME_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.TYPE.NAME.TEXT_COLOR;
        private final Point HAVE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.TITLE.POS;
        private final Point HAVE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.TITLE.TEXT_POS;
        private final Point HAVE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.TITLE.SIZE;
        private final Color HAVE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.TITLE.BG_COLOR;
        private final Color HAVE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.TITLE.TEXT_COLOR;
        private final Point HAVE_AMOUNT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.AMOUNT.POS;
        private final Color HAVE_AMOUNT_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.HAVE.AMOUNT.TEXT_COLOR;
        private final Point EXCHANGE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.TITLE.POS;
        private final Point EXCHANGE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.TITLE.TEXT_POS;
        private final Point EXCHANGE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.TITLE.SIZE;
        private final Color EXCHANGE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.TITLE.BG_COLOR;
        private final Color EXCHANGE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.TITLE.TEXT_COLOR;
        private final Point EXCHANGE_AMOUNT_POS = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.AMOUNT.POS;
        private final Color EXCHANGE_AMOUNT_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.FROM_WINDOW.EXCHANGE.AMOUNT.TEXT_COLOR;

        private FromWindow() {
        }

        private void drawWindow(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.CUR_WINDOW_POS, this.CUR_WINDOW_SIZE, this.CUR_WINDOW_BG, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.drawRectangleWithBorder(gg, this.TITLE_POS, this.TITLE_SIZE, this.TITLE_BG, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeStringCentred(gg, "From:", this.TITLE_TEXT_POS.x, this.TITLE_TEXT_POS.y, this.TITLE_TEXT_COLOR);
            this.drawTypeSection(gg);
            this.drawHaveSection(gg);
            this.drawExchangeSection(gg);
        }

        private void drawTypeSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.TYPE_TITLE_POS, this.TYPE_TITLE_SIZE, this.TYPE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Type:", this.TYPE_TITLE_TEXT_POS.x, this.TYPE_TITLE_TEXT_POS.y, this.TYPE_TITLE_TEXT_COLOR);
            ConverterScreen.this.drawItemIcon(gg, ConverterScreen.this.converterBox.from.icon, this.FROM_ICON_POS.x, this.FROM_ICON_POS.y);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.from.name, this.FROM_NAME_POS.x, this.FROM_NAME_POS.y, this.FROM_NAME_COLOR);
        }

        private void drawHaveSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.HAVE_TITLE_POS, this.HAVE_TITLE_SIZE, this.HAVE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Have:", this.HAVE_TITLE_TEXT_POS.x, this.HAVE_TITLE_TEXT_POS.y, this.HAVE_TITLE_TEXT_COLOR);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.from.particleHaveString, this.HAVE_AMOUNT_POS.x, this.HAVE_AMOUNT_POS.y, this.HAVE_AMOUNT_TEXT_COLOR);
        }

        private void drawExchangeSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.EXCHANGE_TITLE_POS, this.EXCHANGE_TITLE_SIZE, this.EXCHANGE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Exchange:", this.EXCHANGE_TITLE_TEXT_POS.x, this.EXCHANGE_TITLE_TEXT_POS.y, this.EXCHANGE_TITLE_TEXT_COLOR);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.from.transactionString, this.EXCHANGE_AMOUNT_POS.x, this.EXCHANGE_AMOUNT_POS.y, this.EXCHANGE_AMOUNT_TEXT_COLOR);
        }
    }

    private class ToWindow {
        private final Point CUR_WINDOW_SIZE = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.SIZE;
        private final Point CUR_WINDOW_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.POS;
        private final Color CUR_WINDOW_BG = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.BG_COLOR;
        private final Point TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TITLE.SIZE;
        private final Point TITLE_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TITLE.POS;
        private final Point TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TITLE.TEXT_POS;
        private final Color TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TITLE.TEXT_COLOR;
        private final Color TITLE_BG = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TITLE.BG_COLOR;
        private final Point TYPE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.TITLE.POS;
        private final Point TYPE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.TITLE.TEXT_POS;
        private final Point TYPE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.TITLE.SIZE;
        private final Color TYPE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.TITLE.BG_COLOR;
        private final Color TYPE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.TITLE.TEXT_COLOR;
        private final Point ICON_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.ICON.POS;
        private final Point NAME_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.NAME.POS;
        private final Color NAME_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.TYPE.NAME.TEXT_COLOR;
        private final Point HAVE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.TITLE.POS;
        private final Point HAVE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.TITLE.TEXT_POS;
        private final Point HAVE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.TITLE.SIZE;
        private final Color HAVE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.TITLE.BG_COLOR;
        private final Color HAVE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.TITLE.TEXT_COLOR;
        private final Point HAVE_AMOUNT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.AMOUNT.POS;
        private final Color HAVE_AMOUNT_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.HAVE.AMOUNT.TEXT_COLOR;
        private final Point EXCHANGE_TITLE_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.TITLE.POS;
        private final Point EXCHANGE_TITLE_TEXT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.TITLE.TEXT_POS;
        private final Point EXCHANGE_TITLE_SIZE = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.TITLE.SIZE;
        private final Color EXCHANGE_TITLE_BG_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.TITLE.BG_COLOR;
        private final Color EXCHANGE_TITLE_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.TITLE.TEXT_COLOR;
        private final Point EXCHANGE_AMOUNT_POS = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.AMOUNT.POS;
        private final Color EXCHANGE_AMOUNT_TEXT_COLOR = ConverterSettings.CONVERSION_WINDOW.TO_WINDOW.EXCHANGE.AMOUNT.TEXT_COLOR;

        private ToWindow() {
        }

        private void drawWindow(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.CUR_WINDOW_POS, this.CUR_WINDOW_SIZE, this.CUR_WINDOW_BG, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.drawRectangleWithBorder(gg, this.TITLE_POS, this.TITLE_SIZE, this.TITLE_BG, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeStringCentred(gg, "To:", this.TITLE_TEXT_POS.x, this.TITLE_TEXT_POS.y, this.TITLE_TEXT_COLOR);
            this.drawTypeSection(gg);
            this.drawHaveSection(gg);
            this.drawExchangeSection(gg);
        }

        private void drawTypeSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.TYPE_TITLE_POS, this.TYPE_TITLE_SIZE, this.TYPE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Type:", this.TYPE_TITLE_TEXT_POS.x, this.TYPE_TITLE_TEXT_POS.y, this.TYPE_TITLE_TEXT_COLOR);
            ConverterScreen.this.drawItemIcon(gg, ConverterScreen.this.converterBox.to.icon, this.ICON_POS.x, this.ICON_POS.y);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.to.name, this.NAME_POS.x, this.NAME_POS.y, this.NAME_COLOR);
        }

        private void drawHaveSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.HAVE_TITLE_POS, this.HAVE_TITLE_SIZE, this.HAVE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Have:", this.HAVE_TITLE_TEXT_POS.x, this.HAVE_TITLE_TEXT_POS.y, this.HAVE_TITLE_TEXT_COLOR);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.to.particleHaveString, this.HAVE_AMOUNT_POS.x, this.HAVE_AMOUNT_POS.y, this.HAVE_AMOUNT_TEXT_COLOR);
        }

        private void drawExchangeSection(GuiGraphics gg) {
            ConverterScreen.this.drawRectangleWithBorder(gg, this.EXCHANGE_TITLE_POS, this.EXCHANGE_TITLE_SIZE, this.EXCHANGE_TITLE_BG_COLOR, ConverterScreen.this.windowBorderColor);
            ConverterScreen.this.writeString(gg, "Get:", this.EXCHANGE_TITLE_TEXT_POS.x, this.EXCHANGE_TITLE_TEXT_POS.y, this.EXCHANGE_TITLE_TEXT_COLOR);
            ConverterScreen.this.writeString(gg, ConverterScreen.this.converterBox.to.transactionString, this.EXCHANGE_AMOUNT_POS.x, this.EXCHANGE_AMOUNT_POS.y, this.EXCHANGE_AMOUNT_TEXT_COLOR);
        }
    }
}

