/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.disassembler.DisassemblerInventoryItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.functions.GuiSoundFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.DisassemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.DisassemblerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.functions.DisassemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class DisassemblerScreen
extends AbstractContainerScreen<DisassemblerMenu> {
    private btnType curHoverItem = null;
    private Player player;
    private final Point windowSize = new Point(400, 145);
    private final Point windowPos = new Point(0, 0);
    private DisassemblerInventoryItem curItem = null;
    private List<Item> lastDiscoveredItems = null;
    private Point titleSize;
    private Point titlePos;
    private final Point DISCOVERY_WINDOW_POS;
    private final Point DISCOVERY_WINDOW_SIZE;
    private final Point DISCOVERY_TITLE_POS;
    private final Point DISCOVERY_TITLE_SIZE;
    private final List<Point> DISCOVERY_ITEM_POS_LIST;
    private final Point INFO_WINDOW_POS;
    private final Point INFO_WINDOW_SIZE;
    private final Point INFO_NAME_POS;
    private final Point INFO_NAME_SIZE;
    private final Point INFO_ICON_POS;
    private final Color INFO_NAME_COLOR;
    private final List<Point> PARTICLE_POS_LIST;
    private final Point MSG_ONE_POS;
    private final Point MSG_TWO_POS;
    private final Point MSG_THREE_POS;
    private final String MSG_ONE = "Left Click: Disassemble 1 item.";
    private final String MSG_TWO = "Right Click: Disassemble whole stack.";
    private final String MSG_THREE = "Scroll Click: Disassemble all stacks.";
    private final Color windowFillColor;
    private final Color windowBorderColor;
    private final Color buttonFill;
    private final Color buttonBorder;
    private final Color buttonBorderActive;
    private final Point iconGap;
    private final Point amountGap;

    public DisassemblerScreen(DisassemblerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.windowSize.x, 16);
        this.titlePos = new Point(this.windowPos.x, this.windowPos.y - 22);
        this.DISCOVERY_WINDOW_POS = DisassemblerSettings.DISCOVERY_WINDOW.POS;
        this.DISCOVERY_WINDOW_SIZE = DisassemblerSettings.DISCOVERY_WINDOW.SIZE;
        this.DISCOVERY_TITLE_POS = DisassemblerSettings.DISCOVERY_WINDOW.TITLE.POS;
        this.DISCOVERY_TITLE_SIZE = DisassemblerSettings.DISCOVERY_WINDOW.TITLE.SIZE;
        this.DISCOVERY_ITEM_POS_LIST = DisassemblerSettings.discoveryPosList;
        this.INFO_WINDOW_POS = DisassemblerSettings.INFO_WINDOW.POS;
        this.INFO_WINDOW_SIZE = DisassemblerSettings.INFO_WINDOW.SIZE;
        this.INFO_NAME_POS = DisassemblerSettings.INFO_WINDOW.NAME.POS;
        this.INFO_NAME_SIZE = DisassemblerSettings.INFO_WINDOW.NAME.SIZE;
        this.INFO_ICON_POS = DisassemblerSettings.INFO_WINDOW.ICON.POS;
        this.INFO_NAME_COLOR = DisassemblerSettings.INFO_WINDOW.NAME.COLOR;
        this.PARTICLE_POS_LIST = DisassemblerSettings.particlesPosList;
        this.MSG_ONE_POS = new Point(this.INFO_ICON_POS.x, this.INFO_ICON_POS.y + 25);
        this.MSG_TWO_POS = new Point(this.MSG_ONE_POS.x, this.MSG_ONE_POS.y + 11);
        this.MSG_THREE_POS = new Point(this.MSG_TWO_POS.x, this.MSG_TWO_POS.y + 11);
        this.MSG_ONE = "Left Click: Disassemble 1 item.";
        this.MSG_TWO = "Right Click: Disassemble whole stack.";
        this.MSG_THREE = "Scroll Click: Disassemble all stacks.";
        this.windowFillColor = Color.pink;
        this.windowBorderColor = Color.white;
        this.buttonFill = Color.pink;
        this.buttonBorder = Color.white;
        this.buttonBorderActive = Color.red;
        this.iconGap = new Point(2, 2);
        this.amountGap = new Point(3, 19);
        this.player = Qdc.curPlayer;
    }

    protected void init() {
        super.init();
        this.getLastDiscoveredItems();
        this.fillInventory();
    }

    private void getLastDiscoveredItems() {
        this.lastDiscoveredItems = Qdc.DisassemblerVariables.getDiscoveredItems();
    }

    private void fillInventory() {
        for (int i = 0; i < 36; ++i) {
            DisassemblerInventoryItem item = DisassemblerSettings.inventoryItemList.get(i);
            item.setStack(this.player.getInventory().getItem(item.actualIndex));
        }
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.windowPos.x = this.width / 2 - this.windowSize.x / 2;
        this.windowPos.y = this.height / 2 - this.windowSize.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.drawInfoWindow(GuiGraphics2);
        this.drawDiscoveryWindow(GuiGraphics2);
        this.checkItemHover(x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Item Dssassembler");
    }

    public void drawDiscoveryWindow(GuiGraphics GuiGraphics2) {
        this.drawRectangleWithBorder(GuiGraphics2, this.DISCOVERY_WINDOW_POS, this.DISCOVERY_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(GuiGraphics2, this.DISCOVERY_WINDOW_POS, this.DISCOVERY_TITLE_SIZE, Color.orange, this.windowBorderColor);
        this.writeString(GuiGraphics2, "Last Discovered Items", this.DISCOVERY_TITLE_POS.x, this.DISCOVERY_TITLE_POS.y, this.INFO_NAME_COLOR);
        if (this.lastDiscoveredItems != null && this.lastDiscoveredItems.size() > 0) {
            int start = 0;
            int counter = 0;
            if (Qdc.DisassemblerVariables.discoveredItems.size() > 16) {
                start = Qdc.DisassemblerVariables.discoveredItems.size() - 16;
            }
            for (int i = start; i < Qdc.DisassemblerVariables.discoveredItems.size(); ++i) {
                Item item = Qdc.DisassemblerVariables.discoveredItems.get(i);
                this.drawItemIcon(GuiGraphics2, item, this.DISCOVERY_ITEM_POS_LIST.get((int)counter).x, this.DISCOVERY_ITEM_POS_LIST.get((int)counter).y);
                ++counter;
            }
        }
    }

    public void drawInfoWindow(GuiGraphics GuiGraphics2) {
        this.drawRectangleWithBorder(GuiGraphics2, this.INFO_WINDOW_POS, this.INFO_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(GuiGraphics2, this.INFO_WINDOW_POS, this.INFO_NAME_SIZE, this.windowFillColor, this.windowBorderColor);
        if (this.curItem != null) {
            if (this.curItem.canBeDisassembled) {
                boolean showMana = MainBox.ITEM_BOX.shouldKeepMana(this.curItem.stack.getItem());
                this.writeString(GuiGraphics2, GlobalFuncs.getItemName(this.curItem.stack.getItem()), this.INFO_NAME_POS.x, this.INFO_NAME_POS.y, this.INFO_NAME_COLOR);
                this.drawItemIcon(GuiGraphics2, this.curItem.stack.getItem(), this.INFO_ICON_POS.x, this.INFO_ICON_POS.y);
                for (int i = 0; i < this.curItem.particles.particleList.size(); ++i) {
                    Point curPos = this.PARTICLE_POS_LIST.get(i);
                    ENUMS.ParticleType curType = this.curItem.particles.particleList.get((int)i).type;
                    Point amountPos = new Point(curPos.x + 20, curPos.y + 3);
                    String curParticleAmount = this.curItem.particles.particleList.get((int)i).stringVal;
                    if (curType == ENUMS.ParticleType.MANA) {
                        if (!showMana) continue;
                        this.drawItemIcon(GuiGraphics2, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(curType), curPos.x, curPos.y);
                        this.writeString(GuiGraphics2, curParticleAmount, amountPos.x, amountPos.y, QdcApi.QDC_CORE.FUNCTIONS.getParticleTextColor(curType));
                        continue;
                    }
                    this.drawItemIcon(GuiGraphics2, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(curType), curPos.x, curPos.y);
                    this.writeString(GuiGraphics2, curParticleAmount, amountPos.x, amountPos.y, QdcApi.QDC_CORE.FUNCTIONS.getParticleTextColor(curType));
                }
            }
        } else {
            this.writeString(GuiGraphics2, "Left Click: Disassemble 1 item.", this.MSG_ONE_POS.x, this.MSG_ONE_POS.y, this.INFO_NAME_COLOR);
            this.writeString(GuiGraphics2, "Right Click: Disassemble whole stack.", this.MSG_TWO_POS.x, this.MSG_TWO_POS.y, this.INFO_NAME_COLOR);
            this.writeString(GuiGraphics2, "Scroll Click: Disassemble all stacks.", this.MSG_THREE_POS.x, this.MSG_THREE_POS.y, this.INFO_NAME_COLOR);
        }
    }

    private void checkItemHover(int x, int y) {
        this.curItem = null;
        for (int i = 0; i < 36; ++i) {
            DisassemblerInventoryItem item = DisassemblerSettings.inventoryItemList.get(i);
            item.checkIfHoveringOver(this.windowPos, x, y);
            if (!item.isHoveringOver || !item.canBeDisassembled) continue;
            this.curItem = item;
        }
    }

    public void drawMainWindow(GuiGraphics gg) {
        Color borderColor = null;
        Color fillColor = null;
        Color textColor = null;
        for (DisassemblerInventoryItem item : DisassemblerSettings.inventoryItemList) {
            if (item.canBeDisassembled) {
                fillColor = Color.white;
                textColor = Color.black;
            } else if (item.stack.isEmpty()) {
                fillColor = Color.white;
                textColor = Color.white;
            } else {
                fillColor = Color.red;
                textColor = Color.white;
            }
            borderColor = item.isHoveringOver ? (item.canBeDisassembled ? Color.green : Color.red) : (item.canBeDisassembled ? Color.orange : Color.red);
            this.drawRectangleWithBorder(gg, item.pos, item.size, fillColor, borderColor);
            this.drawItemIcon(gg, item.stack.getItem(), item.pos.x + this.iconGap.x, item.pos.y + this.iconGap.y);
            this.writeString(gg, "" + item.stack.getCount(), item.pos.x + this.amountGap.x, item.pos.y + this.amountGap.y, textColor);
        }
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.windowPos, pos, size, isActive);
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.windowPos, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.windowPos, item, x, y);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.windowPos, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.windowPos, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.windowPos, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.windowPos, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curItem != null) {
            if (button == 0) {
                DisassemblerFunctions.disassembleSingleItem(this.curItem);
            } else if (button == 1) {
                DisassemblerFunctions.disassembleStack(this.curItem);
            } else if (button == 2) {
                DisassemblerFunctions.disassembleAllStacks(this.curItem, DisassemblerSettings.inventoryItemList);
            }
            this.fillInventory();
            this.playClickSound();
            return true;
        }
        return false;
    }

    private void playClickSound() {
        GuiSoundFunctions.playClickSound(this.player);
    }

    public static final class btnType
    extends Enum<btnType> {
        private static final /* synthetic */ btnType[] $VALUES;

        public static btnType[] values() {
            return (btnType[])$VALUES.clone();
        }

        public static btnType valueOf(String name) {
            return Enum.valueOf(btnType.class, name);
        }

        private static /* synthetic */ btnType[] $values() {
            return new btnType[0];
        }

        static {
            $VALUES = btnType.$values();
        }
    }
}

