/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.functions.GuiSoundFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.AssemblerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.ConverterMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.DisassemblerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.MainItemMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.ModAssemblerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.RecyclerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.ResearchMissionBaseMenu;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.RevelationMenu;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ParticleFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.TimeFunctions;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.menu.ElevatorMenu;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class MainMenuScreen
extends AbstractContainerScreen<MainItemMenu> {
    private final Item natureIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.NATURE;
    private final Item foodIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.FOOD;
    private final Item metalIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.METAL;
    private final Item gemIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.GEM;
    private final Item corruptionIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.CORRUPTION;
    private final Item manaIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.MANA;
    private final Point particlesWindowPos = new Point(-90, -65);
    private final Point particleBoxSize = new Point(150, 35);
    private final Point buttonsWindowSize = new Point(170, 165);
    private final Point buttonsWindowPos = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private final int buttonXPosition = 100;
    private final Point missionLogPos = new Point(100, 5);
    private final Point assemblerPos = new Point(100, 25);
    private final Point qdcAssemblerPos = new Point(100, 45);
    private final Point disassemblerPos = new Point(100, 65);
    private final Point converterPos = new Point(100, 85);
    private final Point revelationPos = new Point(100, 105);
    private final Point recyclerPos = new Point(100, 125);
    private final Point elevatorPos = new Point(100, 145);
    private final Point buttonSize = new Point(150, 15);
    private final int particleXGap = 10;
    private final int particleYGap = 2;
    private final Point naturePos;
    private final Point foodPos;
    private final Point metalPos;
    private final Point gemPos;
    private final Point corruptionPos;
    private final Point manaPos;
    private final Point iconGap;
    private final Point particleTitleGap;
    private final Point particleAmountGap;
    private final Color windowFillColor;
    private final Color windowBorderColor;
    private final Color buttonFill;
    private final Color buttonBorder;
    private final Color buttonBorderActive;
    private final Point mainWindowPos;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, this.missionLogPos, this.buttonSize, "Research Mission Log", btnType.RESEARCH_MISSION_LOG));
        res.add(new GuiButton(this, this.assemblerPos, this.buttonSize, "Item Assembler", btnType.ASSEMBLER));
        res.add(new GuiButton(this, this.qdcAssemblerPos, this.buttonSize, "QDC Item Assembler", btnType.QDC_ASSEMBLER));
        res.add(new GuiButton(this, this.disassemblerPos, this.buttonSize, "Item Disassembler", btnType.DISASSEMBLER));
        res.add(new GuiButton(this, this.converterPos, this.buttonSize, "Particle Converter", btnType.CONVERTER));
        res.add(new GuiButton(this, this.revelationPos, this.buttonSize, "Quantum Revelation [" + TimeFunctions.generateTimeLeftString() + "]", btnType.QUANTUM_REVELATION));
        res.add(new GuiButton(this, this.recyclerPos, this.buttonSize, "Corruption Recycler", btnType.RECYCLER));
        res.add(new GuiButton(this, this.elevatorPos, this.buttonSize, "Quantum Elevator", btnType.QDC_ELEVATOR));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.buttonsWindowPos, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public MainMenuScreen(MainItemMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.naturePos = new Point(this.particlesWindowPos.x + 10, this.particlesWindowPos.y + this.particleBoxSize.y + 2);
        this.foodPos = new Point(this.particlesWindowPos.x + 10, this.naturePos.y + this.particleBoxSize.y + 2);
        this.metalPos = new Point(this.particlesWindowPos.x + 10, this.foodPos.y + this.particleBoxSize.y + 2);
        this.gemPos = new Point(this.particlesWindowPos.x + 10, this.metalPos.y + this.particleBoxSize.y + 2);
        this.corruptionPos = new Point(this.particlesWindowPos.x + 10, this.gemPos.y + this.particleBoxSize.y + 2);
        this.manaPos = new Point(this.particlesWindowPos.x + 10, this.corruptionPos.y + this.particleBoxSize.y + 2);
        this.iconGap = new Point(5, 5);
        this.particleTitleGap = new Point(25, 3);
        this.particleAmountGap = new Point(25, 13);
        this.windowFillColor = Color.pink;
        this.windowBorderColor = Color.white;
        this.buttonFill = Color.pink;
        this.buttonBorder = Color.white;
        this.buttonBorderActive = Color.red;
        this.mainWindowPos = new Point(90, 0);
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.buttonsWindowPos.x = this.width / 2 - this.buttonsWindowSize.x / 2;
        this.buttonsWindowPos.y = this.height / 2 - this.buttonsWindowSize.y / 2;
        this.drawParticlesWindow(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
    }

    public void drawParticlesWindow(GuiGraphics gg) {
        this.drawParticleWindow(gg, this.naturePos, "Nature Particles", ENUMS.ParticleType.NATURE, ParticleFunctions.natureColor, this.natureIcon);
        this.drawParticleWindow(gg, this.foodPos, "Food Particles", ENUMS.ParticleType.FOOD, ParticleFunctions.foodColor, this.foodIcon);
        this.drawParticleWindow(gg, this.metalPos, "Metal Particles", ENUMS.ParticleType.METAL, ParticleFunctions.metalColor, this.metalIcon);
        this.drawParticleWindow(gg, this.gemPos, "Gem Particles", ENUMS.ParticleType.GEM, ParticleFunctions.gemColor, this.gemIcon);
        this.drawParticleWindow(gg, this.corruptionPos, "Corruption Particles", ENUMS.ParticleType.CORRUPTION, ParticleFunctions.corruptionColor, this.corruptionIcon);
        this.drawManaParticleWindow(gg, this.manaPos, "Mana Particles", ENUMS.ParticleType.MANA, ParticleFunctions.manaColor, this.manaIcon);
    }

    private void drawParticleWindow(GuiGraphics gg, Point windowPos, String title, ENUMS.ParticleType type, Color color, Item icon) {
        this.drawRectangleWithBorder(gg, windowPos, this.particleBoxSize, this.windowFillColor, this.windowBorderColor);
        this.drawItemIcon(gg, icon, windowPos.x + this.iconGap.x, windowPos.y + this.iconGap.y);
        this.writeString(gg, title, windowPos.x + this.particleTitleGap.x, windowPos.y + this.particleTitleGap.y, color);
        this.writeString(gg, "Have: " + QdcApi.QDC_CORE.FUNCTIONS.getParticleAmountShort(type), windowPos.x + this.particleAmountGap.x, windowPos.y + this.particleAmountGap.y, ParticleFunctions.amountColor);
        this.writeString(gg, "Regen: " + QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.getRegenFOrParticleType(type), windowPos.x + this.particleAmountGap.x, windowPos.y + this.particleAmountGap.y + this.particleAmountGap.y - 3, ParticleFunctions.amountColor);
    }

    private void drawManaParticleWindow(GuiGraphics gg, Point windowPos, String title, ENUMS.ParticleType type, Color color, Item icon) {
        this.drawRectangleWithBorder(gg, windowPos, this.particleBoxSize, this.windowFillColor, this.windowBorderColor);
        this.drawItemIcon(gg, icon, windowPos.x + this.iconGap.x, windowPos.y + this.iconGap.y);
        this.writeString(gg, title, windowPos.x + this.particleTitleGap.x, windowPos.y + this.particleTitleGap.y, color);
        this.writeString(gg, "Have: " + QdcApi.QDC_CORE.FUNCTIONS.getParticleAmount(type) + "/" + QdcApi.QDC_CORE.FUNCTIONS.getParticleAmount(ENUMS.ParticleType.MANA_MAX), windowPos.x + this.particleAmountGap.x, windowPos.y + this.particleAmountGap.y, ParticleFunctions.amountColor);
        this.writeString(gg, "Regen: " + QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.getRegenFOrParticleType(type), windowPos.x + this.particleAmountGap.x, windowPos.y + this.particleAmountGap.y + this.particleAmountGap.y - 3, ParticleFunctions.amountColor);
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.mainWindowPos, this.buttonsWindowSize, this.buttonFill, this.buttonBorder);
        for (GuiButton button : this.buttonList) {
            if (button.type != btnType.QUANTUM_REVELATION) {
                if (this.curHoverItem == button.type) {
                    this.drawButton(gg, button.pos, button.size, true);
                    this.writeStringCentred(gg, button.text, button.pos.x + 75, button.pos.y + 2, this.buttonBorderActive);
                    continue;
                }
                this.drawButton(gg, button.pos, button.size, false);
                this.writeStringCentred(gg, button.text, button.pos.x + 75, button.pos.y + 2, this.buttonBorder);
                continue;
            }
            button.text = "Quantum Revelation [" + TimeFunctions.generateTimeLeftString() + "]";
            if (this.curHoverItem == btnType.QUANTUM_REVELATION) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + 75, button.pos.y + 2, this.buttonBorderActive);
                continue;
            }
            if (Qdc.RevelationStuff.isRevelationReady) {
                this.drawButton(gg, button.pos, button.size, false);
                this.writeStringCentred(gg, button.text, button.pos.x + 75, button.pos.y + 2, Color.green);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + 75, button.pos.y + 2, Color.white);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.buttonsWindowPos, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.buttonsWindowPos, item, x, y);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.buttonsWindowPos, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.buttonsWindowPos, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.buttonsWindowPos, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.buttonsWindowPos, text, x, y, color);
    }

    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 2: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new DisassemblerMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Item Disassembler");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 1: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new AssemblerMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Item Assembler");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 6: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new ModAssemblerMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Mod Item Assembler");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 3: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new ConverterMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Particle Converter");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 0: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new ResearchMissionBaseMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Research Mission Base");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 4: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new RecyclerMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Corruption Recycler");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 5: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new RevelationMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Quantum Revelation");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                    break;
                }
                case 7: {
                    MenuProvider containerProvider = new MenuProvider(this){

                        public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
                            return new ElevatorMenu(windowID);
                        }

                        public Component getDisplayName() {
                            return Component.literal((String)"Quantum Elevator");
                        }
                    };
                    if (Qdc.serverPlayer == null) break;
                    QdcElevatorBox.notifyRangeCheck(Qdc.curPlayer.blockPosition());
                    QdcElevatorBox.getElevatorsInRange();
                    QdcElevatorBox.print();
                    this.playClickSound();
                    Qdc.serverPlayer.openMenu(containerProvider);
                }
            }
        }
        return false;
    }

    private void playClickSound() {
        GuiSoundFunctions.playClickSound(this.player);
    }

    private void playErrorSound() {
        GuiSoundFunctions.playClickSound(this.player);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;

        public GuiButton(MainMenuScreen this$0, Point pos, Point size, String text, btnType type) {
            super(pos, size, text);
            this.type = type;
        }
    }

    public static enum btnType {
        RESEARCH_MISSION_LOG,
        ASSEMBLER,
        DISASSEMBLER,
        CONVERTER,
        RECYCLER,
        QUANTUM_REVELATION,
        QDC_ASSEMBLER,
        QDC_ELEVATOR;

    }
}

