/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions;

import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockLocationObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class QuarryWorkAreaFunctions {
    public static List<BlockPos> getQuarryWorkArea(BlockPos quarryPos, Direction quarryDirection, int width, int height, int depth) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos startPos = QuarryWorkAreaFunctions.findStartQuarryBlock(quarryDirection, quarryPos);
        BlockPos cornerPos = QuarryWorkAreaFunctions.getCornerBlock(startPos, quarryDirection, width, height);
        switch (quarryDirection) {
            case NORTH: {
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            result.add(new BlockPos(cornerPos.getX() - x, cornerPos.getY() + y, cornerPos.getZ() + z));
                        }
                    }
                }
                break;
            }
            case SOUTH: {
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            result.add(new BlockPos(cornerPos.getX() + x, cornerPos.getY() + y, cornerPos.getZ() - z));
                        }
                    }
                }
                break;
            }
            case EAST: {
                for (int x = 0; x < depth; ++x) {
                    for (int y = 0; y < height; ++y) {
                        for (int z = 0; z < width; ++z) {
                            result.add(new BlockPos(cornerPos.getX() - x, cornerPos.getY() + y, cornerPos.getZ() - z));
                        }
                    }
                }
                break;
            }
            case WEST: {
                for (int x = 0; x < depth; ++x) {
                    for (int y = 0; y < height; ++y) {
                        for (int z = 0; z < width; ++z) {
                            result.add(new BlockPos(cornerPos.getX() + x, cornerPos.getY() + y, cornerPos.getZ() + z));
                        }
                    }
                }
                break;
            }
            case UP: {
                for (int y = 0; y < depth; ++y) {
                    for (int z = 0; z < height; ++z) {
                        for (int x = 0; x < width; ++x) {
                            result.add(new BlockPos(cornerPos.getX() - x, cornerPos.getY() - y, cornerPos.getZ() + z));
                        }
                    }
                }
                break;
            }
            case DOWN: {
                for (int y = 0; y < depth; ++y) {
                    for (int z = 0; z < height; ++z) {
                        for (int x = 0; x < width; ++x) {
                            result.add(new BlockPos(cornerPos.getX() - x, cornerPos.getY() + y, cornerPos.getZ() - z));
                        }
                    }
                }
                break;
            }
        }
        return result;
    }

    private static BlockPos getCornerBlock(BlockPos start, Direction quarryDirection, int maxWidth, int maxHeight) {
        int width = (maxWidth - 1) / 2;
        int height = (maxHeight - 1) / 2;
        switch (quarryDirection) {
            case NORTH: {
                return new BlockPos(start.getX() + width, start.getY() - height, start.getZ());
            }
            case SOUTH: {
                return new BlockPos(start.getX() - width, start.getY() - height, start.getZ());
            }
            case EAST: {
                return new BlockPos(start.getX(), start.getY() - height, start.getZ() + width);
            }
            case WEST: {
                return new BlockPos(start.getX(), start.getY() - height, start.getZ() - width);
            }
            case UP: {
                return new BlockPos(start.getX() + width, start.getY(), start.getZ() - height);
            }
            case DOWN: {
                return new BlockPos(start.getX() + width, start.getY(), start.getZ() + height);
            }
        }
        return null;
    }

    public static BlockPos findStartQuarryBlock(Direction dir, BlockPos curPos) {
        BlockLocationObject locObj = new BlockLocationObject(curPos);
        if (dir == Direction.NORTH) {
            locObj.moveSouth();
            return locObj.curPos;
        }
        if (dir == Direction.SOUTH) {
            locObj.moveNorth();
            return locObj.curPos;
        }
        if (dir == Direction.WEST) {
            locObj.moveEast();
            return locObj.curPos;
        }
        if (dir == Direction.EAST) {
            locObj.moveWest();
            return locObj.curPos;
        }
        if (dir == Direction.DOWN) {
            locObj.moveUp();
            return locObj.curPos;
        }
        if (dir == Direction.UP) {
            locObj.moveDown();
            return locObj.curPos;
        }
        return null;
    }
}

