/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.DiscoveryBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemModWindowSetup;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.MobEggRegistration;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.ModWindowBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.ModWindowsInit;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.ParticleBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.ppm_box.PPM_Box;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.ResearchMissionBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.ResearchMission;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.functions.ResearchMissionRegistry;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.revelation_box.RevelationBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.WindowBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.WindowsInit;
import java.math.BigDecimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class MainBox {
    public static ParticleBox PARTICLE_BOX = new ParticleBox();
    public static ItemBox ITEM_BOX = new ItemBox();
    public static WindowBox WINDOW_BOX = new WindowBox();
    public static ModWindowBox MOD_WINDOW_BOX = new ModWindowBox();
    public static DiscoveryBox DISCOVERY_BOX = new DiscoveryBox();
    public static ResearchMissionBox RESEARCH_MISSION_BOX = new ResearchMissionBox();
    public static RevelationBox REVELATION_BOX = new RevelationBox();
    public static PPM_Box PPM_BOX = new PPM_Box();
    private static boolean isItemDataGenerated = false;

    public static void addRegenParticles() {
        PARTICLE_BOX.addRegenParticles(MainBox.PPM_BOX.NATURE.amount, MainBox.PPM_BOX.FOOD.amount, MainBox.PPM_BOX.METAL.amount, MainBox.PPM_BOX.GEM.amount, MainBox.PPM_BOX.CORRUPTION.amount, MainBox.PPM_BOX.MANA.amount);
    }

    public static void increment_PPM_BOX(ENUMS.ParticleType type, BigDecimal toAdd) {
        PPM_BOX.increment(type, toAdd);
    }

    public static void decrement_PPM_BOX(ENUMS.ParticleType type, BigDecimal toAdd) {
        PPM_BOX.decrement(type, toAdd);
    }

    public static String getRegenForParticleType(ENUMS.ParticleType type) {
        return PPM_BOX.getRegenForParticleType(type);
    }

    public static void clearModData() {
        PARTICLE_BOX.clear();
        DISCOVERY_BOX.clear();
        RESEARCH_MISSION_BOX.clear();
        PPM_BOX.clear();
        Qdc.DisassemblerVariables.discoveredItems.clear();
    }

    public static void setItemDiscovered(DiscoveryItem item, boolean showMsg) {
        DISCOVERY_BOX.addDiscoveredItem(item);
        ITEM_BOX.setDiscovered(item.item, showMsg);
        RESEARCH_MISSION_BOX.updateDiscoveredMissionItem(item.item);
    }

    public static boolean isItemDiscovered(Item item) {
        return DISCOVERY_BOX.isItemDiscovered(item);
    }

    public static void registerNewMission(ResearchMission newResearchMission) {
        RESEARCH_MISSION_BOX.addNewMission(newResearchMission);
    }

    public static void loadModData(Player player) {
        MainBox.clearModData();
        PARTICLE_BOX.loadPlayerParticles(player);
        DISCOVERY_BOX.loadData(player);
        RESEARCH_MISSION_BOX.loadData(player);
        ITEM_BOX.loadData(player);
        if (!isItemDataGenerated) {
            WindowsInit.initWindowList();
            ModWindowsInit.initModWindowList();
            MobEggRegistration.initMobEggData();
            ItemModWindowSetup.initModItemList(Qdc.curPlayer.level());
            ResearchMissionRegistry.registerMissions();
            ITEM_BOX.sortItemCollections();
            isItemDataGenerated = true;
        }
        WINDOW_BOX.calcWindowDiscoveries();
        ITEM_BOX.setItemList();
        PPM_BOX.loadPlayerParticles(player);
    }

    public static void saveData(Player player) {
        PARTICLE_BOX.saveData(player);
        DISCOVERY_BOX.saveData(player);
        RESEARCH_MISSION_BOX.saveData(player);
        ITEM_BOX.saveData(player);
        PPM_BOX.saveData(player);
    }
}

