/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ParticleFunctions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModItem {
    public String name;
    public Item item;
    public ParticleCollection particles;
    public String window;
    public boolean discovered;
    public boolean allowDisassemble;
    public String searchName = "";
    public int corruptionAmount = 0;
    public boolean canBeDiscovered = true;

    public ModItem(Item item, ParticleCollection particles) {
        this.name = ((Item)item.builtInRegistryHolder().value()).toString();
        this.allowDisassemble = true;
        this.item = item;
        this.particles = particles;
        this.discovered = false;
        this.searchName = this.getItemSearchString(item);
    }

    public ModItem(Item item, ParticleCollection particles, boolean allowDisassemble) {
        this.name = ((Item)item.builtInRegistryHolder().value()).toString();
        this.allowDisassemble = allowDisassemble;
        this.item = item;
        this.particles = particles;
        this.discovered = false;
        this.searchName = this.getItemSearchString(item);
    }

    public ModItem(Item item, ParticleCollection particles, String window, boolean allowDisassemble) {
        this.name = ((Item)item.builtInRegistryHolder().value()).toString();
        this.allowDisassemble = allowDisassemble;
        this.item = item;
        this.particles = particles;
        this.window = window;
        this.discovered = false;
        this.searchName = this.getItemSearchString(item);
    }

    public ModItem(Item item, ParticleCollection particles, String window) {
        this.name = ((Item)item.builtInRegistryHolder().value()).toString();
        this.allowDisassemble = true;
        this.item = item;
        this.particles = particles;
        this.window = window;
        this.discovered = false;
        this.searchName = this.getItemSearchString(item);
    }

    public void calcCorruptionAmount() {
        this.corruptionAmount = ParticleFunctions.calcCorruptionParticlesForItem(this.particles);
    }

    public boolean hasSearchString(String searchStr) {
        return this.searchName.toLowerCase().contains(searchStr.toLowerCase());
    }

    public void setToDiscovered() {
        this.discovered = true;
    }

    private String getItemSearchString(Item i) {
        String res = new ItemStack((ItemLike)i).getDisplayName().getString().toLowerCase();
        return res;
    }
}

