/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.ppm_box;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.ppm_box.classes.PPM_BoxItem;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.AttachmentInit;
import java.math.BigDecimal;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;

public class PPM_Box {
    public PPM_BoxItem NATURE = new PPM_BoxItem(ENUMS.ParticleType.NATURE);
    public PPM_BoxItem FOOD = new PPM_BoxItem(ENUMS.ParticleType.FOOD);
    public PPM_BoxItem METAL = new PPM_BoxItem(ENUMS.ParticleType.METAL);
    public PPM_BoxItem GEM = new PPM_BoxItem(ENUMS.ParticleType.GEM);
    public PPM_BoxItem CORRUPTION = new PPM_BoxItem(ENUMS.ParticleType.CORRUPTION);
    public PPM_BoxItem MANA = new PPM_BoxItem(ENUMS.ParticleType.MANA);
    public PPM_BoxItem[] boxItemArray = new PPM_BoxItem[]{this.NATURE, this.FOOD, this.METAL, this.GEM, this.CORRUPTION, this.MANA};

    public String getRegenForParticleType(ENUMS.ParticleType type) {
        return this.getItemByType((ENUMS.ParticleType)type).stringVal;
    }

    public void increment(ENUMS.ParticleType type, BigDecimal toAdd) {
        this.getItemByType(type).increment(toAdd);
        this.saveData(Qdc.curPlayer);
    }

    public void decrement(ENUMS.ParticleType type, BigDecimal toRemove) {
        this.getItemByType(type).decrement(toRemove);
        this.saveData(Qdc.curPlayer);
    }

    private PPM_BoxItem getItemByType(ENUMS.ParticleType type) {
        for (PPM_BoxItem item : this.boxItemArray) {
            if (item.type != type) continue;
            return item;
        }
        return null;
    }

    public void clear() {
        this.NATURE.amount = new BigDecimal("0");
        this.NATURE.stringVal = "0";
        this.FOOD.amount = new BigDecimal("0");
        this.FOOD.stringVal = "0";
        this.METAL.amount = new BigDecimal("0");
        this.METAL.stringVal = "0";
        this.GEM.amount = new BigDecimal("0");
        this.GEM.stringVal = "0";
        this.CORRUPTION.amount = new BigDecimal("0");
        this.CORRUPTION.stringVal = "0";
        this.MANA.amount = new BigDecimal("0");
        this.MANA.stringVal = "0";
    }

    public void loadPlayerParticles(Player player) {
        String natureString = this.getPlayerParticle(player, AttachmentInit.NATURE_PATICLES_REGEN);
        String foodString = this.getPlayerParticle(player, AttachmentInit.FOOD_PATICLES_REGEN);
        String metalString = this.getPlayerParticle(player, AttachmentInit.METAL_PATICLES_REGEN);
        String gemString = this.getPlayerParticle(player, AttachmentInit.GEM_PATICLES_REGEN);
        String corruptionString = this.getPlayerParticle(player, AttachmentInit.CORRUPTION_PATICLES_REGEN);
        String manaString = this.getPlayerParticle(player, AttachmentInit.MANA_PATICLES_REGEN);
        this.setData(ENUMS.ParticleType.NATURE, natureString);
        this.setData(ENUMS.ParticleType.FOOD, foodString);
        this.setData(ENUMS.ParticleType.METAL, metalString);
        this.setData(ENUMS.ParticleType.GEM, gemString);
        this.setData(ENUMS.ParticleType.CORRUPTION, corruptionString);
        this.setData(ENUMS.ParticleType.MANA, manaString);
    }

    private String getPlayerParticle(Player player, Supplier<AttachmentType<String>> attachment) {
        if (player.hasData(attachment)) {
            String particlesString = (String)player.getData(attachment);
            return particlesString;
        }
        player.setData(attachment, (Object)"0");
        return "0";
    }

    public void setData(ENUMS.ParticleType type, String str) {
        switch (type) {
            case NATURE: {
                this.NATURE.amount = new BigDecimal(str);
                this.NATURE.fixString();
                break;
            }
            case FOOD: {
                this.FOOD.amount = new BigDecimal(str);
                this.FOOD.fixString();
                break;
            }
            case METAL: {
                this.METAL.amount = new BigDecimal(str);
                this.METAL.fixString();
                break;
            }
            case GEM: {
                this.GEM.amount = new BigDecimal(str);
                this.GEM.fixString();
                break;
            }
            case CORRUPTION: {
                this.CORRUPTION.amount = new BigDecimal(str);
                this.CORRUPTION.fixString();
                break;
            }
            case MANA: {
                this.MANA.amount = new BigDecimal(str);
                this.MANA.fixString();
                break;
            }
        }
    }

    public void saveData(Player player) {
        if (this.NATURE.amount != null) {
            player.setData(AttachmentInit.NATURE_PATICLES_REGEN, (Object)this.NATURE.amount.toString());
        }
        if (this.FOOD.amount != null) {
            player.setData(AttachmentInit.FOOD_PATICLES_REGEN, (Object)this.FOOD.amount.toString());
        }
        if (this.METAL.amount != null) {
            player.setData(AttachmentInit.METAL_PATICLES_REGEN, (Object)this.METAL.amount.toString());
        }
        if (this.GEM.amount != null) {
            player.setData(AttachmentInit.GEM_PATICLES_REGEN, (Object)this.GEM.amount.toString());
        }
        if (this.CORRUPTION.amount != null) {
            player.setData(AttachmentInit.CORRUPTION_PATICLES_REGEN, (Object)this.CORRUPTION.amount.toString());
        }
        if (this.MANA.amount != null) {
            player.setData(AttachmentInit.MANA_PATICLES_REGEN, (Object)this.MANA.amount.toString());
        }
    }
}

