/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_repairer
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData machineData = new MachineData("Repairer MK2");
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public ParticleCollection fuelParticles = null;
    private ParticleCollection eggParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public ArrayList<BlockPos> workArea = null;
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public boolean hasFuel = false;
    public boolean powered = true;
    public boolean isEggInStorage = true;
    private boolean isSpeedSet = false;
    private int curDamage = -1;
    private int maxDamage = -1;

    public tile_entity_repairer(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_REPAIRER.get(), pos, state);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getItemStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setSpeed();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index != 0) {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    public boolean hasAnItem() {
        return !this.itemHandler.getStackInSlot(2).isEmpty();
    }

    public boolean updateItem(ItemStack item) {
        this.itemHandler.setStackInSlot(2, item.copy());
        this.setChanged();
        if (!item.isEmpty()) {
            GlobalFuncs.showInGameMessage("--------------------------");
            GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
            GlobalFuncs.showInGameMessage("Item set to: " + BERFunctions.getItemName(this.getItemStack()));
        } else {
            this.curDamage = -1;
            this.maxDamage = -1;
        }
        return true;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_repairer.this.setChanged();
                if (slot == 1) {
                    tile_entity_repairer.this.setSpeed();
                }
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (!this.getItemStack().isEmpty()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getItemStack());
                if (!this.powered) {
                    this.machineData._toolTip = "No redstone signal!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasFuel) {
                    this.machineData._toolTip = "No Fuel Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (this.isWorking) {
                    this.machineData._toolTip = "Repairing... [" + (this.maxDamage - this.curDamage) + "/" + this.maxDamage + "]";
                    this.machineData._toolTipColor = Color.green;
                }
            } else {
                this.machineData._toolTip = "No Item to repair!!!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            this.hasFuel = this.checkIfHasFuel();
            if (!this.getItemStack().isEmpty()) {
                this.powered = false;
                this.isWorking = false;
                this.curDamage = this.getItemStack().getDamageValue();
                this.maxDamage = this.getItemStack().getMaxDamage();
                if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                    this.powered = true;
                    if (this.curDamage > 0) {
                        this.isWorking = true;
                        ++this.curTick;
                        if (this.curTick >= this.nextTarget) {
                            this.curTick = 0;
                            if (this.hasFuel) {
                                this.removeFuelParticles();
                                --this.curDamage;
                                this.getItemStack().setDamageValue(this.curDamage);
                            }
                        }
                    }
                }
            }
            this.sendToClient();
        }
    }

    private void removeFuelParticles() {
        QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.fuelParticles);
    }

    private void calcPerc(int cur, int max) {
        float f_cur = cur;
        float f_max = max;
        this.tickPerc = (int)(f_cur / f_max * 100.0f);
        if (this.tickPerc < 0) {
            this.tickPerc = 0;
        }
        this.sendToClient();
    }

    private ParticleCollection getEggParticles() {
        return QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(Items.EGG);
    }

    private boolean checkIfHasFuel() {
        if (this.fuelParticles == null) {
            this.fuelParticles = new ParticleCollection();
            this.fuelParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, 1.0));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.fuelParticles);
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.REPAIRER.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.dropStuffs(pos);
        super.preRemoveSideEffects(pos, state);
    }

    protected void saveAdditional(ValueOutput output) {
        this.itemHandler.serialize(output);
        output.putInt("speed", this.speed);
        output.putInt("perc", this.tickPerc);
        this.machineData.save(output);
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        this.itemHandler.deserialize(input);
        this.speed = (Integer)input.getInt("speed").get();
        this.updateTickCountsBySpeed();
        this.tickPerc = (Integer)input.getInt("perc").get();
        this.machineData.load(input);
        super.loadAdditional(input);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

