/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_tool.functions;

import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import com.qdc_mod.qdc_core_4.qdc_tool.core.init.ItemInit;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class QuantumToolFunctions {
    public static String[] shovelList = new String[]{"dirt", "grass", "sand", "gravel"};
    public static String[] axelList = new String[]{"log", "wood", "oak", "spruce", "birch", "acacia", "jungle", "crimson", "warped", "chest"};

    public static boolean onMobRightClick(Level level, Player player) {
        if (!level.isClientSide) {
            ItemStack old = player.getItemInHand(InteractionHand.MAIN_HAND).copy();
            if (QuantumToolFunctions.getItemType(old) == itemType.SWORD) {
                return false;
            }
            itemType type = itemType.SWORD;
            itemTier tier = QuantumToolFunctions.getItemTier(old);
            if (tier == itemTier.NONE) {
                return false;
            }
            Item newItem = QuantumToolFunctions.getItemFromBlock(type, tier);
            ItemStack newStack = new ItemStack((ItemLike)newItem);
            if (newItem != null) {
                newStack.setDamageValue(old.getDamageValue());
                if (old.isEnchanted()) {
                    ItemEnchantments encList = old.getEnchantments();
                    for (Holder ent : encList.keySet()) {
                        newStack.enchant(ent, encList.getLevel(ent));
                    }
                }
                player.setItemInHand(InteractionHand.MAIN_HAND, newStack.copy());
                MachineSoundFunctions.playToolSwapSound(level, player.getOnPos());
                return true;
            }
        }
        return false;
    }

    public static boolean onItemRightClick(Level level, Player player, InteractionHand hand) {
        return QuantumToolFunctions.onItemRightClick(level, player, hand, false);
    }

    public static boolean onItemRightClick(Level level, Player player, InteractionHand hand, boolean isMob) {
        if (isMob) {
            return QuantumToolFunctions.onMobRightClick(level, player);
        }
        if (!level.isClientSide) {
            float f = player.getXRot();
            float f1 = player.getYRot();
            Vec3 vec3 = player.getEyePosition();
            float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
            float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
            float f6 = f3 * f4;
            float f7 = f2 * f4;
            double d0 = 10.0;
            Vec3 vec31 = vec3.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
            BlockHitResult res = level.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Block b = level.getBlockState(res.getBlockPos()).getBlock();
            ItemStack old = player.getItemInHand(InteractionHand.MAIN_HAND).copy();
            itemType type = QuantumToolFunctions.getItemType(b.getName().getString().toLowerCase());
            itemTier tier = QuantumToolFunctions.getItemTier(old);
            Item newItem = QuantumToolFunctions.getItemFromBlock(type, tier);
            ItemStack newStack = new ItemStack((ItemLike)newItem);
            if (newItem != null) {
                newStack.setDamageValue(old.getDamageValue());
                if (old.isEnchanted()) {
                    ItemEnchantments encList = old.getEnchantments();
                    for (Holder ent : encList.keySet()) {
                        newStack.enchant(ent, encList.getLevel(ent));
                    }
                }
                player.setItemInHand(InteractionHand.MAIN_HAND, newStack.copy());
                return true;
            }
        }
        return false;
    }

    public static itemType getItemType(String name) {
        if (name.toLowerCase().contains("sandstone")) {
            return itemType.PICKAXE;
        }
        for (String s : shovelList) {
            if (!name.contains(s)) continue;
            return itemType.SHOVEL;
        }
        for (String s : axelList) {
            if (!name.contains(s)) continue;
            return itemType.AXE;
        }
        return itemType.PICKAXE;
    }

    public static itemType getItemType(ItemStack is) {
        if (is.getItem() == ItemInit.QUANTUM_WOODEN_AXE.get() || is.getItem() == ItemInit.QUANTUM_STONE_AXE.get() || is.getItem() == ItemInit.QUANTUM_IRON_AXE.get() || is.getItem() == ItemInit.QUANTUM_GOLD_AXE.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_AXE.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_AXE.get()) {
            return itemType.AXE;
        }
        if (is.getItem() == ItemInit.QUANTUM_WOODEN_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_STONE_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_IRON_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_GOLD_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_SHOVEL.get()) {
            return itemType.SHOVEL;
        }
        if (is.getItem() == ItemInit.QUANTUM_WOODEN_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_STONE_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_IRON_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_GOLD_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_PICKAXE.get()) {
            return itemType.PICKAXE;
        }
        if (is.getItem() == ItemInit.QUANTUM_WOODEN_SWORD.get() || is.getItem() == ItemInit.QUANTUM_STONE_SWORD.get() || is.getItem() == ItemInit.QUANTUM_IRON_SWORD.get() || is.getItem() == ItemInit.QUANTUM_GOLD_SWORD.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_SWORD.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_SWORD.get()) {
            return itemType.SWORD;
        }
        return null;
    }

    public static itemTier getItemTier(ItemStack is) {
        if (is.getItem() == ItemInit.QUANTUM_WOODEN_AXE.get() || is.getItem() == ItemInit.QUANTUM_WOODEN_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_WOODEN_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_WOODEN_SWORD.get()) {
            return itemTier.WOODEN;
        }
        if (is.getItem() == ItemInit.QUANTUM_STONE_AXE.get() || is.getItem() == ItemInit.QUANTUM_STONE_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_STONE_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_STONE_SWORD.get()) {
            return itemTier.STONE;
        }
        if (is.getItem() == ItemInit.QUANTUM_IRON_AXE.get() || is.getItem() == ItemInit.QUANTUM_IRON_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_IRON_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_IRON_SWORD.get()) {
            return itemTier.IRON;
        }
        if (is.getItem() == ItemInit.QUANTUM_GOLD_AXE.get() || is.getItem() == ItemInit.QUANTUM_GOLD_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_GOLD_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_GOLD_SWORD.get()) {
            return itemTier.GOLD;
        }
        if (is.getItem() == ItemInit.QUANTUM_DIAMOND_AXE.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_DIAMOND_SWORD.get()) {
            return itemTier.DIAMOND;
        }
        if (is.getItem() == ItemInit.QUANTUM_NETHERITE_AXE.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_SHOVEL.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_PICKAXE.get() || is.getItem() == ItemInit.QUANTUM_NETHERITE_SWORD.get()) {
            return itemTier.NETHERITE;
        }
        return itemTier.NONE;
    }

    public static Item getItemFromBlock(itemType type, itemTier tier) {
        switch (type.ordinal()) {
            case 0: {
                if (tier == itemTier.WOODEN) {
                    return (Item)ItemInit.QUANTUM_WOODEN_AXE.get();
                }
                if (tier == itemTier.STONE) {
                    return (Item)ItemInit.QUANTUM_STONE_AXE.get();
                }
                if (tier == itemTier.IRON) {
                    return (Item)ItemInit.QUANTUM_IRON_AXE.get();
                }
                if (tier == itemTier.GOLD) {
                    return (Item)ItemInit.QUANTUM_GOLD_AXE.get();
                }
                if (tier == itemTier.DIAMOND) {
                    return (Item)ItemInit.QUANTUM_DIAMOND_AXE.get();
                }
                if (tier != itemTier.NETHERITE) break;
                return (Item)ItemInit.QUANTUM_NETHERITE_AXE.get();
            }
            case 3: {
                if (tier == itemTier.WOODEN) {
                    return (Item)ItemInit.QUANTUM_WOODEN_PICKAXE.get();
                }
                if (tier == itemTier.STONE) {
                    return (Item)ItemInit.QUANTUM_STONE_PICKAXE.get();
                }
                if (tier == itemTier.IRON) {
                    return (Item)ItemInit.QUANTUM_IRON_PICKAXE.get();
                }
                if (tier == itemTier.GOLD) {
                    return (Item)ItemInit.QUANTUM_GOLD_PICKAXE.get();
                }
                if (tier == itemTier.DIAMOND) {
                    return (Item)ItemInit.QUANTUM_DIAMOND_PICKAXE.get();
                }
                if (tier != itemTier.NETHERITE) break;
                return (Item)ItemInit.QUANTUM_NETHERITE_PICKAXE.get();
            }
            case 2: {
                if (tier == itemTier.WOODEN) {
                    return (Item)ItemInit.QUANTUM_WOODEN_SHOVEL.get();
                }
                if (tier == itemTier.STONE) {
                    return (Item)ItemInit.QUANTUM_STONE_SHOVEL.get();
                }
                if (tier == itemTier.IRON) {
                    return (Item)ItemInit.QUANTUM_IRON_SHOVEL.get();
                }
                if (tier == itemTier.GOLD) {
                    return (Item)ItemInit.QUANTUM_GOLD_SHOVEL.get();
                }
                if (tier == itemTier.DIAMOND) {
                    return (Item)ItemInit.QUANTUM_DIAMOND_SHOVEL.get();
                }
                if (tier != itemTier.NETHERITE) break;
                return (Item)ItemInit.QUANTUM_NETHERITE_SHOVEL.get();
            }
            case 1: {
                if (tier == itemTier.WOODEN) {
                    return (Item)ItemInit.QUANTUM_WOODEN_SWORD.get();
                }
                if (tier == itemTier.STONE) {
                    return (Item)ItemInit.QUANTUM_STONE_SWORD.get();
                }
                if (tier == itemTier.IRON) {
                    return (Item)ItemInit.QUANTUM_IRON_SWORD.get();
                }
                if (tier == itemTier.GOLD) {
                    return (Item)ItemInit.QUANTUM_GOLD_SWORD.get();
                }
                if (tier == itemTier.DIAMOND) {
                    return (Item)ItemInit.QUANTUM_DIAMOND_SWORD.get();
                }
                if (tier != itemTier.NETHERITE) break;
                return (Item)ItemInit.QUANTUM_NETHERITE_SWORD.get();
            }
        }
        return null;
    }

    public static Item getItemForEnchant(itemType type, itemTier tier) {
        switch (type.ordinal()) {
            case 0: {
                if (tier == itemTier.WOODEN) {
                    return Items.WOODEN_AXE;
                }
                if (tier == itemTier.STONE) {
                    return Items.STONE_AXE;
                }
                if (tier == itemTier.IRON) {
                    return Items.IRON_AXE;
                }
                if (tier == itemTier.GOLD) {
                    return Items.GOLDEN_AXE;
                }
                if (tier == itemTier.DIAMOND) {
                    return Items.DIAMOND_AXE;
                }
                if (tier != itemTier.NETHERITE) break;
                return Items.NETHERITE_AXE;
            }
            case 3: {
                if (tier == itemTier.WOODEN) {
                    return Items.WOODEN_PICKAXE;
                }
                if (tier == itemTier.STONE) {
                    return Items.STONE_PICKAXE;
                }
                if (tier == itemTier.IRON) {
                    return Items.IRON_PICKAXE;
                }
                if (tier == itemTier.GOLD) {
                    return Items.GOLDEN_PICKAXE;
                }
                if (tier == itemTier.DIAMOND) {
                    return Items.DIAMOND_PICKAXE;
                }
                if (tier != itemTier.NETHERITE) break;
                return Items.NETHERITE_PICKAXE;
            }
            case 2: {
                if (tier == itemTier.WOODEN) {
                    return Items.WOODEN_SHOVEL;
                }
                if (tier == itemTier.STONE) {
                    return Items.STONE_SHOVEL;
                }
                if (tier == itemTier.IRON) {
                    return Items.IRON_SHOVEL;
                }
                if (tier == itemTier.GOLD) {
                    return Items.GOLDEN_SHOVEL;
                }
                if (tier == itemTier.DIAMOND) {
                    return Items.DIAMOND_SHOVEL;
                }
                if (tier != itemTier.NETHERITE) break;
                return Items.NETHERITE_SHOVEL;
            }
            case 1: {
                if (tier == itemTier.WOODEN) {
                    return Items.WOODEN_SWORD;
                }
                if (tier == itemTier.STONE) {
                    return Items.STONE_SWORD;
                }
                if (tier == itemTier.IRON) {
                    return Items.IRON_SWORD;
                }
                if (tier == itemTier.GOLD) {
                    return Items.GOLDEN_SWORD;
                }
                if (tier == itemTier.DIAMOND) {
                    return Items.DIAMOND_SWORD;
                }
                if (tier != itemTier.NETHERITE) break;
                return Items.NETHERITE_SWORD;
            }
        }
        return null;
    }

    public static enum itemType {
        AXE,
        SWORD,
        SHOVEL,
        PICKAXE;

    }

    public static enum itemTier {
        NONE,
        WOODEN,
        STONE,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;

    }
}

