/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.DisassemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.QdcMachines;
import com.qdc_mod.qdc_core_4.qdc_machines.boxes.MachineAreaBox;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineAreaFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineAreaSizeHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_tree_planter
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData machineData = new MachineData("Tree Planter");
    public Item[] options = new Item[]{Items.OAK_SAPLING, Items.SPRUCE_SAPLING, Items.BIRCH_SAPLING, Items.JUNGLE_SAPLING, Items.ACACIA_SAPLING, Items.DARK_OAK_SAPLING, Items.CHERRY_SAPLING};
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public ParticleCollection fuelParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public ArrayList<BlockPos> workArea = null;
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public boolean hasFuel = false;
    public boolean hasItemParticles = false;
    public boolean powered = true;
    public boolean isInStorage = true;
    private boolean isSpeedSet = false;

    public tile_entity_tree_planter(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_TREE_PLANTER.get(), pos, state);
    }

    public ItemStack getSizeStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getSeedStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setWorkAreaSize();
        this.setSpeed();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index == 0) {
            GlobalFuncs.showInGameMessage("Area size set to: " + this.machineData._sizeString);
        } else {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    public boolean updateSeed(Item item) {
        if (this.getSeedStack().getItem() == item) {
            return false;
        }
        if (!MainBox.isItemDiscovered(item)) {
            DisassemblerFunctions.setItemDiscovered(item);
        }
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)item));
        this.loadSeedItem();
        this.setChanged();
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        GlobalFuncs.showInGameMessage("Crop set to: " + BERFunctions.getItemName(this.getSeedStack()));
        return true;
    }

    private void setWorkAreaSize() {
        this.workAreaSize = MachineAreaSizeHandler.getAreaSize(this.itemHandler.getStackInSlot(0).getItem());
        this.size = this.workAreaSize.level;
        this.workArea = MachineAreaFunctions.getWorkAreaBlocks(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_planter, this.workAreaSize);
        this.workAreaIndex = 0;
        this.machineData._sizeString = this.workAreaSize.width + "x" + this.workAreaSize.depth;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_tree_planter.this.setChanged();
                if (slot == 0) {
                    tile_entity_tree_planter.this.setWorkAreaSize();
                }
                if (slot == 1) {
                    tile_entity_tree_planter.this.setSpeed();
                }
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (!this.getSeedStack().isEmpty()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getSeedStack());
                if (!this.powered) {
                    this.machineData._toolTip = "No redstone signal!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.isInStorage) {
                    this.machineData._toolTip = "No Saplings in Storage!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasFuel) {
                    this.machineData._toolTip = "No Fuel Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasItemParticles) {
                    this.machineData._toolTip = "No Item Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (this.isWorking) {
                    this.machineData._toolTip = "Working... " + this.tickPerc + "%";
                    this.machineData._toolTipColor = Color.green;
                } else {
                    this.machineData._toolTip = "Idle... " + this.tickPerc + "%";
                    this.machineData._toolTipColor = Color.blue;
                }
            } else {
                this.machineData._toolTip = "No Sapling selected!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            if (this.workAreaSize == null) {
                this.loadWorkAreaSize();
            }
            this.hasFuel = this.checkIfHasFuel();
            this.hasItemParticles = this.checkIfHasItemParticles();
            this.isInStorage = this.checkIfHasSeedsInStorage();
            this.sendToClient();
            if (!this.getSeedStack().isEmpty()) {
                this.powered = false;
                if (this.workArea == null) {
                    this.workArea = MachineAreaFunctions.getWorkAreaBlocks(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_planter, this.workAreaSize);
                }
                if (this.seedParticles == null) {
                    this.updateParticles();
                } else if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                    this.powered = true;
                    if (!this.isWorking) {
                        ++this.curTick;
                        if (this.curTick % 10 == 0) {
                            this.calcPerc(this.curTick, this.nextTarget);
                        }
                        if (this.curTick >= this.nextTarget) {
                            this.isWorking = true;
                            this.nextTarget = this.curDelayTicks;
                            this.curTick = 0;
                            this.tickPerc = 0;
                        }
                    } else {
                        ++this.curTick;
                        if (this.curTick >= this.nextTarget) {
                            this.curTick = 0;
                            if (this.hasItemParticles && this.isInStorage && this.canPlaceSapling()) {
                                this.level.setBlockAndUpdate(this.workArea.get(this.workAreaIndex), this.placeSeedItem.defaultBlockState());
                                QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.seedParticles);
                                QdcApi.QDC_CORE.FUNCTIONS.removeFromStorage(this.getSeedStack().getItem(), 1);
                            }
                            ++this.workAreaIndex;
                            this.calcPerc(this.workAreaIndex, this.workArea.size());
                            if (this.workAreaIndex == this.workArea.size()) {
                                this.workAreaIndex = 0;
                                this.isWorking = false;
                                this.curTick = 0;
                                this.tickPerc = 0;
                                this.nextTarget = this.idleTickCount;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean canPlaceSapling() {
        Block below = this.level.getBlockState(this.workArea.get(this.workAreaIndex).below()).getBlock();
        Block sameLevel = this.level.getBlockState(this.workArea.get(this.workAreaIndex)).getBlock();
        if (!this.isSameBlock(below, Blocks.DIRT) && !this.isSameBlock(below, Blocks.GRASS_BLOCK)) {
            return false;
        }
        return this.isSameBlock(sameLevel, Blocks.AIR);
    }

    private boolean isSameBlock(Block a, Block b) {
        return a == b;
    }

    private void calcPerc(int cur, int max) {
        float f_cur = cur;
        float f_max = max;
        this.tickPerc = (int)(f_cur / f_max * 100.0f);
        this.sendToClient();
    }

    private void loadWorkAreaSize() {
        this.workAreaSize = MachineAreaSizeHandler.getAreaSizeByLevel(this.size);
        if (this.workAreaSize == null) {
            this.workAreaSize = MachineAreaSizeHandler.getAreaSizeByLevel(0);
        }
    }

    private void loadSeedItem() {
        if (!this.getSeedStack().isEmpty()) {
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.placeSeedItem = this.getSeedCropBlock(this.getSeedStack());
        } else {
            this.seedParticles = null;
            this.placeSeedItem = null;
        }
    }

    private Block getSeedCropBlock(ItemStack seedItem) {
        return Block.byItem((Item)seedItem.getItem());
    }

    private void updateParticles() {
        this.seedParticles = GlobalFuncs.removeManaFromParticleCollection(QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(this.getSeedStack().getItem()));
        if (this.seedParticles != null) {
            this.seedParticles = this.cloneParticles(this.seedParticles);
            this.seedParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, QdcMachines.MACHINE_CHARGE));
        }
    }

    private boolean checkIfHasFuel() {
        if (this.fuelParticles == null) {
            this.fuelParticles = new ParticleCollection();
            this.fuelParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, QdcMachines.MACHINE_CHARGE));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.fuelParticles);
    }

    private boolean checkIfHasItemParticles() {
        if (this.seedParticles == null) {
            return false;
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.seedParticles);
    }

    private boolean checkIfHasSeedsInStorage() {
        return !this.getSeedStack().isEmpty() && QdcApi.QDC_CORE.FUNCTIONS.getItemStorageCount(this.getSeedStack().getItem()) > 0;
    }

    private ParticleCollection cloneParticles(ParticleCollection pc) {
        ParticleCollection res = new ParticleCollection();
        for (ParticleItem pi : pc.particleList) {
            res.add(new ParticleItem(pi.type, pi.amount));
        }
        return res;
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.TREE_PLANTER.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        output.putInt("size", this.size);
        output.putInt("perc", this.tickPerc);
        this.machineData.save(output);
        super.saveAdditional(output, provider);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, input.getCompound("inventory"));
        this.speed = input.getInt("speed");
        this.size = input.getInt("size");
        this.loadWorkAreaSize();
        this.loadSeedItem();
        this.updateTickCountsBySpeed();
        this.tickPerc = input.getInt("perc");
        this.machineData.load(input);
        super.loadAdditional(input, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

