/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity.classes;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.ppm_box.classes.PPM_BoxItem;
import com.qdc_mod.qdc_core_4.qdc_core.functions.pushy_pully_mergy.PushyPullyMergyFunctions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;

public class PPM_ParticleData {
    public PPM_BoxItem NATURE = new PPM_BoxItem(ENUMS.ParticleType.NATURE);
    public PPM_BoxItem FOOD = new PPM_BoxItem(ENUMS.ParticleType.FOOD);
    public PPM_BoxItem METAL = new PPM_BoxItem(ENUMS.ParticleType.METAL);
    public PPM_BoxItem GEM = new PPM_BoxItem(ENUMS.ParticleType.GEM);
    public PPM_BoxItem CORRUPTION = new PPM_BoxItem(ENUMS.ParticleType.CORRUPTION);
    public PPM_BoxItem MANA = new PPM_BoxItem(ENUMS.ParticleType.MANA);
    public PPM_BoxItem[] boxItemArray = new PPM_BoxItem[]{this.NATURE, this.FOOD, this.METAL, this.GEM, this.CORRUPTION, this.MANA};

    public List<String> getDisplayData() {
        ArrayList<String> res = new ArrayList<String>();
        for (PPM_BoxItem item : this.boxItemArray) {
            if (item.isEmpty()) continue;
            res.add(String.valueOf((Object)item.type) + " regen: " + item.stringVal);
        }
        return res;
    }

    public void addParticlesToGlobalRegen() {
        for (PPM_BoxItem item : this.boxItemArray) {
            QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.increment_PPM_BOX(item.type, item.amount);
        }
    }

    public void removeParticlesToGlobalRegen() {
        for (PPM_BoxItem item : this.boxItemArray) {
            QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.decrement_PPM_BOX(item.type, item.amount);
        }
    }

    public void multiply() {
        this.NATURE.multuply();
        this.FOOD.multuply();
        this.METAL.multuply();
        this.GEM.multuply();
        this.CORRUPTION.multuply();
        this.MANA.multuply();
    }

    public void set(Item item) {
        ParticleCollection particleCollection = QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(item);
        for (ParticleItem pi : particleCollection.particleList) {
            this.getItemByType(pi.type).increment(PushyPullyMergyFunctions.calcStartPercentage(pi.amount));
            QdcApi.PUSHY_PULLY_MERGY.FUNCTIONS.increment_PPM_BOX(pi.type, PushyPullyMergyFunctions.calcStartPercentage(pi.amount));
        }
    }

    private PPM_BoxItem getItemByType(ENUMS.ParticleType type) {
        for (PPM_BoxItem item : this.boxItemArray) {
            if (item.type != type) continue;
            return item;
        }
        return null;
    }

    public void saveAdditional(CompoundTag output) {
        output.putString("nature_part_regen", this.NATURE.amount.toString());
        output.putString("food_part_regen", this.FOOD.amount.toString());
        output.putString("metal_part_regen", this.METAL.amount.toString());
        output.putString("gem_part_regen", this.GEM.amount.toString());
        output.putString("corruption_part_regen", this.CORRUPTION.amount.toString());
        output.putString("mana_part_regen", this.MANA.amount.toString());
    }

    public void loadAdditional(CompoundTag input) {
        this.NATURE.amount = new BigDecimal(input.getString("nature_part_regen"));
        this.NATURE.fixString();
        this.FOOD.amount = new BigDecimal(input.getString("food_part_regen"));
        this.FOOD.fixString();
        this.METAL.amount = new BigDecimal(input.getString("metal_part_regen"));
        this.METAL.fixString();
        this.GEM.amount = new BigDecimal(input.getString("gem_part_regen"));
        this.GEM.fixString();
        this.CORRUPTION.amount = new BigDecimal(input.getString("corruption_part_regen"));
        this.CORRUPTION.fixString();
        this.MANA.amount = new BigDecimal(input.getString("mana_part_regen"));
        this.MANA.fixString();
    }
}

