/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes;

import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.tile_entity_elevator_platform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.classes.PlatformGuiData;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.settings.ElevatorSettings;
import java.awt.Point;
import net.minecraft.core.BlockPos;

public class QdcElevatorPlatform {
    public BlockPos pos = null;
    public String elevatorName = null;
    public String platformName = null;
    public boolean isInElevatorMode = false;
    public boolean isInRange = false;
    public boolean isAvailable = false;
    public tile_entity_elevator_platform te = null;
    public PlatformGuiData guiData = null;
    public int index = -1;
    public String floorString = null;

    public QdcElevatorPlatform(tile_entity_elevator_platform te, BlockPos pos, String elevatorName, String platformName) {
        this.te = te;
        this.pos = pos;
        this.elevatorName = elevatorName;
        this.platformName = platformName;
    }

    public void updatePlatformrName(String newName) {
        this.platformName = newName;
        this.te.machineData._platformName = newName;
        this.te.setChanged();
    }

    public void updateElevatorName(String newName) {
        this.elevatorName = newName;
        this.te.machineData._elevatorName = newName;
        this.te.setChanged();
    }

    public QdcElevatorPlatform isHoveringOver(Point windowPos, int x, int y) {
        if (GuiFunctions.isHoveringOver(windowPos, this.guiData.guiPos, ElevatorSettings.SIDE_WINDOW.ITEM.SIZE, new Point(x, y))) {
            return this;
        }
        return null;
    }

    public void setGuiPos(int index) {
        this.guiData = new PlatformGuiData(QdcElevatorBox.getPlatformGuiPos(index));
        this.setIndex(index);
    }

    private void setIndex(int index) {
        this.index = index;
        this.floorString = "" + (index + 1);
    }

    public void checkIfAvailable() {
        this.isAvailable = this.te.checkIfAvailable();
    }

    public void setIsInElevatorMode(Boolean isInElevatorMode) {
        this.isInElevatorMode = isInElevatorMode;
        this.te.machineData._isElevatorMode = isInElevatorMode;
    }

    public void setIsInRange(Boolean isInRange) {
        this.isInRange = isInRange;
    }

    public boolean isSame(BlockPos pos) {
        return this.pos.getY() == pos.getY();
    }

    public boolean isHigher(BlockPos pos) {
        return this.pos.getY() > pos.getY();
    }

    public boolean isLower(BlockPos pos) {
        return this.pos.getY() < pos.getY();
    }
}

