/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_crop_harvester;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_tree_harvester;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_tree_planter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;

public class MachineFunctions {
    private static final List<Item> MACHINE_CORES = MachineFunctions.generateMachineCoreList();

    public static boolean isValidOptionItemPlacer(Item item) {
        if (MachineFunctions.isValidMachineCore(item)) {
            return false;
        }
        if (item == Items.LEVER) {
            return false;
        }
        return QdcApi.QDC_CORE.FUNCTIONS.itemHasParticles(item);
    }

    public static boolean isValidOptionTreeHarvester(tile_entity_tree_harvester be, Item item) {
        return MachineFunctions.isInArray(be.options, item);
    }

    public static boolean isValidOptionTreePlanter(tile_entity_tree_planter be, Item item) {
        return MachineFunctions.isInArray(be.options, item);
    }

    public static boolean isValidOptionCropHarvester(tile_entity_crop_harvester be, Item item) {
        if (item == Items.WHEAT_SEEDS) {
            return false;
        }
        if (item == Items.BEETROOT_SEEDS) {
            return false;
        }
        if (item == Items.TORCHFLOWER_SEEDS) {
            return false;
        }
        if (!MainBox.ITEM_BOX.canItemBeDiscovered(item)) {
            return false;
        }
        if (MachineFunctions.isInArray(be.options, item)) {
            return true;
        }
        return MachineFunctions.isValidSeedOption(item);
    }

    public static boolean isValidSeedOption(Item item) {
        if (!MainBox.ITEM_BOX.canItemBeDiscovered(item)) {
            return false;
        }
        Block blockToPlace = Block.byItem((Item)item);
        return blockToPlace != Blocks.AIR && MachineFunctions.isCropBlock(blockToPlace);
    }

    public static boolean isCropBlock(Block block) {
        return block instanceof CropBlock;
    }

    private static boolean isInArray(Item[] items, Item item) {
        for (Item i : items) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMachineCore(Item item) {
        for (Item i : MACHINE_CORES) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    private static List<Item> generateMachineCoreList() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_WOOD);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_STONE);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_IRON);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_GOLD);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_DIAMOND);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_EMERALD);
        res.add(QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_NETHERITE);
        return res;
    }
}

