/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.classes;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class QdcItem {
    public String name;
    public Item item;
    public ParticleCollection particles = new ParticleCollection();
    public String window;
    public String searchName = "";
    public List<Item> requiredDiscoveryList = new ArrayList<Item>();
    public int corruptionAmount = 0;
    public boolean canBeDiscovered = true;

    public QdcItem(Item item, String window) {
        this.name = ((Item)item.builtInRegistryHolder().value()).toString();
        this.item = item;
        this.window = window;
        this.searchName = this.getItemSearchString(item);
    }

    public QdcItem register() {
        MainBox.MOD_WINDOW_BOX.addModItem(this);
        return this;
    }

    public QdcItem nature(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.NATURE, particles);
        return this;
    }

    public QdcItem food(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.FOOD, particles);
        return this;
    }

    public QdcItem metal(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.METAL, particles);
        return this;
    }

    public QdcItem gem(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.GEM, particles);
        return this;
    }

    public QdcItem corruption(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.CORRUPTION, particles);
        return this;
    }

    public QdcItem mana(double particles) {
        this.addParticleAmount(ENUMS.ParticleType.MANA, particles);
        return this;
    }

    private void addParticleAmount(ENUMS.ParticleType type, double amount) {
        this.particles.add(new ParticleItem(type, amount));
    }

    public QdcItem addRequiredItem(Item item) {
        if (this.requiredDiscoveryList.size() < 4) {
            this.requiredDiscoveryList.add(item);
        }
        return this;
    }

    public boolean hasSearchString(String searchStr) {
        return this.searchName.toLowerCase().contains(searchStr.toLowerCase());
    }

    private String getItemSearchString(Item i) {
        String res = new ItemStack((ItemLike)i).getDisplayName().getString().toLowerCase();
        return res;
    }
}

