/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.mod_window_box.classes.QdcItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler.ModAssemblerItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.mod_assembler.ModItemTab;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ModAssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class ModWindowItem {
    public String name;
    public Point pos;
    public boolean isHoveringOver;
    public int tabIndex = 0;
    public int itemIndex = 0;
    public List<ModItemTab> itemsTabsList = new ArrayList<ModItemTab>();
    public Item iconItem;
    public ModItemTab curItemTab = null;
    public int curTabIndex = -1;
    public int tabCount = -1;
    public String displayString = "";

    public ModWindowItem(Item iconItem, String name, List<QdcItem> allItems) {
        this.iconItem = iconItem;
        this.name = name;
        this.displayString = name;
        this.populateItems(allItems);
    }

    public boolean handleNextClick() {
        if (this.curTabIndex - 1 < this.itemsTabsList.size() - 1) {
            ++this.curTabIndex;
            this.curItemTab = this.itemsTabsList.get(this.curTabIndex - 1);
            return true;
        }
        return false;
    }

    public boolean handlePrevClick() {
        if (this.curTabIndex > 1) {
            --this.curTabIndex;
            this.curItemTab = this.itemsTabsList.get(this.curTabIndex - 1);
            return true;
        }
        return false;
    }

    public void populateItems(List<QdcItem> allItems) {
        for (QdcItem item : allItems) {
            if (!item.hasSearchString(Qdc.ModAssemblerVariables.searchString)) continue;
            if (this.itemsTabsList.size() == 0) {
                this.itemsTabsList.add(new ModItemTab());
            }
            if (!this.itemsTabsList.get((int)this.tabIndex).hasSpace) {
                this.itemsTabsList.add(new ModItemTab());
                ++this.tabIndex;
                this.itemIndex = 0;
            }
            this.itemsTabsList.get(this.tabIndex).add(new ModAssemblerItem(item, ModAssemblerSettings.ASSEMBLER_WINDOW.ITEMS.ITEM_POS_LIST.get(this.itemIndex)));
            ++this.itemIndex;
        }
        if (this.itemsTabsList.size() > 0) {
            this.curItemTab = this.itemsTabsList.get(0);
            this.curTabIndex = 1;
            this.tabCount = this.itemsTabsList.size();
        } else {
            this.curTabIndex = -1;
            this.tabCount = -1;
        }
    }

    public void setPosition(Point pos) {
        this.pos = pos;
    }

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, ModAssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }
}

