/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.item_particle_registration;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.item_particle_registration.ItemIngredient;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class PRI {
    public List<Item> mainItemList = new ArrayList<Item>();
    public List<ItemIngredient> ingredientList;
    public ParticleCollection defaultParticles = null;
    public ParticleCollection finalParticles = null;
    public int makeAmount = 1;

    public PRI setItem(Item item) {
        this.mainItemList.add(item);
        return this;
    }

    public PRI setItem(Item[] items) {
        for (Item item : items) {
            this.mainItemList.add(item);
        }
        return this;
    }

    public PRI nature(double nature) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, nature));
        return this;
    }

    public PRI food(double food) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.FOOD, food));
        return this;
    }

    public PRI metal(double metal) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.METAL, metal));
        return this;
    }

    public PRI gem(double gem) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.GEM, gem));
        return this;
    }

    public PRI corruption(double corruption) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.CORRUPTION, corruption));
        return this;
    }

    public PRI mana(double mana) {
        this.checkParticleCollectionInit();
        this.defaultParticles.add(new ParticleItem(ENUMS.ParticleType.MANA, mana));
        return this;
    }

    public PRI setMakeAmount(int newAmount) {
        this.makeAmount = newAmount;
        return this;
    }

    public PRI addIngredient(PRI item, int amount) {
        if (this.ingredientList == null) {
            this.ingredientList = new ArrayList<ItemIngredient>();
        }
        this.ingredientList.add(new ItemIngredient(item, amount));
        return this;
    }

    public PRI addToList(List<PRI> list) {
        list.add(this);
        return this;
    }

    public void calc() {
        this.finalParticles = new ParticleCollection();
        if (this.defaultParticles != null) {
            this.finalParticles.addOtherParticleCollection(this.defaultParticles, false);
        }
        if (this.ingredientList != null) {
            for (ItemIngredient ing : this.ingredientList) {
                if (ing.item.finalParticles == null) {
                    GlobalFuncs.msg("error:__ ing no particles " + String.valueOf(ing.item.mainItemList.get(0)));
                    continue;
                }
                this.finalParticles.addOtherParticleCollection(this.calcIngredientParticles(ing), false);
            }
            ParticleCollection extraPerc = this.finalParticles.getCollectionPercentage(10.0);
            this.finalParticles.addOtherParticleCollection(extraPerc, true);
        }
    }

    private ParticleCollection calcIngredientParticles(ItemIngredient ing) {
        ParticleCollection res = new ParticleCollection();
        for (ParticleItem pi : ing.item.finalParticles.particleList) {
            res.add(new ParticleItem(pi.type, this.calcParticles(this.makeAmount, ing.amount, pi.amount)));
        }
        return res;
    }

    private double calcParticles(int makeAmount, int amountRequired, double particles) {
        return particles * (double)amountRequired / (double)makeAmount;
    }

    private void checkParticleCollectionInit() {
        if (this.defaultParticles == null) {
            this.defaultParticles = new ParticleCollection();
        }
    }
}

