/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity_renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.classes.ElevatorPlatformMachineData;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.tile_entity_elevator_platform;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.ItemInit;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;

public class ElevatorPlatformBlockEntityRenderer
implements BlockEntityRenderer<tile_entity_elevator_platform> {
    private final Color TITLE_COLOR = BERFunctions.COLORS.TITLE_COLOR;
    private final Color TEXT_COLOR = BERFunctions.COLORS.TEXT_COLOR;
    private final Color MAIN_ITEN_NAME_COLOR = BERFunctions.COLORS.MAIN_ITEN_NAME_COLOR;
    private final float PLAYER_ANGLE_OFFSET = -90.0f;
    private final BlockEntityRendererProvider.Context context;
    private float lookToPlayerAngle = 0.0f;
    private String machineName = null;
    private ItemStack chickenEgg = new ItemStack((ItemLike)Items.EGG);
    private final PosePoint machineNamePos = new PosePoint(0.0f, -18.0f);
    private final float ELEVATOR_NAME_Y = -3.0f;
    private final float PLATFORM_NAME_Y = 10.0f;
    private final float TITLE_X = -45.0f;
    private final float NAME_X = 40.0f;
    private final PosePoint elevatorNameTitlePos = new PosePoint(-45.0f, -3.0f);
    private final PosePoint elevatorNamePos = new PosePoint(40.0f, -3.0f);
    private final PosePoint platformNameTitlePos = new PosePoint(-45.0f, 10.0f);
    private final PosePoint platformNamePos = new PosePoint(40.0f, 10.0f);

    public ElevatorPlatformBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull tile_entity_elevator_platform te, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Level level = te.getLevel();
        if (level == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Font font = this.context.getFont();
        BlockPos pos = te.getBlockPos().above();
        int packedLight = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
        this.lookToPlayerAngle = BERFunctions.calcToPlayerAngle((Player)player, pos, -90.0f);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(this.lookToPlayerAngle));
        poseStack.scale(2.0f, 0.5f, 1.0f);
        this.drawBackground(poseStack, pBuffer, level, packedLight);
        poseStack.scale(0.5f, 2.0f, 1.0f);
        poseStack.translate(0.0f, 0.0f, 0.05f);
        float scale = 0.25f;
        poseStack.scale(scale, scale, scale);
        this.writeAllText(te.machineData, font, poseStack, pBuffer, packedLight);
        poseStack.popPose();
    }

    private void drawBackground(PoseStack poseStack, MultiBufferSource buffer, Level level, int packedLight) {
        this.context.getItemRenderer().renderStatic(new ItemStack((ItemLike)ItemInit.QDC_MACHINE_SCREEN_BG.get()), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, level, 0);
    }

    private void writeAllText(ElevatorPlatformMachineData machineData, Font font, PoseStack ps, MultiBufferSource buffer, int packedLight) {
        float scale = 0.04f;
        ps.scale(scale, scale, scale);
        ps.mulPose(Axis.XP.rotationDegrees(180.0f));
        BERFunctions.writeText(this.machineNamePos, machineData._machineName, this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.elevatorNameTitlePos, "Elevator Name: ", this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.elevatorNamePos, machineData._elevatorName, machineData._isAvailableColor, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.platformNameTitlePos, "Platform Name: ", this.TITLE_COLOR, font, ps, buffer, packedLight);
        BERFunctions.writeText(this.platformNamePos, machineData._platformName, machineData._isAvailableColor, font, ps, buffer, packedLight);
    }
}

