/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions;

import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.boxes.MachineAreaBox;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.TreeHarvesterItem;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.base_machine_block.BaseMachineBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class MachineAreaFunctions {
    public static ArrayList<BlockPos> getTreeHarvesterWorkAreaBlocks_multi(Level world, BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize, TreeHarvesterItem validOptions) {
        ArrayList<BlockPos> basePosList = MachineAreaFunctions.getWorkAreaBlocks(world, machinePos, machineBox, areaSize);
        return MachineAreaFunctions.filterForLogsAndLeaves(world, validOptions, basePosList);
    }

    private static ArrayList<BlockPos> filterForLogsAndLeaves(Level level, TreeHarvesterItem validOptions, ArrayList<BlockPos> workArea) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        GlobalFuncs.line();
        for (BlockPos bp : workArea) {
            Item curBlockItem = MachineAreaFunctions.getBlockItemFromWorld(level, bp);
            if (!validOptions.isValidItem(curBlockItem)) continue;
            res.add(bp);
        }
        return res;
    }

    private static Item getBlockItemFromWorld(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock().asItem();
    }

    public static ArrayList<BlockPos> getWorkAreaBlocks_multi(Level world, BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        ArrayList<BlockPos> basePosList = MachineAreaFunctions.getWorkAreaBlocks(world, machinePos, machineBox, areaSize);
        ArrayList<BlockPos> multiPosList = new ArrayList<BlockPos>();
        for (BlockPos bp : basePosList) {
            multiPosList.add(new BlockPos(bp.getX(), bp.getY() + 2, bp.getZ()));
            multiPosList.add(new BlockPos(bp.getX(), bp.getY() + 1, bp.getZ()));
        }
        return multiPosList;
    }

    public static ArrayList<BlockPos> getWorkAreaBlocks(Level world, BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        Direction dir = (Direction)world.getBlockState(machinePos).getValue(BaseMachineBlock.FACING);
        switch (dir) {
            case NORTH: {
                return MachineAreaFunctions.calc_North(machinePos, machineBox, areaSize);
            }
            case SOUTH: {
                return MachineAreaFunctions.calc_South(machinePos, machineBox, areaSize);
            }
            case WEST: {
                return MachineAreaFunctions.calc_West(machinePos, machineBox, areaSize);
            }
            case EAST: {
                return MachineAreaFunctions.calc_East(machinePos, machineBox, areaSize);
            }
        }
        return null;
    }

    private static ArrayList<BlockPos> calc_North(BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int midWidth = areaSize.width / 2;
        int xStart = machinePos.getX() - midWidth;
        for (int y = 0; y < machineBox.height; ++y) {
            for (int z = 0; z < areaSize.depth; ++z) {
                for (int x = 0; x < areaSize.width; ++x) {
                    res.add(new BlockPos(xStart + x, machinePos.getY() + y, machinePos.getZ() - 1 - z));
                }
            }
        }
        return res;
    }

    private static ArrayList<BlockPos> calc_South(BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int midWidth = areaSize.width / 2;
        int xStart = machinePos.getX() - midWidth;
        for (int y = 0; y < machineBox.height; ++y) {
            for (int z = 0; z < areaSize.depth; ++z) {
                for (int x = 0; x < areaSize.width; ++x) {
                    res.add(new BlockPos(xStart + x, machinePos.getY() + y, machinePos.getZ() + (z + 1)));
                }
            }
        }
        return res;
    }

    private static ArrayList<BlockPos> calc_West(BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int midWidth = areaSize.width / 2;
        int zStart = machinePos.getZ() - midWidth;
        for (int y = 0; y < machineBox.height; ++y) {
            for (int x = 0; x < areaSize.depth; ++x) {
                for (int z = 0; z < areaSize.width; ++z) {
                    res.add(new BlockPos(machinePos.getX() - 1 - x, machinePos.getY() + y, zStart + z));
                }
            }
        }
        return res;
    }

    private static ArrayList<BlockPos> calc_East(BlockPos machinePos, MachineAreaBox.AreaBox machineBox, WorkAreaSize areaSize) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int midWidth = areaSize.width / 2;
        int zStart = machinePos.getZ() - midWidth;
        for (int y = 0; y < machineBox.height; ++y) {
            for (int x = 0; x < areaSize.depth; ++x) {
                for (int z = 0; z < areaSize.width; ++z) {
                    res.add(new BlockPos(machinePos.getX() + (x + 1), machinePos.getY() + y, zStart + z));
                }
            }
        }
        return res;
    }
}

