/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.diggyDirection;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.functions.QdcLightsFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class tile_entity_light_machine
extends BlockEntity {
    public String axis = "off";
    public boolean isPosAxis = false;
    private List<BlockPos> lightDirection = null;
    private List<BlockPos> darkDirection = null;
    private int[] lightLevels = new int[]{0, 0, 0, 0, 0, 0};
    private Item itemUsed;

    public tile_entity_light_machine(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_LIGHT_MACHINE.get(), pos, state);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void removeAll() {
        this.getAllDirections();
        for (BlockPos pb : this.darkDirection) {
            if (this.level.getBlockState(pb).getBlock() != BlockInit.QDC_LIGHT_BLOCK.get()) continue;
            this.level.setBlockAndUpdate(pb, Blocks.AIR.defaultBlockState());
        }
    }

    private void getAllDirections() {
        int i;
        this.darkDirection = new ArrayList<BlockPos>();
        for (i = 0; i < this.lightLevels[0]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() - (i + 3)));
        }
        for (i = 0; i < this.lightLevels[1]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() + (i + 3)));
        }
        for (i = 0; i < this.lightLevels[2]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX() - (i + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
        }
        for (i = 0; i < this.lightLevels[3]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX() + (i + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
        }
        for (i = 0; i < this.lightLevels[4]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() - (i + 3), this.getBlockPos().getZ()));
        }
        for (i = 0; i < this.lightLevels[5]; ++i) {
            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (i + 3), this.getBlockPos().getZ()));
        }
    }

    private void getDirection() {
        this.lightDirection = new ArrayList<BlockPos>();
        this.darkDirection = new ArrayList<BlockPos>();
        int lightLevel = QdcLightsFunctions.getMachineCoreLevel(this.itemUsed);
        if (lightLevel > 0) {
            switch (this.axis) {
                case "z": {
                    int i;
                    if (this.isPosAxis) {
                        int i2;
                        for (i2 = 0; i2 < this.lightLevels[0]; ++i2) {
                            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() - (i2 + 3)));
                        }
                        for (i2 = 0; i2 < lightLevel; ++i2) {
                            this.lightDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() - (i2 + 3)));
                        }
                        this.lightLevels[0] = lightLevel;
                        break;
                    }
                    for (i = 0; i < this.lightLevels[1]; ++i) {
                        this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() + (i + 3)));
                    }
                    for (i = 0; i < lightLevel; ++i) {
                        this.lightDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ() + (i + 3)));
                    }
                    this.lightLevels[1] = lightLevel;
                    break;
                }
                case "x": {
                    int i;
                    if (this.isPosAxis) {
                        int i3;
                        for (i3 = 0; i3 < this.lightLevels[2]; ++i3) {
                            this.darkDirection.add(new BlockPos(this.getBlockPos().getX() - (i3 + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
                        }
                        for (i3 = 0; i3 < lightLevel; ++i3) {
                            this.lightDirection.add(new BlockPos(this.getBlockPos().getX() - (i3 + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
                        }
                        this.lightLevels[2] = lightLevel;
                        break;
                    }
                    for (i = 0; i < this.lightLevels[3]; ++i) {
                        this.darkDirection.add(new BlockPos(this.getBlockPos().getX() + (i + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
                    }
                    for (i = 0; i < lightLevel; ++i) {
                        this.lightDirection.add(new BlockPos(this.getBlockPos().getX() + (i + 3), this.getBlockPos().getY(), this.getBlockPos().getZ()));
                    }
                    this.lightLevels[3] = lightLevel;
                    break;
                }
                case "y": {
                    int i;
                    if (this.isPosAxis) {
                        int i4;
                        for (i4 = 0; i4 < this.lightLevels[4]; ++i4) {
                            this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() - (i4 + 3), this.getBlockPos().getZ()));
                        }
                        for (i4 = 0; i4 < lightLevel; ++i4) {
                            this.lightDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() - (i4 + 3), this.getBlockPos().getZ()));
                        }
                        this.lightLevels[4] = lightLevel;
                        break;
                    }
                    for (i = 0; i < this.lightLevels[5]; ++i) {
                        this.darkDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (i + 3), this.getBlockPos().getZ()));
                    }
                    for (i = 0; i < lightLevel; ++i) {
                        this.lightDirection.add(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (i + 3), this.getBlockPos().getZ()));
                    }
                    this.lightLevels[5] = lightLevel;
                }
            }
        }
    }

    public void giveWork(diggyDirection diggyDir, Item itemUsed) {
        if (this.axis.equals("off")) {
            this.axis = diggyDir.axis;
            this.isPosAxis = diggyDir.isPos;
            this.itemUsed = itemUsed;
        }
    }

    public void tick() {
        if (!(this.level.isClientSide || this.axis == null || this.axis.equals("off") || this.axis.isBlank() || this.axis.isEmpty() || this.lightDirection != null)) {
            this.getDirection();
            for (BlockPos pb : this.darkDirection) {
                if (this.level.getBlockState(pb).getBlock() != BlockInit.QDC_LIGHT_BLOCK.get()) continue;
                this.level.setBlockAndUpdate(pb, Blocks.AIR.defaultBlockState());
            }
            for (BlockPos pb : this.lightDirection) {
                if (this.level.getBlockState(pb).getBlock() != Blocks.AIR) continue;
                this.level.setBlockAndUpdate(pb, ((Block)BlockInit.QDC_LIGHT_BLOCK.get()).defaultBlockState());
            }
            this.axis = "off";
            this.lightDirection = null;
            this.darkDirection = null;
        }
    }

    private void dropStuffs(BlockPos pos) {
        this.removeAll();
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.LIGHT_MACHINE.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        output.putIntArray("light_level", this.lightLevels);
        super.saveAdditional(output, provider);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        this.lightLevels = input.getIntArray("light_level");
        super.loadAdditional(input, provider);
    }
}

