/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines;

import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_light_machine;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.diggyDirection;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.functions.qdcDiggyFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class LightMachine
extends Block
implements EntityBlock {
    public LightMachine(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(i -> 7));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof tile_entity_light_machine) {
            tile_entity_light_machine te = (tile_entity_light_machine)blockEntity;
            te.onRemove();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide() && MachineFunctions.isValidMachineCore(stack.getItem())) {
            diggyDirection workDir = qdcDiggyFunctions.getDiggyDirection(hit.getDirection());
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof tile_entity_light_machine) {
                tile_entity_light_machine te = (tile_entity_light_machine)blockEntity;
                te.giveWork(workDir, stack.getItem());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof tile_entity_light_machine) {
                tile_entity_light_machine tile = (tile_entity_light_machine)t;
                tile.tick();
            }
        };
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BlockEntityInit.TILE_ENTITY_LIGHT_MACHINE.get().create(pos, state);
    }
}

