/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.functions;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class MachineItemUseFunctions {
    public static int getCoreLevel(Item item) {
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_WOOD) {
            return 1;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_STONE) {
            return 2;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_IRON) {
            return 3;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_GOLD) {
            return 4;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_DIAMOND) {
            return 5;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_EMERALD) {
            return 6;
        }
        if (item == QdcApi.QDC_CORE.ITEMS.MACHINE_CORES.CORE_NETHERITE) {
            return 7;
        }
        return 0;
    }

    public static int getQuarryCoreIndex(QuarryCoreType coreType) {
        switch (coreType.ordinal()) {
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    public static QuarryCoreType getQuarrySlot(Vec3 hit, BlockPos pos, Direction hitDir, Direction blockDir) {
        if (hitDir != blockDir) {
            return null;
        }
        switch (blockDir) {
            case DOWN: {
                double z;
                double x = hit.x;
                x -= (double)pos.getX();
                if (x > 0.5) {
                    z = hit.z;
                    if ((z -= (double)pos.getZ()) > 0.0 && z < (double)0.33f) {
                        return QuarryCoreType.X;
                    }
                    if (z > 0.33 && z < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (z > (double)0.66f) {
                        return QuarryCoreType.Z;
                    }
                } else {
                    return QuarryCoreType.SPEED;
                }
            }
            case UP: {
                double z;
                double x = hit.x;
                x -= (double)pos.getX();
                if (x > 0.5) {
                    z = hit.z;
                    if ((z -= (double)pos.getZ()) > 0.0 && z < (double)0.33f) {
                        return QuarryCoreType.Z;
                    }
                    if (z > 0.33 && z < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (z > (double)0.66f) {
                        return QuarryCoreType.X;
                    }
                } else {
                    return QuarryCoreType.SPEED;
                }
            }
            case NORTH: {
                double y;
                double x = hit.x;
                x -= (double)pos.getX();
                if (x > 0.5) {
                    y = hit.y;
                    if ((y -= (double)pos.getY()) > 0.0 && y < (double)0.33f) {
                        return QuarryCoreType.Z;
                    }
                    if (y > 0.33 && y < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (y > (double)0.66f) {
                        return QuarryCoreType.X;
                    }
                } else {
                    return QuarryCoreType.SPEED;
                }
            }
            case SOUTH: {
                double y;
                double x = hit.x;
                x -= (double)pos.getX();
                if (x < 0.5) {
                    y = hit.y;
                    if ((y -= (double)pos.getY()) > 0.0 && y < (double)0.33f) {
                        return QuarryCoreType.Z;
                    }
                    if (y > 0.33 && y < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (y > (double)0.66f) {
                        return QuarryCoreType.X;
                    }
                } else {
                    return QuarryCoreType.SPEED;
                }
            }
            case WEST: {
                double y;
                double z = hit.z;
                z -= (double)pos.getZ();
                if (z < 0.5) {
                    y = hit.y;
                    if ((y -= (double)pos.getY()) > 0.0 && y < (double)0.33f) {
                        return QuarryCoreType.Z;
                    }
                    if (y > 0.33 && y < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (y > (double)0.66f) {
                        return QuarryCoreType.X;
                    }
                } else {
                    return QuarryCoreType.SPEED;
                }
            }
            case EAST: {
                double y;
                double z = hit.z;
                z -= (double)pos.getZ();
                if (z > 0.5) {
                    y = hit.y;
                    if ((y -= (double)pos.getY()) > 0.0 && y < (double)0.33f) {
                        return QuarryCoreType.Z;
                    }
                    if (y > 0.33 && y < (double)0.66f) {
                        return QuarryCoreType.Y;
                    }
                    if (!(y > (double)0.66f)) break;
                    return QuarryCoreType.X;
                }
                return QuarryCoreType.SPEED;
            }
        }
        return null;
    }

    public static boolean isUseOnLeftSide(Vec3 hit, BlockPos pos, Direction dir) {
        switch (dir) {
            case EAST: {
                double z = hit.z;
                return (z -= (double)pos.getZ()) > 0.5;
            }
            case NORTH: {
                double x = hit.x;
                return (x -= (double)pos.getX()) > 0.5;
            }
            case SOUTH: {
                double x = hit.x;
                return (x -= (double)pos.getX()) < 0.5;
            }
            case WEST: {
                double z = hit.z;
                return (z -= (double)pos.getZ()) < 0.5;
            }
        }
        return false;
    }

    public static enum QuarryCoreType {
        X,
        Y,
        Z,
        SPEED;

    }
}

