/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity;

import com.ibm.icu.math.BigDecimal;
import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity.classes.PPM_ParticleData;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.BlockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PPM_BlockEntity
extends BlockEntity {
    public int mergeLevel = 1;
    public BigDecimal percentage = new BigDecimal(Qdc.PushyPullyMergyStuff.BASE_PERCENTAGE);
    public String percString = "0";
    public PPM_ParticleData particleData = new PPM_ParticleData();
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            PPM_BlockEntity.this.setChanged();
            if (!PPM_BlockEntity.this.level.isClientSide()) {
                PPM_BlockEntity.this.level.sendBlockUpdated(PPM_BlockEntity.this.getBlockPos(), PPM_BlockEntity.this.getBlockState(), PPM_BlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public PPM_BlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityInit.PPM_BLOCKENTITY.get(), pPos, pBlockState);
        this.setPercString();
    }

    public void addParticlesToGlobalRegen() {
        this.particleData.addParticlesToGlobalRegen();
    }

    public void removeParticlesToGlobalRegen() {
        this.particleData.removeParticlesToGlobalRegen();
    }

    public void setItemParticles(Item item) {
        this.particleData.set(item);
        this.setChanged();
    }

    public void upgradeBlockeEntity() {
        ++this.mergeLevel;
        this.percentage = this.percentage.multiply(new BigDecimal("4"));
        this.particleData.multiply();
        this.setChanged();
        this.setPercString();
    }

    private void setPercString() {
        this.percString = "" + this.percentage.multiply(new BigDecimal("100")).intValue();
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public boolean isSameBlockEntityValues(PPM_BlockEntity otherBlockEntity) {
        return this.mergeLevel == otherBlockEntity.mergeLevel && this.inventory.getStackInSlot(0).getItem() == otherBlockEntity.inventory.getStackInSlot(0).getItem();
    }

    public void cloneFrom(PPM_BlockEntity old) {
        this.mergeLevel = old.mergeLevel;
        this.percentage = old.percentage;
        this.inventory.setStackInSlot(0, old.inventory.getStackInSlot(0));
        this.particleData = old.particleData;
        this.setChanged();
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.serialize(output);
        output.putInt("lvl", this.mergeLevel);
        output.putString("perc", this.percentage.toString());
        this.particleData.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.inventory.deserialize(input);
        this.mergeLevel = (Integer)input.getInt("lvl").get();
        this.percentage = new BigDecimal((String)input.getString("perc").get());
        this.particleData.loadAdditional(input);
        this.setPercString();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

