/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.recycler.RecyclerGuiBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.recycler.RecyclerGuiItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.RecyclerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ResearchMissionBaseSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.RecyclerMenu;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class RecyclerScreen
extends AbstractContainerScreen<RecyclerMenu> {
    RecyclerGuiBox recyclerBox = new RecyclerGuiBox();
    private final Point WINDOW_SIZE = RecyclerSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private Point titleSize;
    private Point titlePos;
    private final Point ITEM_NAME_SIZE;
    private final Point ITEM_NAME_POS;
    private final Color ITEM_NAME_BG_COLOR;
    private final Point ITEM_NAME_ICON_POS;
    private final Point ITEM_NAME_TEXT_POS;
    private final Color ITEM_NAME_TEXT_COLOR;
    private final Point CORRUPTION_AMOUNT_SIZE;
    private final Point CORRUPTION_AMOUNT_POS;
    private final Color CORRUPTION_AMOUNT_BG_COLOR;
    private final Point CORRUPTION_AMOUNT_ICON_POS;
    private final Point CORRUPTION_AMOUNT_TEXT_POS;
    private final Color CORRUPTION_AMOUNT_TEXT_COLOR;
    private final Point ITEM_SIZE;
    public static final Color ITEM_FILL_COLOR = RecyclerSettings.ITEMS.ITEM.FILL_COLOR;
    public static final Color ITEM_BORDER_COLOR = RecyclerSettings.ITEMS.ITEM.BORDER_COLOR;
    public static final Color ITEM_BORDER_HOVER_COLOR = RecyclerSettings.ITEMS.ITEM.BORDER_HOVER_COLOR;
    private final Point ITEM_ICON_SIZE;
    private final Item CORRUPTION_ITEM_ICON;
    private final Color BTN_TEXT_COLOR;
    private final Color BTN_TEXT_COLOR_HOVER;
    private final Point BUTTON_ICON_POS;
    private final Point BUTTON_AMOUNT_POS;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, RecyclerSettings.RECALIBRATION_BUTTON.POS, RecyclerSettings.RECALIBRATION_BUTTON.SIZE, "Recalibrate!", btnType.RECALIBRATE));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public RecyclerScreen(RecyclerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.ITEM_NAME_SIZE = RecyclerSettings.ITEM_NAME.SIZE;
        this.ITEM_NAME_POS = RecyclerSettings.ITEM_NAME.POS;
        this.ITEM_NAME_BG_COLOR = RecyclerSettings.ITEM_NAME.BG_COLOR;
        this.ITEM_NAME_ICON_POS = RecyclerSettings.ITEM_NAME.ICON.POS;
        this.ITEM_NAME_TEXT_POS = RecyclerSettings.ITEM_NAME.TEXT.POS;
        this.ITEM_NAME_TEXT_COLOR = RecyclerSettings.ITEM_NAME.TEXT.COLOR;
        this.CORRUPTION_AMOUNT_SIZE = RecyclerSettings.CORRUPTION_AMOUNT.SIZE;
        this.CORRUPTION_AMOUNT_POS = RecyclerSettings.CORRUPTION_AMOUNT.POS;
        this.CORRUPTION_AMOUNT_BG_COLOR = RecyclerSettings.CORRUPTION_AMOUNT.BG_COLOR;
        this.CORRUPTION_AMOUNT_ICON_POS = RecyclerSettings.CORRUPTION_AMOUNT.ICON.POS;
        this.CORRUPTION_AMOUNT_TEXT_POS = RecyclerSettings.CORRUPTION_AMOUNT.TEXT.POS;
        this.CORRUPTION_AMOUNT_TEXT_COLOR = RecyclerSettings.CORRUPTION_AMOUNT.TEXT.COLOR;
        this.ITEM_SIZE = RecyclerSettings.ITEMS.ITEM.SIZE;
        this.ITEM_ICON_SIZE = RecyclerSettings.ITEMS.ICON.SIZE;
        this.CORRUPTION_ITEM_ICON = QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(ENUMS.ParticleType.CORRUPTION);
        this.BTN_TEXT_COLOR = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR;
        this.BTN_TEXT_COLOR_HOVER = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR_HOVER;
        this.BUTTON_ICON_POS = RecyclerSettings.RECALIBRATION_BUTTON.ICON.POS;
        this.BUTTON_AMOUNT_POS = RecyclerSettings.RECALIBRATION_BUTTON.AMOUNT.POS;
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
        this.recyclerBox.handleDataLoad();
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
        this.recyclerBox.checkIfHoveringOver(this.WINDOW_POS, x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Corruption Recycler");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawButtons(gg);
        this.drawItemName(gg);
        this.drawCorruptionAmount(gg);
        this.drawItems(gg);
    }

    public void drawItemName(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.ITEM_NAME_POS, this.ITEM_NAME_SIZE, this.ITEM_NAME_BG_COLOR, Color.white);
        if (this.recyclerBox.curItemHovered != null && this.recyclerBox.curItemHovered.isDiscovered) {
            this.drawItemIcon(gg, this.recyclerBox.curItemHovered.item, this.ITEM_NAME_ICON_POS.x, this.ITEM_NAME_ICON_POS.y);
            this.writeString(gg, this.recyclerBox.curItemHovered.itemName, this.ITEM_NAME_TEXT_POS.x, this.ITEM_NAME_TEXT_POS.y, this.ITEM_NAME_TEXT_COLOR);
        }
    }

    public void drawCorruptionAmount(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.CORRUPTION_AMOUNT_POS, this.CORRUPTION_AMOUNT_SIZE, this.CORRUPTION_AMOUNT_BG_COLOR, Color.white);
        this.drawItemIcon(gg, this.CORRUPTION_ITEM_ICON, this.CORRUPTION_AMOUNT_ICON_POS.x, this.CORRUPTION_AMOUNT_ICON_POS.y);
        this.writeString(gg, "Corruption Available: " + QdcApi.QDC_CORE.FUNCTIONS.getParticleAmountShort(ENUMS.ParticleType.CORRUPTION), this.CORRUPTION_AMOUNT_TEXT_POS.x, this.CORRUPTION_AMOUNT_TEXT_POS.y, this.CORRUPTION_AMOUNT_TEXT_COLOR);
    }

    public void drawItems(GuiGraphics gg) {
        for (RecyclerGuiItem item : this.recyclerBox.itemList) {
            if (item.isHoveringOver) {
                this.drawRectangleWithBorder(gg, item.pos, this.ITEM_SIZE, item.bgColor, ITEM_BORDER_HOVER_COLOR);
            } else {
                this.drawRectangleWithBorder(gg, item.pos, this.ITEM_SIZE, item.bgColor, ITEM_BORDER_COLOR);
            }
            this.drawRectangleWithBorder(gg, item.itemIconPos, this.ITEM_ICON_SIZE, ITEM_BORDER_COLOR, ITEM_BORDER_COLOR);
            if (item.isDiscovered) {
                this.drawItemIcon(gg, item.item, item.itemIconPos.x + 2, item.itemIconPos.y + 2);
            } else {
                this.writeString(gg, "???", item.itemIconPos.x + 1, item.itemIconPos.y + 5, Color.red);
            }
            this.drawItemIcon(gg, this.CORRUPTION_ITEM_ICON, item.corruptionIconIconPos.x, item.corruptionIconIconPos.y);
            this.writeStringCentred(gg, "" + item.corruptionAmount, item.corruptionAmountTextPos.x, item.corruptionAmountTextPos.y, item.textColor);
        }
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (!this.recyclerBox.hasData()) continue;
            if (this.curHoverItem == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + 40, button.pos.y + 4, this.BTN_TEXT_COLOR_HOVER);
                this.writeString(gg, "10.0", this.BUTTON_AMOUNT_POS.x, this.BUTTON_AMOUNT_POS.y, this.BTN_TEXT_COLOR_HOVER);
            } else {
                this.drawButton(gg, button.pos, button.size, false);
                this.writeStringCentred(gg, button.text, button.pos.x + 40, button.pos.y + 4, this.BTN_TEXT_COLOR);
                this.writeString(gg, "10.0", this.BUTTON_AMOUNT_POS.x, this.BUTTON_AMOUNT_POS.y, this.BTN_TEXT_COLOR);
            }
            this.drawItemIcon(gg, this.CORRUPTION_ITEM_ICON, this.BUTTON_ICON_POS.x, this.BUTTON_ICON_POS.y);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 0: {
                    if (!this.recyclerBox.hasData()) break;
                    if (this.recyclerBox.handleRecalibrateClick()) {
                        this.playClickSound();
                        break;
                    }
                    this.playErrorSound();
                }
            }
        }
        if (this.recyclerBox.curItemHovered != null && !this.recyclerBox.curItemHovered.isDiscovered) {
            if (this.recyclerBox.curItemHovered.hasEnoughParticles) {
                if (this.recyclerBox.handleItemClick()) {
                    this.playDiscoverySound();
                }
            } else {
                this.playErrorSound();
            }
        }
        return false;
    }

    private void playClickSound() {
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
    }

    private void playDiscoverySound() {
        this.player.playSound(SoundEvents.BELL_BLOCK, 0.5f, 1.0f);
    }

    private void playErrorSound() {
        this.player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 0.5f, 1.0f);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;

        public GuiButton(RecyclerScreen this$0, Point pos, Point size, String text, btnType type) {
            super(pos, size, text);
            this.type = type;
        }
    }

    public static enum btnType {
        RECALIBRATE;

    }
}

