/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines;

import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_enchanter;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.base_machine_block.BaseMachineBlock;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineItemUseFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class Enchanter
extends BaseMachineBlock
implements EntityBlock {
    public Enchanter(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            tile_entity_enchanter curTileEntity = null;
            if (be instanceof tile_entity_enchanter) {
                tile_entity_enchanter te;
                curTileEntity = te = (tile_entity_enchanter)be;
            }
            if (MachineFunctions.isValidMachineCore(stack.getItem())) {
                if (!MachineItemUseFunctions.isUseOnLeftSide(hit.getLocation(), pos, hit.getDirection()) && curTileEntity.addMachineCore(stack.getItem(), 1)) {
                    MachineSoundFunctions.playMachineCoreSound(level, pos);
                }
            } else if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                if (curTileEntity.hasAnItem()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, curTileEntity.getItemStack().copy());
                    curTileEntity.updateItem(ItemStack.EMPTY);
                }
            } else if (player.getItemInHand(InteractionHand.MAIN_HAND).isEnchantable() && !curTileEntity.hasAnItem()) {
                curTileEntity.updateItem(player.getItemInHand(InteractionHand.MAIN_HAND));
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                MachineSoundFunctions.playMachineItemInsertedSound(level, pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof tile_entity_enchanter) {
                tile_entity_enchanter tile = (tile_entity_enchanter)t;
                tile.tick();
            }
        };
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BlockEntityInit.TILE_ENTITY_ENCHANTER.get().create(pos, state);
    }
}

