/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.ModItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.classes.Window;
import java.util.ArrayList;
import net.minecraft.world.item.Item;

public class WindowBox {
    public int totalDiscoveryItems = 0;
    public int totalDiscoverdItems = 0;
    public ArrayList<Window> windowList = new ArrayList();

    public void calcWindowDiscoveries() {
        this.totalDiscoveryItems = 0;
        this.totalDiscoverdItems = 0;
        for (Window w : this.windowList) {
            w.calcDiscoveredCount();
            this.totalDiscoveryItems += w.total;
            this.totalDiscoverdItems += w.discovered;
        }
    }

    public void clear() {
        for (Window win : this.windowList) {
            win.discovered = 0;
        }
    }

    public Window getItemWindow(Item item) {
        for (Window w : this.windowList) {
            if (!w.isItemInWindow(item)) continue;
            return w;
        }
        return null;
    }

    public void addWindow(Window win) {
        this.windowList.add(win);
    }

    public String getWindowNameByType(ENUMS.WINDOW winType) {
        for (Window win : this.windowList) {
            if (win.type != winType) continue;
            return win.name;
        }
        return null;
    }

    private boolean windowExists(String windowName) {
        for (Window win : this.windowList) {
            if (!win.name.equals(windowName)) continue;
            return true;
        }
        return false;
    }

    public void addModItem(ModItem item) {
        this.getWindow(item.window).addItem(item);
    }

    public void incrementWindowDiscoveryCount(String windowName) {
        ++this.getWindow((String)windowName).discovered;
    }

    public Window getWindow(String windowName) {
        for (Window win : this.windowList) {
            if (!win.name.equals(windowName)) continue;
            return win;
        }
        return null;
    }
}

