/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData2;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.ElevatorRangeData;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevator;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevatorPlatform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.tile_entity_elevator_platform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.settings.ElevatorSettings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class QdcElevatorBox {
    public static List<QdcElevator> elevators = new ArrayList<QdcElevator>();
    public static List<QdcElevator> elevatorsInRange = new ArrayList<QdcElevator>();
    public static String elevatorEditString = "";
    public static String platformEditString = "";

    public static void clear() {
        elevators = new ArrayList<QdcElevator>();
        elevatorsInRange = new ArrayList<QdcElevator>();
    }

    public static void notifyAdd(tile_entity_elevator_platform te, BlockPos pos, String elevatorName, String platformName) {
        QdcElevator curElevator = QdcElevatorBox.getElevator(pos);
        if (curElevator != null) {
            curElevator.addPlatform(te, pos, elevatorName, platformName);
        } else {
            elevators.add(new QdcElevator(te, pos, elevatorName, platformName));
        }
        QdcElevatorBox.notifyRangeCheck(Qdc.curPlayer.blockPosition());
        QdcElevatorBox.getElevatorsInRange();
        GlobalFuncs.msg("add " + pos.toString());
    }

    public static void notifyRemove(BlockPos pos) {
        for (QdcElevator e : elevators) {
            e.handleNotifyRemove(pos);
        }
        QdcElevatorBox.clearEmptyElevators();
    }

    public static void notifyRangeCheck(BlockPos pos) {
        ElevatorRangeData rangeData = new ElevatorRangeData(pos);
        for (QdcElevator e : elevators) {
            e.checkIfIsInRange(rangeData);
            e.checkForPlatformAvailability();
        }
    }

    public static List<QdcElevator> getElevatorsInRange() {
        ArrayList<QdcElevator> res = new ArrayList<QdcElevator>();
        for (QdcElevator e : elevators) {
            if (!e.isInRange) continue;
            res.add(e);
        }
        elevatorsInRange = res;
        return res;
    }

    private static void clearEmptyElevators() {
        ArrayList<QdcElevator> toRemove = new ArrayList<QdcElevator>();
        for (QdcElevator e : elevators) {
            if (e.platforms.size() != 0) continue;
            toRemove.add(e);
        }
        for (QdcElevator e : toRemove) {
            elevators.remove(e);
        }
    }

    public static QdcElevator getElevator(BlockPos pos) {
        for (QdcElevator e : elevators) {
            if (!e.isSameElevatorPos(pos)) continue;
            return e;
        }
        return null;
    }

    public static QdcElevator getHoverElevator(Point windowPos, int x, int y) {
        QdcElevator cur = null;
        for (QdcElevator e : elevatorsInRange) {
            cur = e.isHoveringOver(windowPos, x, y);
            if (cur == null) continue;
            return e;
        }
        return null;
    }

    public static Point getPlatformGuiPos(int index) {
        return new Point(5, (ElevatorSettings.SIDE_WINDOW.ITEM.SIZE.y + 3) * index + ElevatorSettings.SIDE_WINDOW.TOP_GAP);
    }

    public static void handleTeleportClick(QdcElevatorPlatform platform) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new myData2.MyData2((double)platform.pos.getX() + 0.5, (double)platform.pos.getY() + 1.0, (double)platform.pos.getZ() + 0.5), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void print() {
        GlobalFuncs.line();
        GlobalFuncs.line();
        for (QdcElevator e : elevators) {
            GlobalFuncs.line();
            for (QdcElevatorPlatform p : e.platforms) {
                System.out.print(p.isAvailable + " [");
                System.out.print(p.elevatorName + "] [");
                System.out.print(p.platformName + "] ");
                System.out.print(p.isInElevatorMode + " ");
                System.out.println(p.isInRange + " ");
            }
        }
    }
}

