/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity;

import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevatorPlatform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.block_entity.classes.ElevatorPlatformMachineData;
import com.qdc_mod.qdc_core_4.qdc_elevator.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_elevator.core.init.BlockInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class tile_entity_elevator_platform
extends BlockEntity {
    public ElevatorPlatformMachineData machineData = new ElevatorPlatformMachineData("Quantum Elevator Platform");
    public boolean isNotifyReady = false;
    private int tickCount = 0;
    private int maxTickCount = 50;

    public tile_entity_elevator_platform(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_ELEVATOR_PLATFORM.get(), pos, state);
    }

    public void doNotify() {
        QdcElevatorBox.notifyAdd(this, this.getBlockPos(), this.machineData._elevatorName, this.machineData._platformName);
    }

    public void getElevatorName() {
        this.machineData._elevatorName = QdcElevatorBox.getElevator((BlockPos)this.getBlockPos()).elevatorName;
        this.setChanged();
    }

    public void sendToClient() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            ++this.tickCount;
            if (this.tickCount == this.maxTickCount) {
                this.tickCount = 0;
                if (!this.isNotifyReady) {
                    this.doNotify();
                    this.getElevatorName();
                    this.isNotifyReady = true;
                }
                this.checkIfAvailable();
                this.sendToClient();
            }
        }
    }

    public boolean checkIfAvailable() {
        if (this.level.getBlockState(this.getBlockPos().above()).getBlock() == Blocks.AIR && this.level.getBlockState(this.getBlockPos().above().above()).getBlock() == Blocks.AIR) {
            this.machineData.setAvailability(true);
        } else {
            this.machineData.setAvailability(false);
        }
        this.sendToClient();
        return this.machineData._isAvailable;
    }

    public void notify(QdcElevatorPlatform platform) {
        this.machineData._elevatorName = platform.elevatorName;
        this.machineData._platformName = platform.platformName;
        this.machineData._isInRange = platform.isInRange;
        this.machineData._isElevatorMode = platform.isInElevatorMode;
        this.checkIfAvailable();
        this.sendToClient();
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.ELEVATOR_PLATFORM.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        QdcElevatorBox.notifyRemove(this.getBlockPos());
        this.dropStuffs(pos);
        super.preRemoveSideEffects(pos, state);
    }

    protected void saveAdditional(ValueOutput output) {
        this.machineData.save(output);
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        this.machineData.load(input);
        super.loadAdditional(input);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

