/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.functions.GuiSoundFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevator;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.classes.QdcElevatorPlatform;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.classes.RectangleColorData;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.functions.KeyInputFunctions;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.settings.ElevatorSettings;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.menu.ElevatorMenu;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class ElevatorScreen
extends AbstractContainerScreen<ElevatorMenu> {
    private final Point WINDOW_SIZE = ElevatorSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverButton = null;
    private Player player;
    private boolean isMapWindow = true;
    private QdcElevator curMapHoverItem = null;
    private QdcElevator curSelectedElevator = null;
    private QdcElevatorPlatform curHoverPlatform = null;
    private QdcElevatorPlatform curSelectedPlatform = null;
    private boolean isElevatorEditMode = false;
    private boolean isPlatformEditMode = false;
    private String platformEditString = "";
    private final Point TXT_ELEVATOR_POS = ElevatorSettings.ELEVATOR_WINDOW.TEXTBOX.POS;
    private final Point TXT_ELEVATOR_SIZE = ElevatorSettings.ELEVATOR_WINDOW.TEXTBOX.SIZE;
    EditBox txtElevator;
    private final Point TXT_PLATFORM_POS = ElevatorSettings.PLATFORM_WINDOW.TEXTBOX.POS;
    private final Point TXT_PLATFORM_SIZE = ElevatorSettings.PLATFORM_WINDOW.TEXTBOX.SIZE;
    EditBox txtPlatform;
    private final GuiButton btnElevatorRename = new GuiButton(this, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.RENAME.POS, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.RENAME.SIZE, "Rename", btnType.ELEVATOR_RENAME, false);
    private final GuiButton btnElevatorSave = new GuiButton(this, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.SAVE.POS, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.SAVE.SIZE, "Save", btnType.ELEVATOR_SAVE, false);
    private final GuiButton btnElevatorCancel = new GuiButton(this, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.CANCEL.POS, ElevatorSettings.ELEVATOR_WINDOW.BUTTONS.CANCEL.SIZE, "Cancel", btnType.ELEVATOR_CANCEL, false);
    private final GuiButton btnPlatformRename = new GuiButton(this, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.RENAME.POS, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.RENAME.SIZE, "Rename", btnType.PLATFORM_RENAME, false);
    private final GuiButton btnPlatformSave = new GuiButton(this, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.SAVE.POS, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.SAVE.SIZE, "Save", btnType.PLATFORM_SAVE, false);
    private final GuiButton btnPlatformCancel = new GuiButton(this, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.CANCEL.POS, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.CANCEL.SIZE, "Cancel", btnType.PLATFORM_CANCEL, false);
    private final GuiButton btnPlatformTele = new GuiButton(this, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.TELE.POS, ElevatorSettings.PLATFORM_WINDOW.BUTTONS.TELE.SIZE, "Teleport", btnType.PLATFORM_TELE, false);
    private Point titleSize;
    private Point titlePos;
    public Point MAP_TOOLTIP_POS;
    public final Point MAP_TOOLTIP_SIZE;
    private final Color BUTTON_TEXT_COLOR;
    private final Color BUTTON_TEXT_COLOR_ACTIVE;

    private void reset() {
        this.curSelectedElevator = null;
        this.curSelectedPlatform = null;
        QdcElevatorBox.elevatorEditString = "";
        this.platformEditString = "";
        this.isElevatorEditMode = false;
        this.isPlatformEditMode = false;
        this.setElevatorButtons();
        this.setPlatformButtons();
    }

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(this.btnElevatorRename);
        res.add(this.btnElevatorSave);
        res.add(this.btnElevatorCancel);
        res.add(this.btnPlatformRename);
        res.add(this.btnPlatformSave);
        res.add(this.btnPlatformCancel);
        res.add(this.btnPlatformTele);
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY) || !b.isVisible) continue;
            return b.type;
        }
        return null;
    }

    public ElevatorScreen(ElevatorMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.MAP_TOOLTIP_POS = null;
        this.MAP_TOOLTIP_SIZE = new Point(115, 15);
        this.BUTTON_TEXT_COLOR = Color.white;
        this.BUTTON_TEXT_COLOR_ACTIVE = Color.red;
        this.player = inv.player;
    }

    private void setTextBoxAvailability(EditBox txt, boolean isEnabled) {
        txt.setEditable(isEnabled);
        txt.setVisible(isEnabled);
        txt.setFocused(isEnabled);
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.txtElevator = new EditBox(this.font, this.WINDOW_POS.x + this.TXT_ELEVATOR_POS.x, this.WINDOW_POS.y + this.TXT_ELEVATOR_POS.y, this.TXT_ELEVATOR_SIZE.x, this.TXT_ELEVATOR_SIZE.y, (Component)Component.literal((String)"txtElevator"));
        this.txtElevator.setTextColor(Color.white.getRGB());
        this.txtElevator.setBordered(true);
        this.txtElevator.setMaxLength(14);
        this.txtElevator.setResponder(this::onTxtElevatorChange);
        this.addRenderableWidget((GuiEventListener)this.txtElevator);
        this.setTextBoxAvailability(this.txtElevator, false);
        this.txtPlatform = new EditBox(this.font, this.WINDOW_POS.x + this.TXT_PLATFORM_POS.x, this.WINDOW_POS.y + this.TXT_PLATFORM_POS.y, this.TXT_PLATFORM_SIZE.x, this.TXT_PLATFORM_SIZE.y, (Component)Component.literal((String)"txtPlatform"));
        this.txtPlatform.setTextColor(Color.white.getRGB());
        this.txtPlatform.setBordered(true);
        this.txtPlatform.setMaxLength(14);
        this.txtPlatform.setResponder(this::onTxtPlatformChange);
        this.addRenderableWidget((GuiEventListener)this.txtPlatform);
        this.setTextBoxAvailability(this.txtPlatform, false);
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
    }

    public void onTxtElevatorChange(String str) {
    }

    public void onTxtPlatformChange(String str) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.txtElevator.isFocused()) {
            KeyInputFunctions.KeyPressResult pressRes = KeyInputFunctions.handleKeyPressElevator(InputConstants.getKey((int)keyCode, (int)scanCode).getValue());
            GlobalFuncs.msg(String.valueOf((Object)pressRes) + " _elevator " + QdcElevatorBox.elevatorEditString);
            this.txtElevator.setValue(QdcElevatorBox.elevatorEditString);
            switch (pressRes) {
                case BACKSPACE: {
                    this.playClickSound();
                    break;
                }
                case ERROR: {
                    this.playErrorSound();
                    break;
                }
                case ESCAPE: {
                    this.minecraft.player.closeContainer();
                    break;
                }
                case LETTER: {
                    this.playClickSound();
                    break;
                }
                case RETURN: {
                    this.playClickSound();
                    this.handleElevatorNameSave();
                    this.isElevatorEditMode = false;
                    this.setElevatorButtons();
                }
            }
            return true;
        }
        if (this.txtPlatform.isFocused()) {
            KeyInputFunctions.KeyPressResult pressRes = KeyInputFunctions.handleKeyPressPlatform(InputConstants.getKey((int)keyCode, (int)scanCode).getValue());
            GlobalFuncs.msg(String.valueOf((Object)pressRes) + " _platform " + QdcElevatorBox.platformEditString);
            this.txtPlatform.setValue(QdcElevatorBox.platformEditString);
            switch (pressRes) {
                case BACKSPACE: {
                    this.playClickSound();
                    break;
                }
                case ERROR: {
                    this.playErrorSound();
                    break;
                }
                case ESCAPE: {
                    this.minecraft.player.closeContainer();
                    break;
                }
                case LETTER: {
                    this.playClickSound();
                    break;
                }
                case RETURN: {
                    this.playClickSound();
                    this.handlePlatformNameSave();
                    this.isElevatorEditMode = false;
                    this.setPlatformButtons();
                }
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverButton = this.isHoveringOverButton(x, y);
        this.curMapHoverItem = this.getMapHover(x, y);
        this.curHoverPlatform = this.getPlatformHoverObject(x, y);
        this.drawMapTooltip(GuiGraphics2, x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Quantum Elevator");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawSideWindow(gg);
        this.drawElevatorWindow(gg);
        this.drawPlatformWindow(gg);
        if (this.isMapWindow) {
            this.drawMapWindow(gg);
        }
        this.drawButtons(gg);
    }

    public void drawMapTooltip(GuiGraphics gg, int x, int y) {
        if (this.curMapHoverItem != null) {
            this.MAP_TOOLTIP_POS = new Point(x - this.WINDOW_POS.x - this.MAP_TOOLTIP_SIZE.x, y - this.WINDOW_POS.y + 5);
            this.drawRectangleWithBorder(gg, this.MAP_TOOLTIP_POS, this.MAP_TOOLTIP_SIZE, Color.blue, Color.white);
            this.writeStringCentred(gg, this.curMapHoverItem.tooltip, this.MAP_TOOLTIP_POS.x + this.MAP_TOOLTIP_SIZE.x / 2, this.MAP_TOOLTIP_POS.y + 4, SIDE_WINDOW.TITLE.TEXT_COLOR);
        }
    }

    public void drawSideWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, SIDE_WINDOW.POS, SIDE_WINDOW.SIZE, SIDE_WINDOW.BG_COLOR, SIDE_WINDOW.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, SIDE_WINDOW.TITLE.POS, SIDE_WINDOW.TITLE.SIZE, SIDE_WINDOW.TITLE.BG_COLOR, SIDE_WINDOW.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "Platforms", SIDE_WINDOW.TITLE.TEXT_POS.x, SIDE_WINDOW.TITLE.TEXT_POS.y, SIDE_WINDOW.TITLE.TEXT_COLOR);
        if (this.curSelectedElevator != null) {
            for (QdcElevatorPlatform p : this.curSelectedElevator.platforms) {
                RectangleColorData colorData = this.getPlatformColorData(p);
                this.drawRectangleWithBorder(gg, p.guiData.guiPos, SIDE_WINDOW_ITEM.SIZE, colorData.bg, colorData.border);
                this.writeStringCentred(gg, p.floorString, p.guiData.floorPos.x, p.guiData.floorPos.y, Color.white);
                this.writeStringCentred(gg, p.platformName, p.guiData.namePos.x, p.guiData.namePos.y, Color.white);
            }
        }
    }

    private RectangleColorData getPlatformColorData(QdcElevatorPlatform p) {
        if (this.curHoverPlatform != null) {
            if (p.isSame(this.curHoverPlatform.pos)) {
                if (this.curSelectedPlatform != null) {
                    if (p.isSame(this.curSelectedPlatform.pos)) {
                        return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR_ACTIVE, SIDE_WINDOW_ITEM.BORDER_COLOR_ACTIVE);
                    }
                    return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR_HOVER, SIDE_WINDOW_ITEM.BORDER_COLOR_HOVER);
                }
                return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR_HOVER, SIDE_WINDOW_ITEM.BORDER_COLOR_HOVER);
            }
            if (this.curSelectedPlatform != null) {
                if (p.isSame(this.curSelectedPlatform.pos)) {
                    return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR_ACTIVE, SIDE_WINDOW_ITEM.BORDER_COLOR_ACTIVE);
                }
                return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR, SIDE_WINDOW_ITEM.BORDER_COLOR);
            }
            return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR, SIDE_WINDOW_ITEM.BORDER_COLOR);
        }
        if (this.curSelectedPlatform != null) {
            if (p.isSame(this.curSelectedPlatform.pos)) {
                return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR_ACTIVE, SIDE_WINDOW_ITEM.BORDER_COLOR_ACTIVE);
            }
            return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR, SIDE_WINDOW_ITEM.BORDER_COLOR);
        }
        return new RectangleColorData(SIDE_WINDOW_ITEM.BG_COLOR, SIDE_WINDOW_ITEM.BORDER_COLOR);
    }

    public void drawElevatorWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.POS, ELEVATOR_WINDOW.SIZE, ELEVATOR_WINDOW.BG_COLOR, ELEVATOR_WINDOW.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.TITLE.POS, ELEVATOR_WINDOW.TITLE.SIZE, ELEVATOR_WINDOW.TITLE.BG_COLOR, ELEVATOR_WINDOW.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "Elevator Data", ELEVATOR_WINDOW.TITLE.TEXT_POS.x, ELEVATOR_WINDOW.TITLE.TEXT_POS.y, ELEVATOR_WINDOW.TITLE.TEXT_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.NAME.POS, ELEVATOR_WINDOW.NAME.SIZE, ELEVATOR_WINDOW.NAME.BG_COLOR, ELEVATOR_WINDOW.NAME.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.LOCATION.X.TITLE.POS, ELEVATOR_WINDOW.LOCATION.X.TITLE.SIZE, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.BG_COLOR, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "X:", ELEVATOR_WINDOW.LOCATION.X.TITLE.TEXT_POS.x, ELEVATOR_WINDOW.LOCATION.X.TITLE.TEXT_POS.y, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.TEXT_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.LOCATION.X.TEXT.POS, ELEVATOR_WINDOW.LOCATION.X.TEXT.SIZE, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.BG_COLOR, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.LOCATION.Z.TITLE.POS, ELEVATOR_WINDOW.LOCATION.Z.TITLE.SIZE, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.BG_COLOR, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "Z:", ELEVATOR_WINDOW.LOCATION.Z.TITLE.TEXT_POS.x, ELEVATOR_WINDOW.LOCATION.Z.TITLE.TEXT_POS.y, ELEVATOR_WINDOW.LOCATION.COLOR.TITLE.TEXT_COLOR);
        this.drawRectangleWithBorder(gg, ELEVATOR_WINDOW.LOCATION.Z.TEXT.POS, ELEVATOR_WINDOW.LOCATION.Z.TEXT.SIZE, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.BG_COLOR, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.BORDER_COLOR);
        if (this.curSelectedElevator != null) {
            this.writeStringCentred(gg, this.curSelectedElevator.elevatorName, ELEVATOR_WINDOW.NAME.TEXT_POS.x, ELEVATOR_WINDOW.NAME.TEXT_POS.y, ELEVATOR_WINDOW.NAME.TEXT_COLOR);
            this.writeStringCentred(gg, "" + this.curSelectedElevator.pos.getX(), ELEVATOR_WINDOW.LOCATION.X.TEXT.TEXT_POS.x, ELEVATOR_WINDOW.LOCATION.X.TEXT.TEXT_POS.y, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.TEXT_COLOR);
            this.writeStringCentred(gg, "" + this.curSelectedElevator.pos.getZ(), ELEVATOR_WINDOW.LOCATION.Z.TEXT.TEXT_POS.x, ELEVATOR_WINDOW.LOCATION.Z.TEXT.TEXT_POS.y, ELEVATOR_WINDOW.LOCATION.COLOR.TEXT.TEXT_COLOR);
        }
    }

    private void handleElevatorNameSave() {
        if (this.curSelectedElevator != null && !QdcElevatorBox.elevatorEditString.isBlank()) {
            this.curSelectedElevator.elevatorName = QdcElevatorBox.elevatorEditString;
            this.curSelectedElevator.notifyChildrenOnElevatorNameChange(QdcElevatorBox.elevatorEditString);
            QdcElevatorBox.elevatorEditString = "";
            this.txtElevator.setValue("");
            this.isElevatorEditMode = false;
        }
    }

    private void setElevatorButtons() {
        if (this.isElevatorEditMode) {
            this.btnElevatorRename.isVisible = false;
            this.btnElevatorSave.isVisible = true;
            this.btnElevatorCancel.isVisible = true;
            this.setTextBoxAvailability(this.txtElevator, true);
        } else {
            this.btnElevatorRename.isVisible = true;
            this.btnElevatorSave.isVisible = false;
            this.btnElevatorCancel.isVisible = false;
            this.setTextBoxAvailability(this.txtElevator, false);
        }
    }

    public void drawPlatformWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, PLATFORM_WINDOW.POS, PLATFORM_WINDOW.SIZE, PLATFORM_WINDOW.BG_COLOR, PLATFORM_WINDOW.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, PLATFORM_WINDOW.TITLE.POS, PLATFORM_WINDOW.TITLE.SIZE, PLATFORM_WINDOW.TITLE.BG_COLOR, PLATFORM_WINDOW.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "Platform Data", PLATFORM_WINDOW.TITLE.TEXT_POS.x, PLATFORM_WINDOW.TITLE.TEXT_POS.y, PLATFORM_WINDOW.TITLE.TEXT_COLOR);
        this.drawRectangleWithBorder(gg, PLATFORM_WINDOW.NAME.POS, PLATFORM_WINDOW.NAME.SIZE, PLATFORM_WINDOW.NAME.BG_COLOR, PLATFORM_WINDOW.NAME.BORDER_COLOR);
        this.drawRectangleWithBorder(gg, PLATFORM_WINDOW.LOCATION.Y.TITLE.POS, PLATFORM_WINDOW.LOCATION.Y.TITLE.SIZE, PLATFORM_WINDOW.LOCATION.COLOR.TITLE.BG_COLOR, PLATFORM_WINDOW.LOCATION.COLOR.TITLE.BORDER_COLOR);
        this.writeStringCentred(gg, "Y:", PLATFORM_WINDOW.LOCATION.Y.TITLE.TEXT_POS.x, PLATFORM_WINDOW.LOCATION.Y.TITLE.TEXT_POS.y, PLATFORM_WINDOW.LOCATION.COLOR.TITLE.TEXT_COLOR);
        this.drawRectangleWithBorder(gg, PLATFORM_WINDOW.LOCATION.Y.TEXT.POS, PLATFORM_WINDOW.LOCATION.Y.TEXT.SIZE, PLATFORM_WINDOW.LOCATION.COLOR.TEXT.BG_COLOR, PLATFORM_WINDOW.LOCATION.COLOR.TEXT.BORDER_COLOR);
        if (this.curSelectedPlatform != null) {
            this.writeStringCentred(gg, this.curSelectedPlatform.platformName, PLATFORM_WINDOW.NAME.TEXT_POS.x, PLATFORM_WINDOW.NAME.TEXT_POS.y, PLATFORM_WINDOW.NAME.TEXT_COLOR);
            this.writeStringCentred(gg, "" + this.curSelectedPlatform.pos.getY(), PLATFORM_WINDOW.LOCATION.Y.TEXT.TEXT_POS.x, PLATFORM_WINDOW.LOCATION.Y.TEXT.TEXT_POS.y, PLATFORM_WINDOW.LOCATION.COLOR.TEXT.TEXT_COLOR);
        }
    }

    private void handlePlatformNameSave() {
        if (this.curSelectedPlatform != null && !QdcElevatorBox.platformEditString.isBlank()) {
            this.curSelectedPlatform.platformName = QdcElevatorBox.platformEditString;
            this.curSelectedPlatform.updatePlatformrName(QdcElevatorBox.platformEditString);
            QdcElevatorBox.platformEditString = "";
            this.txtPlatform.setValue("");
            this.isPlatformEditMode = false;
        }
    }

    private void setPlatformButtons() {
        if (this.curSelectedPlatform != null) {
            if (this.isPlatformEditMode) {
                this.btnPlatformRename.isVisible = false;
                this.btnPlatformSave.isVisible = true;
                this.btnPlatformCancel.isVisible = true;
                this.btnPlatformTele.isVisible = false;
                this.setTextBoxAvailability(this.txtPlatform, true);
            } else {
                this.btnPlatformRename.isVisible = true;
                this.btnPlatformSave.isVisible = false;
                this.btnPlatformCancel.isVisible = false;
                if (this.curSelectedPlatform.isAvailable) {
                    this.btnPlatformTele.isVisible = true;
                }
                this.setTextBoxAvailability(this.txtPlatform, false);
            }
        } else {
            this.btnPlatformRename.isVisible = false;
            this.btnPlatformSave.isVisible = false;
            this.btnPlatformCancel.isVisible = false;
            this.btnPlatformTele.isVisible = false;
            this.setTextBoxAvailability(this.txtPlatform, false);
        }
    }

    public void drawMapWindow(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, WORK_WINDOW.POS, WORK_WINDOW.SIZE, WORK_WINDOW.BG_COLOR, WORK_WINDOW.BORDER_COLOR);
        for (QdcElevator e : QdcElevatorBox.elevatorsInRange) {
            RectangleColorData colorData = this.getMapItemColorData(e);
            this.drawRectangleWithBorder(gg, e.mapPos, MAP_ITEM.SIZE, colorData.bg, colorData.border);
        }
    }

    private RectangleColorData getMapItemColorData(QdcElevator elevator) {
        if (this.curMapHoverItem != null) {
            if (elevator.isSameElevatorPos(this.curMapHoverItem.pos)) {
                if (this.curSelectedElevator != null) {
                    if (elevator.isSameElevatorPos(this.curSelectedElevator.pos)) {
                        return new RectangleColorData(MAP_ITEM.BG_COLOR_ACTIVE, MAP_ITEM.BORDER_COLOR_ACTIVE);
                    }
                    return new RectangleColorData(MAP_ITEM.BG_COLOR_HOVER, MAP_ITEM.BORDER_COLOR_HOVER);
                }
                return new RectangleColorData(MAP_ITEM.BG_COLOR_HOVER, MAP_ITEM.BORDER_COLOR_HOVER);
            }
            if (this.curSelectedElevator != null) {
                if (elevator.isSameElevatorPos(this.curSelectedElevator.pos)) {
                    return new RectangleColorData(MAP_ITEM.BG_COLOR_ACTIVE, MAP_ITEM.BORDER_COLOR_ACTIVE);
                }
                return new RectangleColorData(MAP_ITEM.BG_COLOR, MAP_ITEM.BORDER_COLOR);
            }
            return new RectangleColorData(MAP_ITEM.BG_COLOR, MAP_ITEM.BORDER_COLOR);
        }
        if (this.curSelectedElevator != null) {
            if (elevator.isSameElevatorPos(this.curSelectedElevator.pos)) {
                return new RectangleColorData(MAP_ITEM.BG_COLOR_ACTIVE, MAP_ITEM.BORDER_COLOR_ACTIVE);
            }
            return new RectangleColorData(MAP_ITEM.BG_COLOR, MAP_ITEM.BORDER_COLOR);
        }
        return new RectangleColorData(MAP_ITEM.BG_COLOR, MAP_ITEM.BORDER_COLOR);
    }

    private QdcElevator getMapHover(int x, int y) {
        return QdcElevatorBox.getHoverElevator(this.WINDOW_POS, x, y);
    }

    private QdcElevatorPlatform getPlatformHoverObject(int x, int y) {
        if (this.curSelectedElevator == null) {
            return null;
        }
        return this.curSelectedElevator.getHoverPlatform(this.WINDOW_POS, x, y);
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (!button.isVisible) continue;
            if (this.curHoverButton == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + button.size.x / 2, button.pos.y + 2, this.BUTTON_TEXT_COLOR_ACTIVE);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + button.size.x / 2, button.pos.y + 2, this.BUTTON_TEXT_COLOR);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curMapHoverItem != null) {
            this.reset();
            this.curSelectedElevator = this.curMapHoverItem;
            this.playClickSound();
        }
        if (this.curHoverPlatform != null) {
            this.curSelectedPlatform = this.curHoverPlatform;
            this.setPlatformButtons();
            this.playClickSound();
        }
        this.HandleElevatorButtonClick();
        this.HandlePlatformButtonClick();
        return false;
    }

    private void HandleElevatorButtonClick() {
        if (this.curSelectedElevator != null) {
            if (!this.isElevatorEditMode) {
                if (this.curHoverButton == btnType.ELEVATOR_RENAME) {
                    this.isElevatorEditMode = true;
                    this.setElevatorButtons();
                    QdcElevatorBox.elevatorEditString = "";
                    this.txtElevator.setValue("");
                    this.playClickSound();
                }
            } else {
                if (this.isPlatformEditMode) {
                    this.isPlatformEditMode = false;
                    this.setPlatformButtons();
                    QdcElevatorBox.platformEditString = "";
                }
                if (this.curHoverButton == btnType.ELEVATOR_CANCEL) {
                    this.isElevatorEditMode = false;
                    this.setElevatorButtons();
                    QdcElevatorBox.elevatorEditString = "";
                    this.txtElevator.setValue("");
                    this.playClickSound();
                }
                if (this.curHoverButton == btnType.ELEVATOR_SAVE) {
                    this.handleElevatorNameSave();
                    this.isElevatorEditMode = false;
                    this.setElevatorButtons();
                    QdcElevatorBox.elevatorEditString = "";
                    this.txtElevator.setValue("");
                    this.playClickSound();
                }
            }
        }
    }

    private void HandlePlatformButtonClick() {
        if (this.curSelectedPlatform != null) {
            if (!this.isPlatformEditMode) {
                if (this.curHoverButton == btnType.PLATFORM_RENAME) {
                    this.isPlatformEditMode = true;
                    this.setPlatformButtons();
                    QdcElevatorBox.platformEditString = "";
                    this.txtPlatform.setValue("");
                    this.playClickSound();
                }
                if (this.curHoverButton == btnType.PLATFORM_TELE) {
                    this.handleTeleportClick();
                    this.playClickSound();
                    this.minecraft.player.closeContainer();
                }
            } else {
                if (this.isElevatorEditMode) {
                    this.isElevatorEditMode = false;
                    this.setElevatorButtons();
                    QdcElevatorBox.elevatorEditString = "";
                }
                if (this.curHoverButton == btnType.PLATFORM_CANCEL) {
                    this.isPlatformEditMode = false;
                    this.setPlatformButtons();
                    QdcElevatorBox.platformEditString = "";
                    this.txtPlatform.setValue("");
                    this.playClickSound();
                }
                if (this.curHoverButton == btnType.PLATFORM_SAVE) {
                    this.handlePlatformNameSave();
                    this.isPlatformEditMode = false;
                    this.setPlatformButtons();
                    QdcElevatorBox.platformEditString = "";
                    this.txtPlatform.setValue("");
                    this.playClickSound();
                }
            }
        }
    }

    private void handleTeleportClick() {
        QdcElevatorBox.handleTeleportClick(this.curSelectedPlatform);
    }

    private void playClickSound() {
        GuiSoundFunctions.playClickSound(this.player);
    }

    private void playDiscoverySound() {
        this.player.playSound(SoundEvents.BELL_BLOCK, 0.5f, 1.0f);
    }

    private void playErrorSound() {
        GuiSoundFunctions.playErrorSound(this.player);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;
        public boolean isVisible = false;

        public GuiButton(ElevatorScreen this$0, Point pos, Point size, String text, btnType type, boolean isVisible) {
            super(pos, size, text);
            this.type = type;
            this.isVisible = isVisible;
        }
    }

    public static enum btnType {
        ELEVATOR_RENAME,
        ELEVATOR_SAVE,
        ELEVATOR_CANCEL,
        PLATFORM_RENAME,
        PLATFORM_SAVE,
        PLATFORM_CANCEL,
        PLATFORM_TELE;

    }

    private class SIDE_WINDOW {
        public static final Point POS = ElevatorSettings.SIDE_WINDOW.POS;
        public static final Point SIZE = ElevatorSettings.SIDE_WINDOW.SIZE;
        public static final Color BG_COLOR = ElevatorSettings.SIDE_WINDOW.BG_COLOR;
        public static final Color BORDER_COLOR = ElevatorSettings.SIDE_WINDOW.BORDER_COLOR;

        private SIDE_WINDOW(ElevatorScreen elevatorScreen) {
        }

        public class TITLE {
            public static final Point SIZE = ElevatorSettings.SIDE_WINDOW.TITLE.SIZE;
            public static final Point POS = ElevatorSettings.SIDE_WINDOW.TITLE.POS;
            public static final Point TEXT_POS = ElevatorSettings.SIDE_WINDOW.TITLE.TEXT_POS;
            public static final Color BG_COLOR = ElevatorSettings.SIDE_WINDOW.TITLE.BG_COLOR;
            public static final Color BORDER_COLOR = ElevatorSettings.SIDE_WINDOW.TITLE.BORDER_COLOR;
            public static final Color TEXT_COLOR = ElevatorSettings.SIDE_WINDOW.TITLE.TEXT_COLOR;
            public static final String TEXT = "Platforms";

            public TITLE(SIDE_WINDOW this$1) {
            }
        }
    }

    private class SIDE_WINDOW_ITEM {
        public static final Point SIZE = ElevatorSettings.SIDE_WINDOW.ITEM.SIZE;
        public static final Color BG_COLOR = ElevatorSettings.SIDE_WINDOW.ITEM.BG_COLOR;
        public static final Color BG_COLOR_HOVER = ElevatorSettings.SIDE_WINDOW.ITEM.BG_COLOR_HOVER;
        public static final Color BG_COLOR_ACTIVE = ElevatorSettings.SIDE_WINDOW.ITEM.BG_COLOR_ACTIVE;
        public static final Color BORDER_COLOR = ElevatorSettings.SIDE_WINDOW.ITEM.BORDER_COLOR;
        public static final Color BORDER_COLOR_HOVER = ElevatorSettings.SIDE_WINDOW.ITEM.BORDER_COLOR_HOVER;
        public static final Color BORDER_COLOR_ACTIVE = ElevatorSettings.SIDE_WINDOW.ITEM.BORDER_COLOR_ACTIVE;

        private SIDE_WINDOW_ITEM(ElevatorScreen elevatorScreen) {
        }
    }

    private class ELEVATOR_WINDOW {
        public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.SIZE;
        public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.POS;
        public static final Color BG_COLOR = ElevatorSettings.ELEVATOR_WINDOW.BG_COLOR;
        public static final Color BORDER_COLOR = ElevatorSettings.ELEVATOR_WINDOW.BORDER_COLOR;

        private ELEVATOR_WINDOW(ElevatorScreen elevatorScreen) {
        }

        public class LOCATION {
            public LOCATION(ELEVATOR_WINDOW this$1) {
            }

            public class Z {
                public Z(LOCATION this$2) {
                }

                public class TEXT {
                    public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TEXT.SIZE;
                    public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TEXT.POS;
                    public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TEXT.TEXT_POS;

                    public TEXT(Z this$3) {
                    }
                }

                public class TITLE {
                    public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TITLE.SIZE;
                    public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TITLE.POS;
                    public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.Z.TITLE.TEXT_POS;
                    public static final String TEXT = "Z:";

                    public TITLE(Z this$3) {
                    }
                }
            }

            public class X {
                public X(LOCATION this$2) {
                }

                public class TEXT {
                    public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TEXT.SIZE;
                    public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TEXT.POS;
                    public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TEXT.TEXT_POS;

                    public TEXT(X this$3) {
                    }
                }

                public class TITLE {
                    public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TITLE.SIZE;
                    public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TITLE.POS;
                    public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.X.TITLE.TEXT_POS;
                    public static final String TEXT = "X:";

                    public TITLE(X this$3) {
                    }
                }
            }

            public class COLOR {
                public COLOR(LOCATION this$2) {
                }

                public class TEXT {
                    public static final Color BG_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TEXT.BG_COLOR;
                    public static final Color BORDER_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TEXT.BORDER_COLOR;
                    public static final Color TEXT_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TEXT.TEXT_COLOR;

                    public TEXT(COLOR this$3) {
                    }
                }

                public class TITLE {
                    public static final Color BG_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TITLE.BG_COLOR;
                    public static final Color BORDER_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TITLE.BORDER_COLOR;
                    public static final Color TEXT_COLOR = ElevatorSettings.ELEVATOR_WINDOW.LOCATION.COLORS.TITLE.TEXT_COLOR;

                    public TITLE(COLOR this$3) {
                    }
                }
            }
        }

        public class NAME {
            public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.NAME.SIZE;
            public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.NAME.POS;
            public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.NAME.TEXT_POS;
            public static final Color BG_COLOR = ElevatorSettings.ELEVATOR_WINDOW.NAME.BG_COLOR;
            public static final Color BORDER_COLOR = ElevatorSettings.ELEVATOR_WINDOW.NAME.BORDER_COLOR;
            public static final Color TEXT_COLOR = ElevatorSettings.ELEVATOR_WINDOW.NAME.TEXT_COLOR;

            public NAME(ELEVATOR_WINDOW this$1) {
            }
        }

        public class TITLE {
            public static final Point SIZE = ElevatorSettings.ELEVATOR_WINDOW.TITLE.SIZE;
            public static final Point POS = ElevatorSettings.ELEVATOR_WINDOW.TITLE.POS;
            public static final Point TEXT_POS = ElevatorSettings.ELEVATOR_WINDOW.TITLE.TEXT_POS;
            public static final Color BG_COLOR = ElevatorSettings.ELEVATOR_WINDOW.TITLE.BG_COLOR;
            public static final Color BORDER_COLOR = ElevatorSettings.ELEVATOR_WINDOW.TITLE.BORDER_COLOR;
            public static final Color TEXT_COLOR = ElevatorSettings.ELEVATOR_WINDOW.TITLE.TEXT_COLOR;
            public static final String TEXT = "Elevator Data";

            public TITLE(ELEVATOR_WINDOW this$1) {
            }
        }
    }

    private class PLATFORM_WINDOW {
        public static final Point SIZE = ElevatorSettings.PLATFORM_WINDOW.SIZE;
        public static final Point POS = ElevatorSettings.PLATFORM_WINDOW.POS;
        public static final Color BG_COLOR = ElevatorSettings.PLATFORM_WINDOW.BG_COLOR;
        public static final Color BORDER_COLOR = ElevatorSettings.PLATFORM_WINDOW.BORDER_COLOR;

        private PLATFORM_WINDOW(ElevatorScreen elevatorScreen) {
        }

        public class LOCATION {
            public LOCATION(PLATFORM_WINDOW this$1) {
            }

            public class Y {
                public Y(LOCATION this$2) {
                }

                public class TEXT {
                    public static final Point SIZE = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TEXT.SIZE;
                    public static final Point POS = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TEXT.POS;
                    public static final Point TEXT_POS = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TEXT.TEXT_POS;

                    public TEXT(Y this$3) {
                    }
                }

                public class TITLE {
                    public static final Point SIZE = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TITLE.SIZE;
                    public static final Point POS = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TITLE.POS;
                    public static final Point TEXT_POS = ElevatorSettings.PLATFORM_WINDOW.LOCATION.Y.TITLE.TEXT_POS;
                    public static final String TEXT = "Y:";

                    public TITLE(Y this$3) {
                    }
                }
            }

            public class COLOR {
                public COLOR(LOCATION this$2) {
                }

                public class TEXT {
                    public static final Color BG_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TEXT.BG_COLOR;
                    public static final Color BORDER_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TEXT.BORDER_COLOR;
                    public static final Color TEXT_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TEXT.TEXT_COLOR;

                    public TEXT(COLOR this$3) {
                    }
                }

                public class TITLE {
                    public static final Color BG_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TITLE.BG_COLOR;
                    public static final Color BORDER_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TITLE.BORDER_COLOR;
                    public static final Color TEXT_COLOR = ElevatorSettings.PLATFORM_WINDOW.LOCATION.COLORS.TITLE.TEXT_COLOR;

                    public TITLE(COLOR this$3) {
                    }
                }
            }
        }

        public class NAME {
            public static final Point SIZE = ElevatorSettings.PLATFORM_WINDOW.NAME.SIZE;
            public static final Point POS = ElevatorSettings.PLATFORM_WINDOW.NAME.POS;
            public static final Point TEXT_POS = ElevatorSettings.PLATFORM_WINDOW.NAME.TEXT_POS;
            public static final Color BG_COLOR = ElevatorSettings.PLATFORM_WINDOW.NAME.BG_COLOR;
            public static final Color BORDER_COLOR = ElevatorSettings.PLATFORM_WINDOW.NAME.BORDER_COLOR;
            public static final Color TEXT_COLOR = ElevatorSettings.PLATFORM_WINDOW.NAME.TEXT_COLOR;

            public NAME(PLATFORM_WINDOW this$1) {
            }
        }

        public class TITLE {
            public static final Point SIZE = ElevatorSettings.PLATFORM_WINDOW.TITLE.SIZE;
            public static final Point POS = ElevatorSettings.PLATFORM_WINDOW.TITLE.POS;
            public static final Point TEXT_POS = ElevatorSettings.PLATFORM_WINDOW.TITLE.TEXT_POS;
            public static final Color BG_COLOR = ElevatorSettings.PLATFORM_WINDOW.TITLE.BG_COLOR;
            public static final Color BORDER_COLOR = ElevatorSettings.PLATFORM_WINDOW.TITLE.BORDER_COLOR;
            public static final Color TEXT_COLOR = ElevatorSettings.PLATFORM_WINDOW.TITLE.TEXT_COLOR;
            public static final String TEXT = "Platform Data";

            public TITLE(PLATFORM_WINDOW this$1) {
            }
        }
    }

    private class WORK_WINDOW {
        public static final Point POS = ElevatorSettings.WORK_WINDOW.POS;
        public static final Point SIZE = ElevatorSettings.WORK_WINDOW.SIZE;
        public static final Color BG_COLOR = ElevatorSettings.WORK_WINDOW.BG_COLOR;
        public static final Color BORDER_COLOR = ElevatorSettings.WORK_WINDOW.BORDER_COLOR;

        private WORK_WINDOW(ElevatorScreen elevatorScreen) {
        }
    }

    private class MAP_ITEM {
        public static final Point SIZE = ElevatorSettings.WORK_WINDOW.MAP.ITEM.SIZE;
        public static final Color BG_COLOR = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BG_COLOR;
        public static final Color BG_COLOR_HOVER = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BG_COLOR_HOVER;
        public static final Color BG_COLOR_ACTIVE = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BG_COLOR_ACTIVE;
        public static final Color BORDER_COLOR = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BORDER_COLOR;
        public static final Color BORDER_COLOR_HOVER = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BORDER_COLOR_HOVER;
        public static final Color BORDER_COLOR_ACTIVE = ElevatorSettings.WORK_WINDOW.MAP.ITEM.BORDER_COLOR_ACTIVE;

        private MAP_ITEM(ElevatorScreen elevatorScreen) {
        }
    }
}

