/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4;

import com.mojang.logging.LogUtils;
import com.qdc_mod.qdc_core_4.Config;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.AssemblerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.ConverterScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.DisassemblerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.MainMenuScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.RecyclerScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.ResearchMissionBaseScreen;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen.RevelationScreen;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.MenuInit;
import com.qdc_mod.qdc_core_4.qdc_core.functions.BlockBreakFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ManaFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.MobKillFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ModRegistry;
import com.qdc_mod.qdc_core_4.qdc_core.functions.PlayerLoadingFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.TimeFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ToolTipFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.network.ClientPayloadHandler;
import com.qdc_mod.qdc_core_4.qdc_core.network.ServerPayloadHandler;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="qdc_core_4")
public class Qdc {
    public static final String MOD_ID = "qdc_core_4";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Player curPlayer = null;
    public static ServerPlayer serverPlayer = null;

    public Qdc(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModRegistry.registerItems(modEventBus);
        ModRegistry.registerBlocks(modEventBus);
        ModRegistry.registerCreativeTabs(modEventBus);
        ModRegistry.registerMenus(modEventBus);
        ModRegistry.registerAttachments(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.PlayerLoggedInEvent event) {
        curPlayer = event.getEntity();
        PlayerLoadingFunctions.onPlayerLoad(event);
        MainBox.loadModData(curPlayer);
    }

    @SubscribeEvent
    public void onPlayerClose(PlayerEvent.PlayerLoggedOutEvent event) {
        MainBox.clearModData();
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        MainBox.saveData(curPlayer);
    }

    @SubscribeEvent
    public void onRenderToolTip(ItemTooltipEvent event) {
        ToolTipFunctions.addParticleToolTipToItem(event);
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post event) {
        ManaFunctions.increase();
        TimeFunctions.updateTimeSegs();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockBreakFunctions.handleBlockBreak(event);
    }

    @SubscribeEvent
    public void onMobKill(LivingDeathEvent event) {
        MobKillFunctions.handleMobKIll(event);
    }

    @EventBusSubscriber(modid="qdc_core_4", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playBidirectional(myData.MyData.TYPE, myData.MyData.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleDataOnMain, ServerPayloadHandler::handleDataOnMain));
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)MenuInit.MAIN_ITEM_MENU.get(), MainMenuScreen::new);
            event.register((MenuType)MenuInit.DISASSEMBLER_MENU.get(), DisassemblerScreen::new);
            event.register((MenuType)MenuInit.ASSEMBLER_MENU.get(), AssemblerScreen::new);
            event.register((MenuType)MenuInit.CONVERTER_MENU.get(), ConverterScreen::new);
            event.register((MenuType)MenuInit.RESEARCH_MISSION_BASE_MENU.get(), ResearchMissionBaseScreen::new);
            event.register((MenuType)MenuInit.RECYCLER_MENU.get(), RecyclerScreen::new);
            event.register((MenuType)MenuInit.REVELATION_MENU.get(), RevelationScreen::new);
        }
    }

    public class DisassemblerVariables {
        public static final int ITEM_LIMIT = 16;
        public static List<Item> discoveredItems = new ArrayList<Item>();

        public DisassemblerVariables(Qdc this$0) {
        }

        public static void addNewDIscoveredItem(Item item) {
            discoveredItems.add(item);
        }

        public static List<Item> getDiscoveredItems() {
            int extra;
            ArrayList<Item> res = new ArrayList<Item>();
            if (discoveredItems.size() <= 16) {
                return discoveredItems;
            }
            int count = discoveredItems.size();
            for (int i = extra = count - 16; i < discoveredItems.size(); ++i) {
                res.add(discoveredItems.get(i));
            }
            return res;
        }
    }

    public class AssemblerVariables {
        public static String searchString = "";

        public AssemblerVariables(Qdc this$0) {
        }
    }

    public class ConverterVariables {
        public static final int CONVERSION_RATE = 20;

        public ConverterVariables(Qdc this$0) {
        }
    }

    public class RandomDropStuffs {
        public static final int MAX_BLOCK_BREAK_COUNT = 10;
        public static final int MAX_MOB_KILL_COUNT = 1;

        public RandomDropStuffs(Qdc this$0) {
        }
    }

    public class ManaStuff {
        public static final int START_MAX_MANA = 100;
        public static final double MANA_REGEN_AMOUNT = 0.05;

        public ManaStuff(Qdc this$0) {
        }
    }

    public class CorruptionStuff {
        public static final double MAX = 250.0;
        public static final double MIN = 5.0;
        public static final double RECALIBRATION_COST = 10.0;

        public CorruptionStuff(Qdc this$0) {
        }

        public class exchangeRate {
            public static final double NATURE = 0.5;
            public static final double FOOD = 1.0;
            public static final double METAL = 2.5;
            public static final double GEM = 10.0;

            public exchangeRate(CorruptionStuff this$1) {
            }
        }
    }

    public class RevelationStuff {
        public static long maxTime = 600000L;
        public static long revelationStart = -1L;
        public static boolean isRevelationReady = false;
        public static int[] timeSegs = null;

        public RevelationStuff(Qdc this$0) {
        }

        public class ParticleRewards {
            public ParticleRewards(RevelationStuff this$1) {
            }

            public class MANA_MAX {
                public static final int FIXED = 2;
                public static final int RANDOM = 5;

                public MANA_MAX(ParticleRewards this$2) {
                }
            }

            public class MANA {
                public static final int FIXED = 5;
                public static final int RANDOM = 15;

                public MANA(ParticleRewards this$2) {
                }
            }

            public class CORRUPTION {
                public static final int FIXED = 4;
                public static final int RANDOM = 6;

                public CORRUPTION(ParticleRewards this$2) {
                }
            }

            public class GEM {
                public static final int FIXED = 1;
                public static final int RANDOM = 3;

                public GEM(ParticleRewards this$2) {
                }
            }

            public class METAL {
                public static final int FIXED = 5;
                public static final int RANDOM = 5;

                public METAL(ParticleRewards this$2) {
                }
            }

            public class FOOD {
                public static final int FIXED = 5;
                public static final int RANDOM = 10;

                public FOOD(ParticleRewards this$2) {
                }
            }

            public class NATURE {
                public static final int FIXED = 25;
                public static final int RANDOM = 100;

                public NATURE(ParticleRewards this$2) {
                }
            }
        }
    }
}

