/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.CorruptionRecyclerStorage;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.ModItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemBox {
    public List<ModItem> itemList = new ArrayList<ModItem>();
    public List<Item> modItemList = this.generateModItemList();
    public List<Item> discoveredItemList = new ArrayList<Item>();
    public List<Item> undiscoveredItemList = new ArrayList<Item>();
    public CorruptionRecyclerStorage recyclerStorage = new CorruptionRecyclerStorage();

    public int getItemCorruptionAmount(Item item) {
        int index = this.getIndex(item);
        if (index > -1) {
            return this.itemList.get((int)index).corruptionAmount;
        }
        return -1;
    }

    public List<Item> getAllUndiscoveredItems() {
        this.setItemList();
        ArrayList<Item> res = new ArrayList<Item>();
        for (Item item : this.undiscoveredItemList) {
            res.add(item);
        }
        return res;
    }

    public void setItemList() {
        this.discoveredItemList = new ArrayList<Item>();
        this.undiscoveredItemList = new ArrayList<Item>();
        for (ModItem item : this.itemList) {
            if (this.modItemList.contains(item.item)) continue;
            if (QdcApi.QDC_CORE.FUNCTIONS.isItemDiscovered(item.item)) {
                this.discoveredItemList.add(item.item);
                continue;
            }
            this.undiscoveredItemList.add(item.item);
        }
    }

    public void handleItemDiscoveryLists(Item item) {
        this.undiscoveredItemList.remove(item);
        this.discoveredItemList.add(item);
    }

    private List<Item> generateModItemList() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_CORE);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_RECIEVER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_TRANSMITTER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_CORE);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_KNOWLEDGE);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_RECIEVER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_TRANSMITTER);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.MANA);
        return res;
    }

    public boolean shouldKeepMana(Item item) {
        for (Item i : this.modItemList) {
            if (item != i) continue;
            return true;
        }
        return false;
    }

    public void sortItemCollections() {
        for (ModItem item : this.itemList) {
            item.particles.sortParticleItems();
        }
    }

    public void updateItemParticleCollection(Item item, ParticleCollection pc) {
        int index = this.getIndex(item);
        if (index > -1) {
            this.itemList.get((int)index).particles = new ParticleCollection();
            for (ParticleItem pi : pc.particleList) {
                this.itemList.get((int)index).particles.add(pi);
            }
            this.itemList.get(index).calcCorruptionAmount();
        }
    }

    public void add(ModItem item) {
        if (this.getIndex(item.name) > -1) {
            GlobalFuncs.msg("duplicate: " + item.name);
        } else {
            this.itemList.add(item);
        }
    }

    public boolean allowItemDisassemble(Item item) {
        return this.getItemParticles(new ItemStack((ItemLike)item)) != null;
    }

    public void setDiscovered(Item item) {
        String name = ((Item)item.builtInRegistryHolder().value()).toString();
        int index = this.getIndex(name);
        if (index > -1) {
            this.itemList.get(index).setToDiscovered();
            this.handleItemDiscoveryLists(item);
        }
    }

    public ParticleCollection getItemParticles(ItemStack is) {
        int index = -1;
        if (!is.isEmpty()) {
            index = this.getIndex(((Item)is.getItem().builtInRegistryHolder().value()).toString());
            if (index > -1) {
                if (this.itemList.get((int)index).allowDisassemble) {
                    return this.itemList.get((int)index).particles;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public int getIndex(Item item) {
        return this.getIndex(((Item)item.builtInRegistryHolder().value()).toString());
    }

    public int getIndex(String name) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (!this.itemList.get((int)i).name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void saveData(Player player) {
        this.recyclerStorage.saveData(player);
    }

    public void loadData(Player player) {
        this.recyclerStorage.loadData(player);
    }
}

