/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.items_init_classes;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.items_init_classes.ItemIngredients;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeFunctions {
    public List<Item> baseItems = null;
    public List<ItemIngredients> craftableItems = null;
    public List<RecipeHolder<CraftingRecipe>> allRecipes = null;
    public List<Item> itemsMissingParticles = new ArrayList<Item>();

    public RecipeFunctions(Level level) {
        this.baseItems = new ArrayList<Item>();
        this.craftableItems = new ArrayList<ItemIngredients>();
        this.allRecipes = level.getServer().getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
        this.itemsMissingParticles = new ArrayList<Item>();
        this.loadAllRecipeItems(level);
        this.getAllBaseItems();
        this.checkAllRecipesForReverseRecipe(level);
    }

    public void calcAllParticlesForAllRecipe() {
        this.itemsMissingParticles = new ArrayList<Item>();
        for (ItemIngredients ig : this.craftableItems) {
            if (!ig.hasMissingParticles()) continue;
            for (Item item : ig.items) {
                ParticleCollection pc = MainBox.ITEM_BOX.getItemParticles(new ItemStack((ItemLike)item));
                if (pc == null) {
                    this.itemsMissingParticles.add(item);
                    continue;
                }
                ig.updateParticles(pc, item);
            }
            if (ig.hasMissingParticles()) continue;
            ig.calculateTotalParticles();
            MainBox.ITEM_BOX.updateItemParticleCollection(ig.resultItem, ig.calculateTotalParticles());
        }
    }

    private void loadAllRecipeItems(Level level) {
        ItemStack resultItem = null;
        for (RecipeHolder<CraftingRecipe> cr : this.allRecipes) {
            resultItem = ((CraftingRecipe)cr.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (resultItem.getItem().getCreatorModId(resultItem) != "minecraft" || this.isItemInCraftableList(resultItem.getItem())) continue;
            ItemIngredients ings = new ItemIngredients(resultItem.getItem(), resultItem.getCount());
            for (Ingredient ing : ((CraftingRecipe)cr.value()).getIngredients()) {
                if (ing.getItems().length <= 0) continue;
                ings.addIngredient(ing.getItems()[0].getItem());
            }
            this.craftableItems.add(ings);
        }
    }

    public void checkAllRecipesForReverseRecipe(Level level) {
        for (RecipeHolder<CraftingRecipe> cr : this.allRecipes) {
            this.checkForReverseRecipe(level, cr);
        }
    }

    public void checkForReverseRecipe(Level level, RecipeHolder<CraftingRecipe> cr2) {
        ItemStack otherRecipeResult = ((CraftingRecipe)cr2.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
        if (otherRecipeResult.getCount() == 1 && this.areIngredientAllSameItem(cr2)) {
            Item otherRecipeIngredient = this.extractMainIngredientFromRecipe(level, cr2);
            int otherRecipeIngredientCount = this.getIngredientCount(level, cr2);
            for (RecipeHolder<CraftingRecipe> cr : this.allRecipes) {
                if (!this.isItemSameAsRecipeResult(level, cr, otherRecipeIngredient, otherRecipeIngredientCount) || this.isItemInBaseItemList(otherRecipeIngredient)) continue;
                this.baseItems.add(otherRecipeIngredient);
            }
        }
    }

    private int getIngredientCount(Level level, RecipeHolder<CraftingRecipe> cr) {
        int counter = 0;
        for (Ingredient ing : ((CraftingRecipe)cr.value()).getIngredients()) {
            if (ing.getItems().length <= 0) continue;
            ++counter;
        }
        return counter;
    }

    private Item extractMainIngredientFromRecipe(Level level, RecipeHolder<CraftingRecipe> cr) {
        for (Ingredient ing : ((CraftingRecipe)cr.value()).getIngredients()) {
            if (ing.getItems().length <= 0) continue;
            return ing.getItems()[0].getItem();
        }
        return null;
    }

    private boolean isItemSameAsRecipeResult(Level level, RecipeHolder<CraftingRecipe> cr, Item item, int ingredientCount) {
        return ((CraftingRecipe)cr.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() == item && ((CraftingRecipe)cr.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getCount() == ingredientCount;
    }

    private boolean areIngredientAllSameItem(RecipeHolder<CraftingRecipe> recipe) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Ingredient ing : ((CraftingRecipe)recipe.value()).getIngredients()) {
            if (ing.getItems().length <= 0) continue;
            items.add(ing.getItems()[0].getItem());
        }
        return this.areAllItemsInlistSame(items);
    }

    private boolean areAllItemsInlistSame(List<Item> items) {
        if (items.size() == 1) {
            return false;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i) == items.get(0)) continue;
            return false;
        }
        return true;
    }

    public void getAllBaseItems() {
        for (Item i : BuiltInRegistries.ITEM) {
            if (!this.isBaseItem(i)) continue;
            this.baseItems.add(i);
        }
    }

    public boolean isBaseItem(Item item) {
        return this.getIndexOfResultItem(item) == -1;
    }

    private boolean isItemInBaseItemList(Item item) {
        for (Item i : this.baseItems) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    public boolean isItemInCraftableList(Item item) {
        return this.getIndexOfResultItem(item) > -1;
    }

    private int getIndexOfResultItem(Item item) {
        for (int i = 0; i < this.craftableItems.size(); ++i) {
            if (!this.craftableItems.get(i).isResultItem(item)) continue;
            return i;
        }
        return -1;
    }
}

