/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes;

import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiDrawFunctions {
    private static final ResourceLocation BG_GRAY = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/gray.png");
    private static final ResourceLocation BG_WHITE = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/white.png");
    private static final ResourceLocation BG_BLACK = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/black.png");
    private static final ResourceLocation BG_BLUE = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/blue.png");
    private static final ResourceLocation BG_GREEN = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/green.png");
    private static final ResourceLocation BG_RED = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/red.png");
    private static final ResourceLocation BG_YELLOW = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/yellow.png");
    private static final ResourceLocation BG_PURPLE = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/purple.png");
    private static final ResourceLocation BG_ORANGE = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/orange.png");
    private static final ResourceLocation BG_PURPLE_1 = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/purple_1.png");
    private static final ResourceLocation BG_PURPLE_2 = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/purple_2.png");
    private static final ResourceLocation BG_PURPLE_3 = ResourceLocation.fromNamespaceAndPath((String)"qdc_core_4", (String)"textures/gui/bg/purple_3.png");
    private static final ResourceLocation BTN_FILL = BG_PURPLE_1;
    private static final ResourceLocation BTN_BORDER = BG_ORANGE;
    private static final ResourceLocation BTN_BORDER_ACTIVE = BG_RED;
    private static final ResourceLocation TITLE_FILL = BG_ORANGE;
    private static final ResourceLocation TITLE_BORDER = BG_WHITE;
    private static final Color TITLE_TEXT_COLOR = Color.white;

    public static void drawRectangleWithBorder(GuiGraphics gg, Point windowPos, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangle(gg, windowPos, pos.x, pos.y, size.x, size.y, borderColor);
        GuiDrawFunctions.drawRectangle(gg, windowPos, pos.x + 1, pos.y + 1, size.x - 2, size.y - 2, fillColor);
    }

    public static void drawRectangle(GuiGraphics gg, Point windowPos, int xPos, int yPos, int width, int height, Color color) {
        gg.blit(GuiDrawFunctions.getImageFromColor(color), windowPos.x + xPos, windowPos.y + yPos, 0.0f, 0.0f, width, height, 1024, 512);
    }

    public static void drawButton(GuiGraphics gg, Point windowPos, Point pos, Point size, boolean isActive) {
        if (isActive) {
            gg.blit(BTN_BORDER_ACTIVE, windowPos.x + pos.x, windowPos.y + pos.y, 0.0f, 0.0f, size.x, size.y, 1024, 512);
        } else {
            gg.blit(BTN_BORDER, windowPos.x + pos.x, windowPos.y + pos.y, 0.0f, 0.0f, size.x, size.y, 1024, 512);
        }
        gg.blit(BTN_FILL, windowPos.x + pos.x + 1, windowPos.y + pos.y + 1, 0.0f, 0.0f, size.x - 2, size.y - 2, 1024, 512);
    }

    public static void drawWindowTitle(GuiGraphics gg, Point windowPos, Point pos, Point size, Font font, String text) {
        gg.blit(TITLE_BORDER, windowPos.x + pos.x, windowPos.y + pos.y, 0.0f, 0.0f, size.x, size.y, 1024, 512);
        gg.blit(TITLE_FILL, windowPos.x + pos.x + 1, windowPos.y + pos.y + 1, 0.0f, 0.0f, size.x - 2, size.y - 2, 1024, 512);
        GuiDrawFunctions.writeString(gg, font, windowPos, text, pos.x + 3, pos.y + 3, TITLE_TEXT_COLOR);
    }

    public static void drawItemIcon(GuiGraphics gg, Font font, Point windowPos, Item item, int x, int y) {
        gg.renderItem(new ItemStack((ItemLike)item), windowPos.x + x, windowPos.y + y, 3);
    }

    public static void drawItemIcon(GuiGraphics gg, Font font, Point windowPos, Item item, int x, int y, int count) {
        gg.renderItem(new ItemStack((ItemLike)item), windowPos.x + x, windowPos.y + y, 3);
        gg.renderItemDecorations(font, new ItemStack((ItemLike)item, count), windowPos.x + x, windowPos.y + y, "" + count);
    }

    public static void writeStringCentred(GuiGraphics gg, Font font, Point windowPos, String text, int x, int y, Color color) {
        gg.drawCenteredString(font, text, windowPos.x + x, windowPos.y + y, color.getRGB());
    }

    public static void writeString(GuiGraphics gg, Font font, Point windowPos, String text, int x, int y, Color color) {
        gg.drawString(font, text, windowPos.x + x, windowPos.y + y, color.getRGB(), false);
    }

    private static ResourceLocation getImageFromColor(Color color) {
        if (color == Color.gray || color == Color.GRAY) {
            return BG_GRAY;
        }
        if (color == Color.white || color == Color.WHITE) {
            return BG_WHITE;
        }
        if (color == Color.black || color == Color.BLACK) {
            return BG_BLACK;
        }
        if (color == Color.blue || color == Color.BLUE) {
            return BG_BLUE;
        }
        if (color == Color.green || color == Color.GREEN) {
            return BG_GREEN;
        }
        if (color == Color.red || color == Color.RED) {
            return BG_RED;
        }
        if (color == Color.yellow || color == Color.YELLOW) {
            return BG_YELLOW;
        }
        if (color == Color.pink || color == Color.PINK) {
            return BG_PURPLE;
        }
        if (color == Color.orange || color == Color.ORANGE) {
            return BG_ORANGE;
        }
        return BG_BLACK;
    }
}

