/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Point;
import net.minecraft.world.item.Item;

public class AssemblerItem {
    public ParticleCollection particles = null;
    public Item item = null;
    public String name = "";
    public Point pos;
    public boolean isHoveringOver;
    public boolean isDiscovered = false;
    public int storage = 0;
    public boolean isInStorage = false;

    public AssemblerItem(Item item, Point pos) {
        this.name = GlobalFuncs.getItemName(item);
        this.item = item;
        this.pos = pos;
        this.update();
    }

    public void update() {
        this.checkIfDiscovered();
        this.getParticles();
        this.checkIfCanCreate();
        this.updateStorageCount();
    }

    public void checkIfCanCreate() {
        for (ParticleItem pi : this.particles.particleList) {
            pi.checkCanCreate();
        }
    }

    public void updateStorageCount() {
        this.storage = QdcApi.QDC_CORE.FUNCTIONS.getItemStorageCount(this.item);
        this.isInStorage = this.storage > 0;
    }

    private void getParticles() {
        this.particles = QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(this.item);
    }

    private void checkIfDiscovered() {
        this.isDiscovered = QdcApi.QDC_CORE.FUNCTIONS.isItemDiscovered(this.item);
    }

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }
}

