/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions;

import com.qdc_mod.qdc_core_4.qdc_tool.functions.QuantumToolFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantmentFunctions {
    private static final RandomSource random = RandomSource.create();

    private static List<EnchantmentInstance> getEnchantmentList(RegistryAccess registryAccess, ItemStack stack, int slot, int cost) {
        Optional optional = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        List list = EnchantmentHelper.selectEnchantment((RandomSource)random, (ItemStack)stack, (int)cost, (Stream)((HolderSet.Named)optional.get()).stream());
        return list;
    }

    public static List<EnchantmentInstance> getEnchantmentsForItem(Level level, ItemStack stack, int slot, int cost) {
        if (level == null) {
            return null;
        }
        ItemStack curStack = stack.copy();
        if (QuantumToolFunctions.getItemTier(curStack) != null && QuantumToolFunctions.getItemType(curStack) != null) {
            QuantumToolFunctions.itemType type = QuantumToolFunctions.getItemType(curStack);
            QuantumToolFunctions.itemTier tier = QuantumToolFunctions.getItemTier(curStack);
            curStack = new ItemStack((ItemLike)QuantumToolFunctions.getItemForEnchant(type, tier));
        }
        List<EnchantmentInstance> list = EnchantmentFunctions.getEnchantmentList(level.registryAccess(), curStack, slot, cost);
        ArrayList<EnchantmentInstance> res = new ArrayList<EnchantmentInstance>();
        int counter = 0;
        for (EnchantmentInstance ei : list) {
            if (counter < 3) {
                res.add(ei);
            }
            ++counter;
        }
        return res;
    }

    public static double calcEnchantCost(List<EnchantmentInstance> enchantList) {
        if (enchantList == null) {
            return 0.0;
        }
        double cost = 0.0;
        for (EnchantmentInstance ei : enchantList) {
            cost += (double)ei.level() * 2000.0;
        }
        return cost;
    }
}

