/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.api;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.ItemInit;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ParticleFunctions;
import java.awt.Color;
import java.math.BigDecimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class QdcApi {

    public class QDC_CORE {
        public QDC_CORE(QdcApi this$0) {
        }

        public class FUNCTIONS {
            public FUNCTIONS(QDC_CORE this$1) {
            }

            public static void save(Player player) {
                MainBox.saveData(player);
            }

            public static void addParticles(ParticleCollection particles) {
                MainBox.PARTICLE_BOX.addParticles(particles);
            }

            public static void addParticlesLong(ENUMS.ParticleType type, long amount) {
                MainBox.PARTICLE_BOX.addParticlesLong(type, amount);
            }

            public static void addParticles(ParticleCollection particles, int count, boolean ignoreMana) {
                MainBox.PARTICLE_BOX.addParticles(particles, count, ignoreMana);
            }

            public static boolean haveEnoughParticles(ENUMS.ParticleType type, double amount) {
                return MainBox.PARTICLE_BOX.hasEnoughParticles(type, amount);
            }

            public static void removeParticles(ParticleCollection particles) {
                MainBox.PARTICLE_BOX.removeParticles(particles);
            }

            public static void removeParticlesLong(ENUMS.ParticleType type, long amount) {
                MainBox.PARTICLE_BOX.removeParticlesLong(type, amount);
            }

            public static boolean canRemoveParticles(ParticleCollection particles) {
                return MainBox.PARTICLE_BOX.checkCanRemoveParticles(particles);
            }

            public static boolean isItemDiscovered(Item item) {
                return MainBox.isItemDiscovered(item);
            }

            public static boolean itemHasParticles(Item item) {
                return MainBox.ITEM_BOX.allowItemDisassemble(item);
            }

            public static String getParticleAmount(ENUMS.ParticleType type) {
                return MainBox.PARTICLE_BOX.getParticleStringFormatted(type);
            }

            public static BigDecimal getParticleAmountBigDecimal(ENUMS.ParticleType type) {
                return MainBox.PARTICLE_BOX.getParticleAmount(type);
            }

            public static String getParticleAmountShort(ENUMS.ParticleType type) {
                return MainBox.PARTICLE_BOX.getParticleStringShort(type);
            }

            public static Item getParticleIconItem(ENUMS.ParticleType type) {
                return ParticleFunctions.getParticleIconItem(type);
            }

            public static Color getParticleTextColor(ENUMS.ParticleType type) {
                return ParticleFunctions.getParticleTextColor(type);
            }

            public static ParticleCollection getItemParticles(Item item) {
                return MainBox.ITEM_BOX.getItemParticles(new ItemStack((ItemLike)item));
            }

            public static int getItemStorageCount(Item item) {
                return MainBox.DISCOVERY_BOX.getItemCount(item);
            }

            public static void removeFromStorage(Item item, int amount) {
                MainBox.DISCOVERY_BOX.reduceItemCount(new DiscoveryItem(item, amount));
            }

            public static int getCanCreateCount(ENUMS.ParticleType type, double particleAmount) {
                return MainBox.PARTICLE_BOX.getCreateAmount(type, particleAmount);
            }
        }

        public class ITEMS {
            public static final Item QDC_MAIN_ITEM = (Item)ItemInit.QDC_MAIN_ITEM.get();
            public static final Item QUANTUM_CORE = (Item)ItemInit.QUANTUM_CORE.get();
            public static final Item QUANTUM_TRANSMITTER = (Item)ItemInit.QUANTUM_TRANSMITTER.get();
            public static final Item QUANTUM_RECIEVER = (Item)ItemInit.QUANTUM_RECIEVER.get();
            public static final Item QUANTUM_KNOWLEDGE = (Item)ItemInit.QUANTUM_KNOWLEDGE.get();
            public static final Item QUANTUM_COMPACT_CORE = (Item)ItemInit.QUANTUM_COMPACT_CORE.get();
            public static final Item QUANTUM_COMPACT_TRANSMITTER = (Item)ItemInit.QUANTUM_COMPACT_TRANSMITTER.get();
            public static final Item QUANTUM_COMPACT_RECIEVER = (Item)ItemInit.QUANTUM_COMPACT_RECIEVER.get();

            public ITEMS(QDC_CORE this$1) {
            }

            public class MACHINE_CORES {
                public static final Item CORE_WOOD = (Item)ItemInit.QUANTUM_CORE_WOOD.get();
                public static final Item CORE_STONE = (Item)ItemInit.QUANTUM_CORE_STONE.get();
                public static final Item CORE_IRON = (Item)ItemInit.QUANTUM_CORE_IRON.get();
                public static final Item CORE_GOLD = (Item)ItemInit.QUANTUM_CORE_GOLD.get();
                public static final Item CORE_DIAMOND = (Item)ItemInit.QUANTUM_CORE_DIAMOND.get();
                public static final Item CORE_EMERALD = (Item)ItemInit.QUANTUM_CORE_EMERALD.get();
                public static final Item CORE_NETHERITE = (Item)ItemInit.QUANTUM_CORE_NETHERITE.get();

                public MACHINE_CORES(ITEMS this$2) {
                }
            }

            public class PARTICLE_ITEM {
                public static final Item NATURE = (Item)ItemInit.PARTICLES_NATURE.get();
                public static final Item FOOD = (Item)ItemInit.PARTICLES_FOOD.get();
                public static final Item METAL = (Item)ItemInit.PARTICLES_METAL.get();
                public static final Item GEM = (Item)ItemInit.PARTICLES_GEM.get();
                public static final Item CORRUPTION = (Item)ItemInit.PARTICLES_CORRUPTION.get();
                public static final Item MANA = (Item)ItemInit.PARTICLES_MANA.get();

                public PARTICLE_ITEM(ITEMS this$2) {
                }
            }

            public class PARTICLE_ICON {
                public static final Item NATURE = Items.POPPY;
                public static final Item FOOD = Items.APPLE;
                public static final Item METAL = Items.IRON_INGOT;
                public static final Item GEM = Items.DIAMOND;
                public static final Item CORRUPTION = Items.ALLIUM;
                public static final Item MANA = Items.EXPERIENCE_BOTTLE;

                public PARTICLE_ICON(ITEMS this$2) {
                }
            }
        }
    }
}

